/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import java.nio.charset.Charset;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessDisconnectChannelMessage
extends ChannelAccessMessage {
    private int cid;
    private int sid;

    public ChannelAccessDisconnectChannelMessage(int cid, int sid) {
        super(ChannelAccessCommand.CA_PROTO_CLEAR_CHANNEL);
        this.cid = cid;
        this.sid = sid;
    }

    private ChannelAccessDisconnectChannelMessage(ChannelAccessMessageHeader messageHeader, int cid, int sid) {
        super(ChannelAccessCommand.CA_PROTO_CLEAR_CHANNEL, messageHeader);
        this.cid = cid;
        this.sid = sid;
    }

    public int getChannelCID() {
        return this.cid;
    }

    public int getChannelSID() {
        return this.sid;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        this.serializeHeader(byteSink, 0, (short)0, 0, this.sid, this.cid, version, maxPayloadSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessDisconnectChannelMessage other = (ChannelAccessDisconnectChannelMessage)obj;
        return new EqualsBuilder().append(this.cid, other.cid).append(this.sid, other.sid).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.cid).append(this.sid).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("cid=");
        sb.append(this.cid);
        sb.append(", sid=");
        sb.append(this.sid);
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessDisconnectChannelMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, boolean headerOnly) {
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_CLEAR_CHANNEL.getCommandNumber());
        if (!headerOnly) {
            byteSource.skip(messageHeader.getPayloadSize());
        }
        return new ChannelAccessDisconnectChannelMessage(messageHeader, messageHeader.getContextSpecific(), messageHeader.getCID());
    }
}

