/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import java.nio.charset.Charset;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessEchoMessage
extends ChannelAccessMessage {
    private short dataType = 0;
    private int count = 0;
    private int cid = 0;
    private int contextSpecific = 0;
    private byte[] payload = ArrayUtils.EMPTY_BYTE_ARRAY;

    public ChannelAccessEchoMessage() {
        super(ChannelAccessCommand.CA_PROTO_ECHO);
    }

    private ChannelAccessEchoMessage(ChannelAccessMessageHeader messageHeader) {
        super(ChannelAccessCommand.CA_PROTO_ECHO, messageHeader);
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (this.payload == null) {
            throw new UnsupportedOperationException("Cannot serialize the message payload for a message that has been constructed without the payload.");
        }
        this.serializeHeader(byteSink, this.payload.length, this.dataType, this.count, this.cid, this.contextSpecific, version, maxPayloadSize);
        byteSink.putByteArray(this.payload);
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (this.payload == null) {
            throw new UnsupportedOperationException("Cannot serialize the message payload for a message that has been constructed without the payload.");
        }
        this.verifyHeader(this.payload.length, this.count, version, maxPayloadSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessEchoMessage other = (ChannelAccessEchoMessage)obj;
        return new EqualsBuilder().append(this.dataType, other.dataType).append(this.count, other.count).append(this.cid, other.cid).append(this.contextSpecific, other.contextSpecific).append(this.payload, other.payload).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.dataType).append(this.count).append(this.cid).append(this.contextSpecific).append(this.payload).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("dataType=");
        sb.append(this.dataType);
        sb.append(", count=");
        sb.append(this.count);
        sb.append(", cid=");
        sb.append(this.cid);
        sb.append(", contextSpecific=");
        sb.append(this.contextSpecific);
        sb.append(", payload=");
        ChannelAccessEchoMessage.addByteArrayToStringBuilder(sb, this.payload);
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessEchoMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, boolean headerOnly) {
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_ECHO.getCommandNumber());
        ChannelAccessEchoMessage message = new ChannelAccessEchoMessage(messageHeader);
        message.dataType = messageHeader.getDataType();
        message.count = messageHeader.getCount();
        message.cid = messageHeader.getCID();
        message.contextSpecific = messageHeader.getContextSpecific();
        if (headerOnly) {
            message.payload = null;
        } else {
            byte[] payload = byteSource.getByteArray(messageHeader.getPayloadSize());
            message.payload = payload;
        }
        return message;
    }
}

