/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageCodec;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessStatus;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.util.NullTerminatedStringUtil;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.Pair;

public final class ChannelAccessErrorMessage
extends ChannelAccessMessage {
    public static final int UNKNOWN_CHANNEL_CID = -1;
    private int cid;
    private ChannelAccessStatus status;
    private ChannelAccessMessage originalMessage;
    private String messageString;

    public ChannelAccessErrorMessage(int channelCID, ChannelAccessStatus status, ChannelAccessMessage originalMessage, String messageString) {
        super(ChannelAccessCommand.CA_PROTO_ERROR);
        if (status == null) {
            throw new NullPointerException("Status must not be null.");
        }
        if (originalMessage == null && messageString != null && !messageString.isEmpty()) {
            throw new IllegalArgumentException("Message string cannot have a value if original message is null.");
        }
        if (originalMessage != null && !originalMessage.hasOriginalMessageHeader()) {
            throw new IllegalArgumentException("The original message must have its original message headers (must have been decoded from its binary representation).");
        }
        this.cid = channelCID;
        this.status = status;
        this.originalMessage = originalMessage;
        if (messageString == null) {
            messageString = "";
        }
        this.messageString = messageString;
    }

    private ChannelAccessErrorMessage(ChannelAccessMessageHeader messageHeader, int channelCID, ChannelAccessStatus status, ChannelAccessMessage originalMessage, String messageString) {
        super(ChannelAccessCommand.CA_PROTO_ERROR, messageHeader);
        this.cid = channelCID;
        this.status = status;
        this.originalMessage = originalMessage;
        if (messageString == null) {
            messageString = "";
        }
        this.messageString = messageString;
    }

    public int getChannelCID() {
        return this.cid;
    }

    public ChannelAccessStatus getStatus() {
        return this.status;
    }

    public ChannelAccessMessage getOriginalMessage() {
        return this.originalMessage;
    }

    public String getMessageString() {
        return this.messageString;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        byte[] serializedMessageString = null;
        int serializedMessageStringLength = 0;
        if (this.messageString != null && !this.messageString.isEmpty()) {
            Pair<byte[], Integer> serializedMessageStringWithLength = NullTerminatedStringUtil.stringToTruncatedNullTerminatedBytes(this.messageString, 0x7FFFFFCF, 8, charset);
            serializedMessageString = (byte[])serializedMessageStringWithLength.getLeft();
            serializedMessageStringLength = (Integer)serializedMessageStringWithLength.getRight();
        }
        int payloadSize = 0;
        if (this.originalMessage != null && this.originalMessage.hasOriginalMessageHeader()) {
            payloadSize += this.originalMessage.getOriginalMessageHeader().getHeaderSize();
            if (serializedMessageString != null) {
                payloadSize += serializedMessageStringLength;
            }
        }
        this.serializeHeader(byteSink, payloadSize, (short)0, 0, this.cid, this.status.toStatusCode(), version, maxPayloadSize);
        if (payloadSize > 0) {
            ChannelAccessErrorMessage.serializeOriginalHeader(byteSink, this.originalMessage.getOriginalMessageHeader());
            if (serializedMessageString != null) {
                byteSink.putByteArray(serializedMessageString, 0, serializedMessageStringLength);
            }
        }
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        byte[] serializedMessageString = null;
        int serializedMessageStringLength = 0;
        if (this.messageString != null && !this.messageString.isEmpty()) {
            Pair<byte[], Integer> serializedMessageStringWithLength = NullTerminatedStringUtil.stringToTruncatedNullTerminatedBytes(this.messageString, 0x7FFFFFCF, 8, charset);
            serializedMessageString = (byte[])serializedMessageStringWithLength.getLeft();
            serializedMessageStringLength = (Integer)serializedMessageStringWithLength.getRight();
        }
        int payloadSize = 0;
        if (this.originalMessage != null && this.originalMessage.hasOriginalMessageHeader()) {
            payloadSize += this.originalMessage.getOriginalMessageHeader().getHeaderSize();
            if (serializedMessageString != null) {
                payloadSize += serializedMessageStringLength;
            }
        }
        this.verifyHeader(payloadSize, 0, version, maxPayloadSize);
    }

    private static void serializeOriginalHeader(ByteSink byteSink, ChannelAccessMessageHeader originalHeader) {
        int payloadSize = originalHeader.getPayloadSize();
        int count = originalHeader.getCount();
        boolean needLargeHeader = payloadSize >= 65535 || count > 65535;
        byteSink.putShort(originalHeader.getCommand());
        if (needLargeHeader) {
            byteSink.putShort((short)-1);
        } else {
            byteSink.putShort((short)payloadSize);
        }
        byteSink.putShort(originalHeader.getDataType());
        if (needLargeHeader) {
            byteSink.putShort((short)0);
        } else {
            byteSink.putShort((short)count);
        }
        byteSink.putInt(originalHeader.getCID());
        byteSink.putInt(originalHeader.getContextSpecific());
        if (needLargeHeader) {
            byteSink.putInt(payloadSize);
            byteSink.putInt(count);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessErrorMessage other = (ChannelAccessErrorMessage)obj;
        return new EqualsBuilder().append(this.cid, other.cid).append((Object)this.status, (Object)other.status).append((Object)this.originalMessage, (Object)other.originalMessage).append((Object)this.messageString, (Object)other.messageString).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.cid).append((Object)this.status).append((Object)this.originalMessage).append((Object)this.messageString).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("cid=");
        sb.append(this.cid);
        sb.append(", status=");
        sb.append(this.status != null ? this.status.getMessage().name() : "null");
        sb.append(", originalMessage=");
        sb.append(this.originalMessage);
        sb.append(", messageString=");
        if (this.messageString != null) {
            sb.append('\"');
            sb.append(StringEscapeUtils.escapeJava((String)this.messageString));
            sb.append('\"');
        } else {
            sb.append("null");
        }
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessErrorMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, Charset charset, ChannelAccessVersion version, boolean isTCP) {
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_ERROR.getCommandNumber());
        ChannelAccessMessageHeader originalMessageHeader = null;
        ChannelAccessMessage originalMessage = null;
        int payloadSize = messageHeader.getPayloadSize();
        if (payloadSize >= 16) {
            originalMessageHeader = ChannelAccessErrorMessage.decodeMessageHeader(byteSource, payloadSize >= 24);
            try {
                originalMessage = isTCP ? ChannelAccessMessageCodec.decodeMessageToTCPServer(originalMessageHeader, null, true, charset, 0, version) : ChannelAccessMessageCodec.decodeMessageToUDPServer(originalMessageHeader, null, true, charset, 0, version);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String messageString = null;
        if (originalMessageHeader != null && payloadSize > originalMessageHeader.getHeaderSize()) {
            byte[] serializedMessageString = byteSource.getByteArray(payloadSize - originalMessageHeader.getHeaderSize());
            messageString = NullTerminatedStringUtil.nullTerminatedBytesToString(serializedMessageString, charset);
        }
        return new ChannelAccessErrorMessage(messageHeader, messageHeader.getCID(), ChannelAccessStatus.forStatusCode(messageHeader.getContextSpecific()), originalMessage, messageString);
    }

    private static ChannelAccessMessageHeader decodeMessageHeader(ByteSource byteSource, boolean allowLargeHeader) {
        int largeCount;
        int largePayloadSize;
        boolean largeHeader;
        short command = byteSource.getShort();
        short payloadSize = byteSource.getShort();
        short dataType = byteSource.getShort();
        short count = byteSource.getShort();
        int cid = byteSource.getInt();
        int contextSpecific = byteSource.getInt();
        if (payloadSize == -1 && allowLargeHeader) {
            largeHeader = true;
            largePayloadSize = byteSource.getInt();
            largeCount = byteSource.getInt();
        } else {
            largeHeader = false;
            largePayloadSize = payloadSize & 0xFFFF;
            largeCount = count & 0xFFFF;
        }
        return new ChannelAccessMessageHeader(command, largePayloadSize, dataType, largeCount, cid, contextSpecific, largeHeader);
    }
}

