/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessEventMask {
    private static final ChannelAccessEventMask[] ALL_MASKS = new ChannelAccessEventMask[16];
    public static final ChannelAccessEventMask DBE_NONE;
    public static final ChannelAccessEventMask DBE_VALUE;
    public static final ChannelAccessEventMask DBE_ARCHIVE;
    public static final ChannelAccessEventMask DBE_ALARM;
    public static final ChannelAccessEventMask DBE_PROPERTY;
    public static final ChannelAccessEventMask DBE_ALL;
    private final int eventMask;
    private final int hashCode;

    private ChannelAccessEventMask(int eventMask) {
        this.eventMask = eventMask;
        this.hashCode = new HashCodeBuilder(89, 23).append(eventMask).toHashCode();
    }

    public ChannelAccessEventMask and(ChannelAccessEventMask other) {
        return ALL_MASKS[this.eventMask & other.eventMask];
    }

    public ChannelAccessEventMask or(ChannelAccessEventMask other) {
        return ALL_MASKS[this.eventMask | other.eventMask];
    }

    public ChannelAccessEventMask not() {
        return ALL_MASKS[~this.eventMask & 0xF];
    }

    public boolean isAny() {
        return this.eventMask != 0;
    }

    public boolean isValue() {
        return this.and(DBE_VALUE).isAny();
    }

    public ChannelAccessEventMask setValue(boolean flag) {
        if (flag) {
            return this.or(DBE_VALUE);
        }
        return this.and(DBE_VALUE.not());
    }

    public boolean isArchive() {
        return this.and(DBE_ARCHIVE).isAny();
    }

    public ChannelAccessEventMask setArchive(boolean flag) {
        if (flag) {
            return this.or(DBE_ARCHIVE);
        }
        return this.and(DBE_ARCHIVE.not());
    }

    public boolean isAlarm() {
        return this.and(DBE_ALARM).isAny();
    }

    public ChannelAccessEventMask setAlarm(boolean flag) {
        if (flag) {
            return this.or(DBE_ALARM);
        }
        return this.and(DBE_ALARM.not());
    }

    public boolean isProperty() {
        return this.and(DBE_PROPERTY).isAny();
    }

    public ChannelAccessEventMask setProperty(boolean flag) {
        if (flag) {
            return this.or(DBE_PROPERTY);
        }
        return this.and(DBE_PROPERTY.not());
    }

    public short toNumericMask() {
        return (short)this.eventMask;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        if (this.eventMask == 0) {
            return "DBE_NONE";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (this.isValue()) {
            sb.append("DBE_VALUE");
            first = false;
        }
        if (this.isArchive()) {
            if (!first) {
                sb.append('|');
            }
            sb.append("DBE_ARCHIVE");
            first = false;
        }
        if (this.isAlarm()) {
            if (!first) {
                sb.append('|');
            }
            sb.append("DBE_ALARM");
            first = false;
        }
        if (this.isProperty()) {
            if (!first) {
                sb.append('|');
            }
            sb.append("DBE_PROPERTY");
            first = false;
        }
        return sb.toString();
    }

    public static ChannelAccessEventMask forNumericMask(short mask) {
        return ALL_MASKS[mask & 0xF];
    }

    static {
        for (int i = 0; i < ALL_MASKS.length; ++i) {
            ChannelAccessEventMask.ALL_MASKS[i] = new ChannelAccessEventMask(i);
        }
        DBE_NONE = ALL_MASKS[0];
        DBE_VALUE = ALL_MASKS[1];
        DBE_ARCHIVE = ALL_MASKS[2];
        DBE_ALARM = ALL_MASKS[4];
        DBE_PROPERTY = ALL_MASKS[8];
        DBE_ALL = ALL_MASKS[15];
    }
}

