/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.exception.UnsupportedInThisVersionException;
import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.util.NullTerminatedStringUtil;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.Pair;

public final class ChannelAccessHostNameMessage
extends ChannelAccessMessage {
    private static final int OLD_PROTOCOL_MAX_PAYLOAD_SIZE = 65528;
    private String hostName;

    public ChannelAccessHostNameMessage(String hostName) {
        super(ChannelAccessCommand.CA_PROTO_HOST_NAME);
        if (hostName == null) {
            throw new NullPointerException("Host name must not be null.");
        }
        this.hostName = hostName;
    }

    private ChannelAccessHostNameMessage(ChannelAccessMessageHeader messageHeader, String hostName) {
        super(ChannelAccessCommand.CA_PROTO_HOST_NAME, messageHeader);
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (!version.includes(ChannelAccessVersion.V4_1)) {
            throw new UnsupportedInThisVersionException(version, ChannelAccessCommand.CA_PROTO_HOST_NAME);
        }
        if (this.hostName == null) {
            throw new UnsupportedOperationException("Cannot serialize the message payload for a message that has been constructed without the payload.");
        }
        Pair<byte[], Integer> hostNameBytesWithLength = NullTerminatedStringUtil.stringToTruncatedNullTerminatedBytes(this.hostName, ChannelAccessHostNameMessage.calculateMaxPayloadSize(version, maxPayloadSize), 8, charset);
        byte[] hostNameAsBytes = (byte[])hostNameBytesWithLength.getLeft();
        int hostNameLength = (Integer)hostNameBytesWithLength.getRight();
        this.serializeHeader(byteSink, hostNameLength, (short)0, 0, 0, 0, version, maxPayloadSize);
        byteSink.putByteArray(hostNameAsBytes, 0, hostNameLength);
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (!version.includes(ChannelAccessVersion.V4_1)) {
            throw new UnsupportedInThisVersionException(version, ChannelAccessCommand.CA_PROTO_HOST_NAME);
        }
        if (this.hostName == null) {
            throw new UnsupportedOperationException("Cannot serialize the message payload for a message that has been constructed without the payload.");
        }
    }

    private static int calculateMaxPayloadSize(ChannelAccessVersion version, int maxPayloadSize) {
        if (!version.includes(ChannelAccessVersion.V4_9) && maxPayloadSize > 65528) {
            return 65528;
        }
        return maxPayloadSize;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessHostNameMessage other = (ChannelAccessHostNameMessage)obj;
        return new EqualsBuilder().append((Object)this.hostName, (Object)other.hostName).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.hostName).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("hostName=");
        if (this.hostName != null) {
            sb.append('\"');
            sb.append(StringEscapeUtils.escapeJava((String)this.hostName));
            sb.append('\"');
        } else {
            sb.append("null");
        }
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessHostNameMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, boolean headerOnly, Charset deserialize) {
        String hostName;
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_HOST_NAME.getCommandNumber());
        if (!headerOnly) {
            byte[] hostNameAsBytes = byteSource.getByteArray(messageHeader.getPayloadSize());
            hostName = NullTerminatedStringUtil.nullTerminatedBytesToString(hostNameAsBytes, deserialize);
        } else {
            hostName = null;
        }
        return new ChannelAccessHostNameMessage(messageHeader, hostName);
    }
}

