/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.exception.SerializedPayloadTooLargeException;
import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import java.nio.charset.Charset;

public abstract class ChannelAccessMessage {
    protected ChannelAccessCommand command;
    protected ChannelAccessMessageHeader originalMessageHeader;

    ChannelAccessMessage(ChannelAccessCommand command) {
        assert (command != null);
        this.command = command;
    }

    ChannelAccessMessage(ChannelAccessCommand command, ChannelAccessMessageHeader messageHeader) {
        assert (command != null);
        this.command = command;
        this.originalMessageHeader = messageHeader;
    }

    protected abstract void serialize(ByteSink var1, ChannelAccessVersion var2, int var3, Charset var4);

    protected ChannelAccessMessageHeader getOriginalMessageHeader() {
        if (this.originalMessageHeader == null) {
            throw new UnsupportedOperationException("This message has not been constructed from a serialized form.");
        }
        return this.originalMessageHeader;
    }

    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
    }

    protected void verifyHeader(int payloadSize, int count, ChannelAccessVersion version, int maxPayloadSize) {
        assert (maxPayloadSize >= 0);
        if (payloadSize < 0) {
            throw new SerializedPayloadTooLargeException("Cannot send message with payload size " + ((long)payloadSize & 0xFFFFFFFFL) + " because payload size limit is set to " + maxPayloadSize + ".");
        }
        if (payloadSize % 8 != 0) {
            throw new IllegalArgumentException("Payload size of " + payloadSize + " bytes is not aligned to 8 bytes.");
        }
        if (!(payloadSize < 65535 && count <= 65535 || version.includes(ChannelAccessVersion.V4_9))) {
            throw new SerializedPayloadTooLargeException("Cannot send message with payload size " + payloadSize + " and count " + count + " over Channel Access version " + version + ".");
        }
        if (payloadSize > maxPayloadSize) {
            throw new SerializedPayloadTooLargeException("Cannot send message with payload size " + payloadSize + " because payload size limit is set to " + maxPayloadSize + ".");
        }
    }

    protected boolean hasOriginalMessageHeader() {
        return this.originalMessageHeader != null;
    }

    protected void serializeHeader(ByteSink byteSink, int payloadSize, short dataType, int count, int cid, int contextSpecific, ChannelAccessVersion version, int maxPayloadSize) {
        assert (maxPayloadSize >= 0);
        if (payloadSize < 0) {
            throw new SerializedPayloadTooLargeException("Cannot send message with payload size " + ((long)payloadSize & 0xFFFFFFFFL) + " because payload size limit is set to " + maxPayloadSize + ".");
        }
        if (payloadSize % 8 != 0) {
            throw new IllegalArgumentException("Payload size of " + payloadSize + " bytes is not aligned to 8 bytes.");
        }
        boolean needLargeHeader = payloadSize >= 65535 || count > 65535;
        if (needLargeHeader && !version.includes(ChannelAccessVersion.V4_9)) {
            throw new SerializedPayloadTooLargeException("Cannot send message with payload size " + payloadSize + " and count " + count + " over Channel Access version " + version + ".");
        }
        if (payloadSize > maxPayloadSize) {
            throw new SerializedPayloadTooLargeException("Cannot send message with payload size " + payloadSize + " because payload size limit is set to " + maxPayloadSize + ".");
        }
        byteSink.putShort(this.command.getCommandNumber());
        if (needLargeHeader) {
            byteSink.putShort((short)-1);
        } else {
            byteSink.putShort((short)payloadSize);
        }
        byteSink.putShort(dataType);
        if (needLargeHeader) {
            byteSink.putShort((short)0);
        } else {
            byteSink.putShort((short)count);
        }
        byteSink.putInt(cid);
        byteSink.putInt(contextSpecific);
        if (needLargeHeader) {
            byteSink.putInt(payloadSize);
            byteSink.putInt(count);
        }
    }

    protected static int calculatePaddingSize(int payloadSize) {
        if (payloadSize > 0x7FFFFFF8) {
            throw new IllegalArgumentException("Aligning the payload size would exceed Integer.MAX_VALUE.");
        }
        return 7 - (payloadSize + 7) % 8;
    }

    public ChannelAccessCommand getCommand() {
        return this.command;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ChannelAccessMessage other = (ChannelAccessMessage)obj;
        return this.command == other.command;
    }

    public int hashCode() {
        return this.command.hashCode();
    }

    public String toString() {
        return this.command.toString();
    }

    protected static void addByteArrayToStringBuilder(StringBuilder sb, byte[] byteArray) {
        if (byteArray == null) {
            sb.append("null");
            return;
        }
        sb.append('[');
        boolean first = true;
        for (byte b : byteArray) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("0x");
            if (b < 16 && b >= 0) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(b & 0xFF));
        }
        sb.append(']');
    }
}

