/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.exception.BufferUnderflowWithSizeException;
import com.aquenos.epics.jackie.common.exception.MalformedMessageException;
import com.aquenos.epics.jackie.common.exception.ReceivedMessageTooLargeException;
import com.aquenos.epics.jackie.common.exception.UnsupportedMessageTypeException;
import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessAccessRightsMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessBeaconMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCancelSubscriptionClientMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCancelSubscriptionServerMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessChannelDisconnectedByServerMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessConnectChannelClientMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessConnectChannelFailedMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessConnectChannelServerMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessDisconnectChannelMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessEchoMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessErrorMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessEventsOffMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessEventsOnMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessHostNameMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessNotFoundMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessReadBuildMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessReadClientMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessReadNotifyClientMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessReadNotifyServerMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessReadServerMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessReadSyncMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessRepeaterConfirmMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessRepeaterRegisterMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessSearchClientMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessSearchTCPServerMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessSearchUDPServerMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessSubscriptionClientMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessSubscriptionServerMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessUserNameMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersionTCPClientMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersionTCPServerMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersionUDPMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessWriteMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessWriteNotifyClientMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessWriteNotifyServerMessage;
import java.net.Inet4Address;
import java.nio.BufferUnderflowException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ChannelAccessMessageCodec {
    public static final int MIN_MAX_PAYLOAD_SIZE = 16384;
    public static final int MAX_MAX_PAYLOAD_SIZE = 2147483616;
    private int maxPayloadReceiveSize = 16384;
    private int maxPayloadSendSize = 16384;
    private Charset charset = StandardCharsets.UTF_8;

    public int getMaxPayloadReceiveSize() {
        return this.maxPayloadReceiveSize;
    }

    public void setMaxPayloadReceiveSize(int maxPayloadReceiveSize) {
        if (maxPayloadReceiveSize < 16384) {
            throw new IllegalArgumentException("Maximum payload-size must be at least 16384.");
        }
        if (maxPayloadReceiveSize > 2147483616) {
            throw new IllegalArgumentException("Maximum payload-size must not be greater than 2147483616");
        }
        this.maxPayloadReceiveSize = maxPayloadReceiveSize - maxPayloadReceiveSize % 8;
    }

    public int getMaxPayloadSendSize() {
        return this.maxPayloadSendSize;
    }

    public void setMaxPayloadSendSize(int maxPayloadSendSize) {
        if (maxPayloadSendSize < 16384) {
            throw new IllegalArgumentException("Maximum payload-size must be at least 16384.");
        }
        this.maxPayloadSendSize = maxPayloadSendSize - maxPayloadSendSize % 8;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("Charset must not be null.");
        }
        this.charset = charset;
    }

    private void encodeMessageInternal(final ByteSink byteSink, final ChannelAccessMessage message, final ChannelAccessVersion version) {
        byteSink.atomicPut(new ByteSink.AtomicPutOperation<Void>(){

            @Override
            public Void put() {
                message.serialize(byteSink, version, ChannelAccessMessageCodec.this.maxPayloadSendSize, ChannelAccessMessageCodec.this.charset);
                return null;
            }
        });
    }

    public void encodeMessageToUDPServer(ByteSink byteSink, ChannelAccessMessage message, ChannelAccessVersion version) {
        if (!(message instanceof ChannelAccessVersionUDPMessage) && !(message instanceof ChannelAccessSearchClientMessage)) {
            throw new IllegalArgumentException("Cannot send message of type " + message.getClass().getName() + " to UDP server.");
        }
        this.encodeMessageInternal(byteSink, message, version);
    }

    public void encodeMessageToUDPClient(ByteSink byteSink, ChannelAccessMessage message, ChannelAccessVersion version) {
        if (!(message instanceof ChannelAccessVersionUDPMessage || message instanceof ChannelAccessSearchUDPServerMessage || message instanceof ChannelAccessEchoMessage || message instanceof ChannelAccessErrorMessage || message instanceof ChannelAccessNotFoundMessage)) {
            throw new IllegalArgumentException("Cannot send message of type " + message.getClass().getName() + " to UDP client.");
        }
        this.encodeMessageInternal(byteSink, message, version);
    }

    public void encodeMessageToRepeater(ByteSink byteSink, ChannelAccessMessage message, ChannelAccessVersion version) {
        if (!(message instanceof ChannelAccessBeaconMessage)) {
            throw new IllegalArgumentException("Cannot send message of type " + message.getClass().getName() + " to repeater.");
        }
        this.encodeMessageInternal(byteSink, message, version);
    }

    public void encodeMessageFromRepeater(ByteSink byteSink, ChannelAccessMessage message, ChannelAccessVersion version) {
        if (!(message instanceof ChannelAccessVersionUDPMessage || message instanceof ChannelAccessRepeaterConfirmMessage || message instanceof ChannelAccessBeaconMessage)) {
            throw new IllegalArgumentException("Cannot send message of type " + message.getClass().getName() + " from repeater.");
        }
        this.encodeMessageInternal(byteSink, message, version);
    }

    public void encodeMessageToTCPServer(ByteSink byteSink, ChannelAccessMessage message, ChannelAccessVersion version) {
        if (!(message instanceof ChannelAccessVersionTCPClientMessage || message instanceof ChannelAccessSubscriptionClientMessage || message instanceof ChannelAccessCancelSubscriptionClientMessage || message instanceof ChannelAccessReadClientMessage || message instanceof ChannelAccessWriteMessage || message instanceof ChannelAccessEventsOffMessage || message instanceof ChannelAccessEventsOnMessage || message instanceof ChannelAccessReadSyncMessage || message instanceof ChannelAccessDisconnectChannelMessage || message instanceof ChannelAccessReadNotifyClientMessage || message instanceof ChannelAccessConnectChannelClientMessage || message instanceof ChannelAccessWriteNotifyClientMessage || message instanceof ChannelAccessUserNameMessage || message instanceof ChannelAccessHostNameMessage || message instanceof ChannelAccessEchoMessage || message instanceof ChannelAccessSearchClientMessage)) {
            throw new IllegalArgumentException("Cannot send message of type " + message.getClass().getName() + " to TCP server.");
        }
        this.encodeMessageInternal(byteSink, message, version);
    }

    public void encodeMessageToTCPClient(ByteSink byteSink, ChannelAccessMessage message, ChannelAccessVersion version) {
        if (!(message instanceof ChannelAccessVersionTCPServerMessage || message instanceof ChannelAccessSubscriptionServerMessage || message instanceof ChannelAccessCancelSubscriptionServerMessage || message instanceof ChannelAccessReadServerMessage || message instanceof ChannelAccessReadSyncMessage || message instanceof ChannelAccessErrorMessage || message instanceof ChannelAccessDisconnectChannelMessage || message instanceof ChannelAccessReadNotifyServerMessage || message instanceof ChannelAccessConnectChannelServerMessage || message instanceof ChannelAccessWriteNotifyServerMessage || message instanceof ChannelAccessAccessRightsMessage || message instanceof ChannelAccessEchoMessage || message instanceof ChannelAccessConnectChannelFailedMessage || message instanceof ChannelAccessChannelDisconnectedByServerMessage || message instanceof ChannelAccessSearchTCPServerMessage || message instanceof ChannelAccessNotFoundMessage)) {
            throw new IllegalArgumentException("Cannot send message of type " + message.getClass().getName() + " to TCP client.");
        }
        this.encodeMessageInternal(byteSink, message, version);
    }

    private static ChannelAccessMessageHeader decodeMessageHeader(ByteSource byteSource) {
        int largeCount;
        int largePayloadSize;
        boolean largeHeader;
        int contextSpecific;
        int cid;
        short count;
        short dataType;
        short payloadSize;
        short command;
        try {
            command = byteSource.getShort();
            payloadSize = byteSource.getShort();
            dataType = byteSource.getShort();
            count = byteSource.getShort();
            cid = byteSource.getInt();
            contextSpecific = byteSource.getInt();
        }
        catch (BufferUnderflowException e) {
            throw new BufferUnderflowWithSizeException(16);
        }
        if (payloadSize == -1) {
            largeHeader = true;
            try {
                largePayloadSize = byteSource.getInt();
                largeCount = byteSource.getInt();
            }
            catch (BufferUnderflowException e) {
                throw new BufferUnderflowWithSizeException(24);
            }
        } else {
            largeHeader = false;
            largePayloadSize = payloadSize & 0xFFFF;
            largeCount = count & 0xFFFF;
        }
        return new ChannelAccessMessageHeader(command, largePayloadSize, dataType, largeCount, cid, contextSpecific, largeHeader);
    }

    public long discardNextMessage(final ByteSource byteSource) {
        return byteSource.atomicGet(new ByteSource.AtomicGetOperation<Long>(){

            @Override
            public Long get() {
                ChannelAccessMessageHeader messageHeader = ChannelAccessMessageCodec.decodeMessageHeader(byteSource);
                long payloadSize = (long)messageHeader.getPayloadSize() & 0xFFFFFFFFL;
                while (byteSource.remaining() != 0) {
                    int remaining = byteSource.remaining();
                    if ((long)remaining < payloadSize) {
                        byteSource.skip(remaining);
                        payloadSize -= (long)remaining;
                        continue;
                    }
                    byteSource.skip((int)payloadSize);
                    payloadSize = 0L;
                    break;
                }
                return payloadSize;
            }
        });
    }

    public void discardNextMessageCompletely(final ByteSource byteSource) {
        byteSource.atomicGet(new ByteSource.AtomicGetOperation<Void>(){

            @Override
            public Void get() {
                long payloadSize;
                ChannelAccessMessageHeader messageHeader = ChannelAccessMessageCodec.decodeMessageHeader(byteSource);
                for (payloadSize = (long)messageHeader.getPayloadSize() & 0xFFFFFFFFL; payloadSize > Integer.MAX_VALUE; payloadSize -= Integer.MAX_VALUE) {
                    byteSource.skip(Integer.MAX_VALUE);
                }
                byteSource.skip((int)payloadSize);
                return null;
            }
        });
    }

    private static ChannelAccessCommand checkMessageHeaderAndGetCommand(ChannelAccessMessageHeader messageHeader, int maxPayloadSize) {
        int payloadSize = messageHeader.getPayloadSize();
        if (payloadSize < 0 || payloadSize > maxPayloadSize) {
            throw new ReceivedMessageTooLargeException("Message with payload size " + ((long)payloadSize & 0xFFFFFFFFL) + " is larger than limit (" + maxPayloadSize + ").");
        }
        if (payloadSize % 8 != 0) {
            throw new MalformedMessageException("Payload size of received message (" + payloadSize + " bytes) is not aligned to 8 bytes.");
        }
        try {
            return ChannelAccessCommand.forCommandNumber(messageHeader.getCommand());
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedMessageTypeException("Command number " + messageHeader.getCommand() + " does not refer to a well-known command.", e);
        }
    }

    private static void checkPayloadAvailable(ChannelAccessMessageHeader messageHeader, final ByteSource byteSource) {
        final int payloadSize = messageHeader.getPayloadSize();
        if (byteSource.remaining() >= payloadSize) {
            return;
        }
        try {
            byteSource.atomicGet(new ByteSource.AtomicGetOperation<Void>(){

                @Override
                public Void get() {
                    byteSource.skip(payloadSize);
                    throw new PayloadAvailableException();
                }
            });
        }
        catch (BufferUnderflowException e) {
            throw new BufferUnderflowWithSizeException(messageHeader.getHeaderSize() + payloadSize);
        }
        catch (PayloadAvailableException e) {
            return;
        }
    }

    public ChannelAccessMessage decodeMessageToUDPServer(final ByteSource byteSource, final ChannelAccessVersion version) {
        return byteSource.atomicGet(new ByteSource.AtomicGetOperation<ChannelAccessMessage>(){

            @Override
            public ChannelAccessMessage get() {
                ChannelAccessMessageHeader messageHeader = ChannelAccessMessageCodec.decodeMessageHeader(byteSource);
                return ChannelAccessMessageCodec.decodeMessageToUDPServer(messageHeader, byteSource, false, ChannelAccessMessageCodec.this.charset, ChannelAccessMessageCodec.this.maxPayloadReceiveSize, version);
            }
        });
    }

    protected static ChannelAccessMessage decodeMessageToUDPServer(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, boolean headerOnly, Charset charset, int maxPayloadSize, ChannelAccessVersion version) {
        ChannelAccessCommand command;
        if (headerOnly) {
            try {
                command = ChannelAccessCommand.forCommandNumber(messageHeader.getCommand());
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedMessageTypeException("Command number " + messageHeader.getCommand() + " does not refer to a well-known command.", e);
            }
        } else {
            command = ChannelAccessMessageCodec.checkMessageHeaderAndGetCommand(messageHeader, maxPayloadSize);
        }
        switch (command) {
            case CA_PROTO_VERSION: {
                return ChannelAccessVersionUDPMessage.deserialize(messageHeader, byteSource, headerOnly);
            }
            case CA_PROTO_SEARCH: {
                return ChannelAccessSearchClientMessage.deserialize(messageHeader, byteSource, headerOnly, charset);
            }
            case CA_PROTO_ECHO: {
                return ChannelAccessEchoMessage.deserialize(messageHeader, byteSource, headerOnly);
            }
        }
        throw new UnsupportedMessageTypeException("A message of type " + command.name() + " is not expected from a UDP client.");
    }

    public ChannelAccessMessage decodeMessageToUDPClient(final ByteSource byteSource, final ChannelAccessVersion version, final Inet4Address serverAddress, final int serverPort) {
        return byteSource.atomicGet(new ByteSource.AtomicGetOperation<ChannelAccessMessage>(){

            @Override
            public ChannelAccessMessage get() {
                ChannelAccessMessageHeader messageHeader = ChannelAccessMessageCodec.decodeMessageHeader(byteSource);
                ChannelAccessCommand command = ChannelAccessMessageCodec.checkMessageHeaderAndGetCommand(messageHeader, ChannelAccessMessageCodec.this.maxPayloadReceiveSize);
                switch (command) {
                    case CA_PROTO_VERSION: {
                        return ChannelAccessVersionUDPMessage.deserialize(messageHeader, byteSource, false);
                    }
                    case CA_PROTO_SEARCH: {
                        return ChannelAccessSearchUDPServerMessage.deserialize(messageHeader, byteSource, serverAddress, serverPort);
                    }
                    case CA_PROTO_ERROR: {
                        return ChannelAccessErrorMessage.deserialize(messageHeader, byteSource, ChannelAccessMessageCodec.this.charset, version, false);
                    }
                    case CA_PROTO_NOT_FOUND: {
                        return ChannelAccessNotFoundMessage.deserialize(messageHeader, byteSource);
                    }
                    case CA_PROTO_ECHO: {
                        return ChannelAccessEchoMessage.deserialize(messageHeader, byteSource, false);
                    }
                }
                throw new UnsupportedMessageTypeException("A message of type " + command.name() + " is not expected from a UDP client.");
            }
        });
    }

    public ChannelAccessMessage decodeMessageToTCPServer(final ByteSource byteSource, final ChannelAccessVersion version) {
        return byteSource.atomicGet(new ByteSource.AtomicGetOperation<ChannelAccessMessage>(){

            @Override
            public ChannelAccessMessage get() {
                ChannelAccessMessageHeader messageHeader = ChannelAccessMessageCodec.decodeMessageHeader(byteSource);
                return ChannelAccessMessageCodec.decodeMessageToTCPServer(messageHeader, byteSource, false, ChannelAccessMessageCodec.this.charset, ChannelAccessMessageCodec.this.maxPayloadReceiveSize, version);
            }
        });
    }

    protected static ChannelAccessMessage decodeMessageToTCPServer(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, boolean headerOnly, Charset charset, int maxPayloadSize, ChannelAccessVersion version) {
        ChannelAccessCommand command;
        if (headerOnly) {
            try {
                command = ChannelAccessCommand.forCommandNumber(messageHeader.getCommand());
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedMessageTypeException("Command number " + messageHeader.getCommand() + " does not refer to a well-known command.", e);
            }
        } else {
            command = ChannelAccessMessageCodec.checkMessageHeaderAndGetCommand(messageHeader, maxPayloadSize);
            ChannelAccessMessageCodec.checkPayloadAvailable(messageHeader, byteSource);
        }
        switch (command) {
            case CA_PROTO_VERSION: {
                return ChannelAccessVersionTCPClientMessage.deserialize(messageHeader, byteSource, headerOnly);
            }
            case CA_PROTO_CLIENT_NAME: {
                return ChannelAccessUserNameMessage.deserialize(messageHeader, byteSource, headerOnly, charset);
            }
            case CA_PROTO_HOST_NAME: {
                return ChannelAccessHostNameMessage.deserialize(messageHeader, byteSource, headerOnly, charset);
            }
            case CA_PROTO_SEARCH: {
                return ChannelAccessSearchClientMessage.deserialize(messageHeader, byteSource, headerOnly, charset);
            }
            case CA_PROTO_CREATE_CHAN: {
                return ChannelAccessConnectChannelClientMessage.deserialize(messageHeader, byteSource, headerOnly, charset);
            }
            case CA_PROTO_CLEAR_CHANNEL: {
                return ChannelAccessDisconnectChannelMessage.deserialize(messageHeader, byteSource, headerOnly);
            }
            case CA_PROTO_EVENT_ADD: {
                return ChannelAccessSubscriptionClientMessage.deserialize(messageHeader, byteSource, headerOnly);
            }
            case CA_PROTO_EVENT_CANCEL: {
                return ChannelAccessCancelSubscriptionClientMessage.deserialize(messageHeader, byteSource, headerOnly);
            }
            case CA_PROTO_READ: {
                return ChannelAccessReadClientMessage.deserialize(messageHeader, byteSource, headerOnly);
            }
            case CA_PROTO_WRITE: {
                return ChannelAccessWriteMessage.deserialize(messageHeader, byteSource, headerOnly, charset);
            }
            case CA_PROTO_READ_NOTIFY: {
                return ChannelAccessReadNotifyClientMessage.deserialize(messageHeader, byteSource, headerOnly);
            }
            case CA_PROTO_WRITE_NOTIFY: {
                return ChannelAccessWriteNotifyClientMessage.deserialize(messageHeader, byteSource, headerOnly, charset);
            }
            case CA_PROTO_ECHO: {
                return ChannelAccessEchoMessage.deserialize(messageHeader, byteSource, headerOnly);
            }
            case CA_PROTO_EVENTS_OFF: {
                return ChannelAccessEventsOffMessage.deserialize(messageHeader, byteSource, headerOnly);
            }
            case CA_PROTO_EVENTS_ON: {
                return ChannelAccessEventsOnMessage.deserialize(messageHeader, byteSource, headerOnly);
            }
            case CA_PROTO_READ_SYNC: {
                return ChannelAccessReadSyncMessage.deserialize(messageHeader, byteSource, headerOnly);
            }
            case CA_PROTO_READ_BUILD: {
                return ChannelAccessReadBuildMessage.deserialize(messageHeader, byteSource, headerOnly);
            }
        }
        throw new UnsupportedMessageTypeException("A message of type " + command.name() + " is not expected from a TCP client.");
    }

    public ChannelAccessMessage decodeMessageToTCPClient(final ByteSource byteSource, final ChannelAccessVersion version, final Inet4Address serverAddress, final int serverPort) {
        return byteSource.atomicGet(new ByteSource.AtomicGetOperation<ChannelAccessMessage>(){

            @Override
            public ChannelAccessMessage get() {
                ChannelAccessMessageHeader messageHeader = ChannelAccessMessageCodec.decodeMessageHeader(byteSource);
                ChannelAccessMessageCodec.checkPayloadAvailable(messageHeader, byteSource);
                ChannelAccessCommand command = ChannelAccessMessageCodec.checkMessageHeaderAndGetCommand(messageHeader, ChannelAccessMessageCodec.this.maxPayloadReceiveSize);
                switch (command) {
                    case CA_PROTO_VERSION: {
                        return ChannelAccessVersionTCPServerMessage.deserialize(messageHeader, byteSource);
                    }
                    case CA_PROTO_SEARCH: {
                        return ChannelAccessSearchTCPServerMessage.deserialize(messageHeader, byteSource, serverAddress, serverPort);
                    }
                    case CA_PROTO_NOT_FOUND: {
                        return ChannelAccessNotFoundMessage.deserialize(messageHeader, byteSource);
                    }
                    case CA_PROTO_ACCESS_RIGHTS: {
                        return ChannelAccessAccessRightsMessage.deserialize(messageHeader, byteSource);
                    }
                    case CA_PROTO_CREATE_CHAN: {
                        return ChannelAccessConnectChannelServerMessage.deserialize(messageHeader, byteSource);
                    }
                    case CA_PROTO_CLEAR_CHANNEL: {
                        return ChannelAccessDisconnectChannelMessage.deserialize(messageHeader, byteSource, false);
                    }
                    case CA_PROTO_CREATE_CH_FAIL: {
                        return ChannelAccessConnectChannelFailedMessage.deserialize(messageHeader, byteSource);
                    }
                    case CA_PROTO_SERVER_DISCONN: {
                        return ChannelAccessChannelDisconnectedByServerMessage.deserialize(messageHeader, byteSource);
                    }
                    case CA_PROTO_EVENT_ADD: {
                        if (messageHeader.getPayloadSize() == 0) {
                            return ChannelAccessCancelSubscriptionServerMessage.deserialize(messageHeader, byteSource);
                        }
                        return ChannelAccessSubscriptionServerMessage.deserialize(messageHeader, byteSource, ChannelAccessMessageCodec.this.charset);
                    }
                    case CA_PROTO_READ: {
                        return ChannelAccessReadServerMessage.deserialize(messageHeader, byteSource, ChannelAccessMessageCodec.this.charset);
                    }
                    case CA_PROTO_READ_NOTIFY: {
                        return ChannelAccessReadNotifyServerMessage.deserialize(messageHeader, byteSource, ChannelAccessMessageCodec.this.charset);
                    }
                    case CA_PROTO_WRITE_NOTIFY: {
                        return ChannelAccessWriteNotifyServerMessage.deserialize(messageHeader, byteSource);
                    }
                    case CA_PROTO_ERROR: {
                        return ChannelAccessErrorMessage.deserialize(messageHeader, byteSource, ChannelAccessMessageCodec.this.charset, version, true);
                    }
                    case CA_PROTO_ECHO: {
                        return ChannelAccessEchoMessage.deserialize(messageHeader, byteSource, false);
                    }
                    case CA_PROTO_READ_SYNC: {
                        return ChannelAccessReadSyncMessage.deserialize(messageHeader, byteSource, false);
                    }
                }
                throw new UnsupportedMessageTypeException("A message of type " + command.name() + " is not expected from a UDP client.");
            }
        });
    }

    public ChannelAccessMessage decodeMessageToRepeater(final ByteSource byteSource, ChannelAccessVersion version, final Inet4Address originAddress) {
        return byteSource.atomicGet(new ByteSource.AtomicGetOperation<ChannelAccessMessage>(){

            @Override
            public ChannelAccessMessage get() {
                ChannelAccessMessageHeader messageHeader = ChannelAccessMessageCodec.decodeMessageHeader(byteSource);
                ChannelAccessCommand command = ChannelAccessMessageCodec.checkMessageHeaderAndGetCommand(messageHeader, ChannelAccessMessageCodec.this.maxPayloadReceiveSize);
                switch (command) {
                    case CA_PROTO_RSRV_IS_UP: {
                        return ChannelAccessBeaconMessage.deserialize(messageHeader, byteSource, originAddress);
                    }
                    case REPEATER_REGISTER: {
                        return ChannelAccessRepeaterRegisterMessage.deserialize(messageHeader, byteSource);
                    }
                }
                throw new UnsupportedMessageTypeException("A message of type " + command.name() + " is not expected by a repeater.");
            }
        });
    }

    public ChannelAccessMessage decodeMessageFromRepeater(final ByteSource byteSource, ChannelAccessVersion version) {
        return byteSource.atomicGet(new ByteSource.AtomicGetOperation<ChannelAccessMessage>(){

            @Override
            public ChannelAccessMessage get() {
                ChannelAccessMessageHeader messageHeader = ChannelAccessMessageCodec.decodeMessageHeader(byteSource);
                ChannelAccessCommand command = ChannelAccessMessageCodec.checkMessageHeaderAndGetCommand(messageHeader, ChannelAccessMessageCodec.this.maxPayloadReceiveSize);
                switch (command) {
                    case CA_PROTO_VERSION: {
                        return ChannelAccessVersionUDPMessage.deserialize(messageHeader, byteSource, false);
                    }
                    case CA_PROTO_RSRV_IS_UP: {
                        return ChannelAccessBeaconMessage.deserialize(messageHeader, byteSource, null);
                    }
                    case REPEATER_CONFIRM: {
                        return ChannelAccessRepeaterConfirmMessage.deserialize(messageHeader, byteSource);
                    }
                }
                throw new UnsupportedMessageTypeException("A message of type " + command.name() + " is not expected from a repeater.");
            }
        });
    }

    private void verifyMessageInternal(ChannelAccessMessage message, ChannelAccessVersion version) {
        message.verify(version, this.maxPayloadSendSize, this.charset);
    }

    public void verifyMessageToUDPServer(ChannelAccessMessage message, ChannelAccessVersion version) {
        if (!(message instanceof ChannelAccessVersionUDPMessage) && !(message instanceof ChannelAccessSearchClientMessage)) {
            throw new IllegalArgumentException("Cannot send message of type " + message.getClass().getName() + " to UDP server.");
        }
        this.verifyMessageInternal(message, version);
    }

    public void verifyMessageToUDPClient(ChannelAccessMessage message, ChannelAccessVersion version) {
        if (!(message instanceof ChannelAccessVersionUDPMessage || message instanceof ChannelAccessSearchUDPServerMessage || message instanceof ChannelAccessEchoMessage || message instanceof ChannelAccessErrorMessage || message instanceof ChannelAccessNotFoundMessage)) {
            throw new IllegalArgumentException("Cannot send message of type " + message.getClass().getName() + " to UDP client.");
        }
        this.verifyMessageInternal(message, version);
    }

    public void verifyMessageToRepeater(ChannelAccessMessage message, ChannelAccessVersion version) {
        if (!(message instanceof ChannelAccessBeaconMessage)) {
            throw new IllegalArgumentException("Cannot send message of type " + message.getClass().getName() + " to repeater.");
        }
        this.verifyMessageInternal(message, version);
    }

    public void verifyMessageFromRepeater(ChannelAccessMessage message, ChannelAccessVersion version) {
        if (!(message instanceof ChannelAccessVersionUDPMessage || message instanceof ChannelAccessRepeaterConfirmMessage || message instanceof ChannelAccessBeaconMessage)) {
            throw new IllegalArgumentException("Cannot send message of type " + message.getClass().getName() + " from repeater.");
        }
        this.verifyMessageInternal(message, version);
    }

    public void verifyMessageToTCPServer(ChannelAccessMessage message, ChannelAccessVersion version) {
        if (!(message instanceof ChannelAccessVersionTCPClientMessage || message instanceof ChannelAccessSubscriptionClientMessage || message instanceof ChannelAccessCancelSubscriptionClientMessage || message instanceof ChannelAccessReadClientMessage || message instanceof ChannelAccessWriteMessage || message instanceof ChannelAccessEventsOffMessage || message instanceof ChannelAccessEventsOnMessage || message instanceof ChannelAccessReadSyncMessage || message instanceof ChannelAccessDisconnectChannelMessage || message instanceof ChannelAccessReadNotifyClientMessage || message instanceof ChannelAccessConnectChannelClientMessage || message instanceof ChannelAccessWriteNotifyClientMessage || message instanceof ChannelAccessUserNameMessage || message instanceof ChannelAccessHostNameMessage || message instanceof ChannelAccessEchoMessage || message instanceof ChannelAccessSearchClientMessage)) {
            throw new IllegalArgumentException("Cannot send message of type " + message.getClass().getName() + " to TCP server.");
        }
        this.verifyMessageInternal(message, version);
    }

    public void verifyMessageToTCPClient(ChannelAccessMessage message, ChannelAccessVersion version) {
        if (!(message instanceof ChannelAccessVersionTCPServerMessage || message instanceof ChannelAccessSubscriptionServerMessage || message instanceof ChannelAccessCancelSubscriptionServerMessage || message instanceof ChannelAccessReadServerMessage || message instanceof ChannelAccessReadSyncMessage || message instanceof ChannelAccessErrorMessage || message instanceof ChannelAccessDisconnectChannelMessage || message instanceof ChannelAccessReadNotifyServerMessage || message instanceof ChannelAccessConnectChannelServerMessage || message instanceof ChannelAccessWriteNotifyServerMessage || message instanceof ChannelAccessAccessRightsMessage || message instanceof ChannelAccessEchoMessage || message instanceof ChannelAccessConnectChannelFailedMessage || message instanceof ChannelAccessChannelDisconnectedByServerMessage || message instanceof ChannelAccessSearchTCPServerMessage || message instanceof ChannelAccessNotFoundMessage)) {
            throw new IllegalArgumentException("Cannot send message of type " + message.getClass().getName() + " to TCP client.");
        }
        this.verifyMessageInternal(message, version);
    }

    private static class PayloadAvailableException
    extends RuntimeException {
        private static final long serialVersionUID = 5321542267146195576L;

        private PayloadAvailableException() {
        }
    }
}

