/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessSearchClientMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import java.nio.charset.Charset;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessNotFoundMessage
extends ChannelAccessMessage {
    private int cid;
    private short dataType;
    private int count;
    private int contextSpecific;

    public ChannelAccessNotFoundMessage(ChannelAccessSearchClientMessage searchMessage) {
        super(ChannelAccessCommand.CA_PROTO_NOT_FOUND);
        if (searchMessage == null) {
            throw new NullPointerException("Search message parameter must not be null.");
        }
        if (searchMessage.hasOriginalMessageHeader()) {
            ChannelAccessMessageHeader searchMessageHeader = searchMessage.getOriginalMessageHeader();
            this.cid = searchMessageHeader.getCID();
            this.dataType = searchMessageHeader.getDataType();
            this.count = searchMessageHeader.getCount();
            this.contextSpecific = searchMessageHeader.getContextSpecific();
        } else {
            this.cid = searchMessage.getChannelCID();
            this.dataType = (short)(searchMessage.isDoReply() ? 10 : 5);
            this.count = searchMessage.getVersion().getMinorVersionAsShort();
            this.contextSpecific = this.cid;
        }
    }

    private ChannelAccessNotFoundMessage(ChannelAccessMessageHeader messageHeader) {
        super(ChannelAccessCommand.CA_PROTO_NOT_FOUND, messageHeader);
        this.cid = messageHeader.getCID();
        this.dataType = messageHeader.getDataType();
        this.count = messageHeader.getCount();
        this.contextSpecific = messageHeader.getContextSpecific();
    }

    public int getChannelCID() {
        return this.contextSpecific;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        this.serializeHeader(byteSink, 0, this.dataType, this.count, this.cid, this.contextSpecific, version, maxPayloadSize);
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        this.verifyHeader(0, this.count, version, maxPayloadSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessNotFoundMessage other = (ChannelAccessNotFoundMessage)obj;
        return new EqualsBuilder().append(this.cid, other.cid).append(this.dataType, other.dataType).append(this.count, other.count).append(this.contextSpecific, other.contextSpecific).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.cid).append(this.dataType).append(this.count).append(this.contextSpecific).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("cid=");
        sb.append(this.cid);
        sb.append(", dataType=");
        sb.append(this.dataType);
        sb.append(", count=");
        sb.append(this.count);
        sb.append(", contextSpecific=");
        sb.append(this.contextSpecific);
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessNotFoundMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource) {
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_NOT_FOUND.getCommandNumber());
        byteSource.skip(messageHeader.getPayloadSize());
        return new ChannelAccessNotFoundMessage(messageHeader);
    }
}

