/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessReadNotifyMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import java.nio.charset.Charset;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessReadNotifyClientMessage
extends ChannelAccessReadNotifyMessage {
    private short dataType;
    private int count;
    private int sid;
    private int operationId;

    public ChannelAccessReadNotifyClientMessage(ChannelAccessValueType dataType, int count, int sid, int operationId) {
        this.dataType = dataType.toTypeCode();
        this.count = count;
        this.sid = sid;
        this.operationId = operationId;
    }

    private ChannelAccessReadNotifyClientMessage(ChannelAccessMessageHeader messageHeader, short dataType, int count, int sid, int operationId) {
        super(messageHeader);
        this.dataType = dataType;
        this.count = count;
        this.sid = sid;
        this.operationId = operationId;
    }

    public ChannelAccessValueType getDataType() {
        try {
            return ChannelAccessValueType.forTypeNumber(this.dataType);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public int getCount() {
        return this.count;
    }

    public int getChannelSID() {
        return this.sid;
    }

    public int getOperationId() {
        return this.operationId;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        this.serializeHeader(byteSink, 0, this.dataType, this.count, this.sid, this.operationId, version, maxPayloadSize);
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        this.verifyHeader(0, this.count, version, maxPayloadSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessReadNotifyClientMessage other = (ChannelAccessReadNotifyClientMessage)obj;
        return new EqualsBuilder().append(this.dataType, other.dataType).append(this.count, other.count).append(this.sid, other.sid).append(this.operationId, other.operationId).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.dataType).append(this.count).append(this.sid).append(this.operationId).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("dataType=");
        try {
            sb.append((Object)ChannelAccessValueType.forTypeNumber(this.dataType));
        }
        catch (IllegalArgumentException e) {
            sb.append("UNKNOWN(");
            sb.append(this.dataType);
            sb.append(')');
        }
        sb.append(", count=");
        sb.append(this.count);
        sb.append(", sid=");
        sb.append(this.sid);
        sb.append(", operationId=");
        sb.append(this.operationId);
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessReadNotifyClientMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, boolean headerOnly) {
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_READ_NOTIFY.getCommandNumber());
        if (!headerOnly) {
            byteSource.skip(messageHeader.getPayloadSize());
        }
        return new ChannelAccessReadNotifyClientMessage(messageHeader, messageHeader.getDataType(), messageHeader.getCount(), messageHeader.getCID(), messageHeader.getContextSpecific());
    }
}

