/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import java.nio.charset.Charset;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessReadSyncMessage
extends ChannelAccessMessage {
    private short dataType = 0;
    private int count = 0;
    private int cid = 0;
    private int contextSpecific = 0;
    private byte[] payload = ArrayUtils.EMPTY_BYTE_ARRAY;

    public ChannelAccessReadSyncMessage() {
        super(ChannelAccessCommand.CA_PROTO_READ_SYNC);
    }

    public ChannelAccessReadSyncMessage(ChannelAccessReadSyncMessage messageFromClient) {
        super(ChannelAccessCommand.CA_PROTO_READ_SYNC);
        this.dataType = messageFromClient.dataType;
        this.count = messageFromClient.count;
        this.cid = messageFromClient.cid;
        this.contextSpecific = messageFromClient.contextSpecific;
    }

    private ChannelAccessReadSyncMessage(ChannelAccessMessageHeader messageHeader, short dataType, int count, int cid, int contextSpecific, byte[] payload) {
        super(ChannelAccessCommand.CA_PROTO_READ_SYNC, messageHeader);
        this.dataType = dataType;
        this.count = count;
        this.cid = cid;
        this.contextSpecific = contextSpecific;
        this.payload = payload;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (this.payload == null) {
            throw new UnsupportedOperationException("Cannot serialize the message payload for a message that has been constructed without the payload.");
        }
        this.serializeHeader(byteSink, this.payload.length, this.dataType, this.count, this.cid, this.contextSpecific, version, maxPayloadSize);
        byteSink.putByteArray(this.payload);
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (this.payload == null) {
            throw new UnsupportedOperationException("Cannot serialize the message payload for a message that has been constructed without the payload.");
        }
        this.verifyHeader(this.payload.length, this.count, version, maxPayloadSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessReadSyncMessage other = (ChannelAccessReadSyncMessage)obj;
        return new EqualsBuilder().append(this.dataType, other.dataType).append(this.count, other.count).append(this.cid, other.cid).append(this.contextSpecific, other.contextSpecific).append(this.payload, other.payload).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.dataType).append(this.count).append(this.cid).append(this.contextSpecific).append(this.payload).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("dataType=");
        sb.append(this.dataType);
        sb.append(", count=");
        sb.append(this.count);
        sb.append(", cid=");
        sb.append(this.cid);
        sb.append(", contextSpecific=");
        sb.append(this.contextSpecific);
        sb.append(", payload=");
        ChannelAccessReadSyncMessage.addByteArrayToStringBuilder(sb, this.payload);
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessReadSyncMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, boolean headerOnly) {
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_READ_SYNC.getCommandNumber());
        byte[] payload = headerOnly ? null : byteSource.getByteArray(messageHeader.getPayloadSize());
        return new ChannelAccessReadSyncMessage(messageHeader, messageHeader.getDataType(), messageHeader.getCount(), messageHeader.getCID(), messageHeader.getContextSpecific(), payload);
    }
}

