/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.util.Inet4AddressUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessRepeaterConfirmMessage
extends ChannelAccessMessage {
    private Inet4Address clientAddress;

    public ChannelAccessRepeaterConfirmMessage(Inet4Address clientAddress) {
        super(ChannelAccessCommand.REPEATER_CONFIRM);
        this.clientAddress = clientAddress;
    }

    private ChannelAccessRepeaterConfirmMessage(ChannelAccessMessageHeader messageHeader, Inet4Address clientAddress) {
        super(ChannelAccessCommand.REPEATER_CONFIRM, messageHeader);
        this.clientAddress = clientAddress;
    }

    public Inet4Address getClientAddress() {
        return this.clientAddress;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessRepeaterConfirmMessage other = (ChannelAccessRepeaterConfirmMessage)obj;
        return new EqualsBuilder().append((Object)this.clientAddress, (Object)other.clientAddress).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.clientAddress).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("clientAddress=");
        sb.append(this.clientAddress != null ? this.clientAddress.getHostAddress() : "null");
        sb.append('}');
        return sb.toString();
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        this.serializeHeader(byteSink, 0, (short)0, 0, 0, Inet4AddressUtil.addressToInt(this.clientAddress.getAddress()), version, maxPayloadSize);
    }

    protected static ChannelAccessRepeaterConfirmMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource) {
        Inet4Address clientAddress;
        assert (messageHeader.getCommand() == ChannelAccessCommand.REPEATER_CONFIRM.getCommandNumber());
        try {
            byteSource.skip(messageHeader.getPayloadSize());
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            InetAddress tempAddress = InetAddress.getByAddress(Inet4AddressUtil.addressToBytes(messageHeader.getContextSpecific()));
            if (!(tempAddress instanceof Inet4Address)) {
                throw new RuntimeException("Did not get IPv4 address where it was expected. Got address of type " + tempAddress.getClass().getName() + " instead.");
            }
            clientAddress = (Inet4Address)tempAddress;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Cannot get inet address instance for address of four bytes.", e);
        }
        return new ChannelAccessRepeaterConfirmMessage(messageHeader, clientAddress);
    }
}

