/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.exception.SerializedChannelNameTooLargeException;
import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessSearchMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.util.NullTerminatedStringUtil;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.Pair;

public final class ChannelAccessSearchClientMessage
extends ChannelAccessSearchMessage {
    private static final short DO_REPLY = 10;
    private static final short DO_NOT_REPLY = 5;
    private int cid;
    private String channelName;
    private boolean doReply;
    private ChannelAccessVersion version;

    public ChannelAccessSearchClientMessage(int cid, ChannelAccessVersion version, boolean doReply, String channelName) {
        if (version == null) {
            throw new NullPointerException("Channel Access version must not be null.");
        }
        if (channelName == null) {
            throw new NullPointerException("Channel name must not be null.");
        }
        this.cid = cid;
        this.version = version;
        this.doReply = doReply;
        this.channelName = channelName;
    }

    private ChannelAccessSearchClientMessage(ChannelAccessMessageHeader messageHeader, int cid, ChannelAccessVersion version, boolean doReply, String channelName) {
        super(messageHeader);
        this.cid = cid;
        this.version = version;
        this.doReply = doReply;
        this.channelName = channelName;
    }

    public int getChannelCID() {
        return this.cid;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public boolean isDoReply() {
        return this.doReply;
    }

    public ChannelAccessVersion getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessSearchClientMessage other = (ChannelAccessSearchClientMessage)obj;
        return new EqualsBuilder().append(this.cid, other.cid).append((Object)this.channelName, (Object)other.channelName).append(this.doReply, other.doReply).append((Object)this.version, (Object)other.version).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.cid).append((Object)this.channelName).append(this.doReply).append((Object)this.version).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("cid=");
        sb.append(this.cid);
        sb.append(", channelName=");
        if (this.channelName != null) {
            sb.append('\"');
            sb.append(StringEscapeUtils.escapeJava((String)this.channelName));
            sb.append('\"');
        } else {
            sb.append("null");
        }
        sb.append(", doReply=");
        sb.append(this.doReply);
        sb.append(", version=");
        sb.append(this.version);
        sb.append('}');
        return sb.toString();
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (this.channelName == null) {
            throw new UnsupportedOperationException("Cannot serialize the message payload for a message that has been constructed without the payload.");
        }
        Pair<byte[], Integer> channelNameBytesWithLength = NullTerminatedStringUtil.stringToSizeLimitedNullTerminatedBytesOrNull(this.channelName, 488, 8, charset);
        if (channelNameBytesWithLength == null) {
            throw new SerializedChannelNameTooLargeException("The serialized form of the channel name must not be longer than 488 bytes.");
        }
        byte[] channelNameAsBytes = (byte[])channelNameBytesWithLength.getLeft();
        int channelNameLength = (Integer)channelNameBytesWithLength.getRight();
        this.serializeHeader(byteSink, channelNameLength, this.doReply ? (short)10 : 5, this.version.getMinorVersionAsShort(), this.cid, this.cid, version, maxPayloadSize);
        byteSink.putByteArray(channelNameAsBytes, 0, channelNameLength);
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (this.channelName == null) {
            throw new UnsupportedOperationException("Cannot serialize the message payload for a message that has been constructed without the payload.");
        }
        Pair<byte[], Integer> channelNameBytesWithLength = NullTerminatedStringUtil.stringToSizeLimitedNullTerminatedBytesOrNull(this.channelName, 488, 8, charset);
        if (channelNameBytesWithLength == null) {
            throw new SerializedChannelNameTooLargeException("The serialized form of the channel name must not be longer than 488 bytes.");
        }
    }

    protected static ChannelAccessSearchClientMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, boolean headerOnly, Charset charset) {
        String channelName;
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_SEARCH.getCommandNumber());
        if (!headerOnly) {
            byte[] channelNameAsBytes = byteSource.getByteArray(messageHeader.getPayloadSize());
            channelName = NullTerminatedStringUtil.nullTerminatedBytesToString(channelNameAsBytes, charset);
        } else {
            channelName = null;
        }
        return new ChannelAccessSearchClientMessage(messageHeader, messageHeader.getContextSpecific(), ChannelAccessVersion.forMinorVersion(messageHeader.getCount()), messageHeader.getDataType() == 10, channelName);
    }
}

