/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.exception.UnsupportedProtocolVersionException;
import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessSearchMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.util.Inet4AddressUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessSearchTCPServerMessage
extends ChannelAccessSearchMessage {
    private static final int UNKNOWN_SERVER_ADDRESS = -1;
    private int cid;
    private Inet4Address serverAddress;
    private int serverPort;

    public ChannelAccessSearchTCPServerMessage(int cid, Inet4Address serverAddress, int serverPort) {
        this.cid = cid;
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
    }

    private ChannelAccessSearchTCPServerMessage(ChannelAccessMessageHeader messageHeader, int cid, Inet4Address serverAddress, int serverPort) {
        super(messageHeader);
        this.cid = cid;
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
    }

    public int getChannelCID() {
        return this.cid;
    }

    public Inet4Address getServerAddress() {
        return this.serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (!version.includes(ChannelAccessVersion.V4_4)) {
            throw new UnsupportedProtocolVersionException("This library does not support clients with a protocol version before Channel Access version " + ChannelAccessVersion.V4_4 + ".");
        }
        int serverAddress = this.serverAddress != null && !this.serverAddress.isAnyLocalAddress() ? Inet4AddressUtil.addressToInt(this.serverAddress.getAddress()) : -1;
        short port = (short)this.serverPort;
        this.serializeHeader(byteSink, 0, port, 0, serverAddress, this.cid, version, maxPayloadSize);
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (!version.includes(ChannelAccessVersion.V4_4)) {
            throw new UnsupportedProtocolVersionException("This library does not support clients with a protocol version before Channel Access version " + ChannelAccessVersion.V4_4 + ".");
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessSearchTCPServerMessage other = (ChannelAccessSearchTCPServerMessage)obj;
        return new EqualsBuilder().append(this.cid, other.cid).append((Object)this.serverAddress, (Object)other.serverAddress).append(this.serverPort, other.serverPort).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.cid).append((Object)this.serverAddress).append(this.serverPort).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("cid=");
        sb.append(this.cid);
        sb.append(", serverAddress=");
        sb.append(this.serverAddress != null ? this.serverAddress.getHostAddress() : "null");
        sb.append(", serverPort=");
        sb.append(this.serverPort);
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessSearchTCPServerMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, Inet4Address originatingServerAddress, int originatingServerPort) {
        int serverPort;
        Inet4Address serverAddress;
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_SEARCH.getCommandNumber());
        byteSource.skip(messageHeader.getPayloadSize());
        int serverAddressAsInt = messageHeader.getCID();
        if (serverAddressAsInt != -1) {
            InetAddress tempAddress;
            try {
                tempAddress = InetAddress.getByAddress(Inet4AddressUtil.addressToBytes(serverAddressAsInt));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Cannot get inet address instance for address of four bytes.", e);
            }
            if (!(tempAddress instanceof Inet4Address)) {
                throw new RuntimeException("Did not get IPv4 address where it was expected. Got address of type " + tempAddress.getClass().getName() + " instead.");
            }
            serverAddress = (Inet4Address)tempAddress;
            serverPort = messageHeader.getDataType() & 0xFFFF;
        } else {
            serverAddress = originatingServerAddress;
            serverPort = originatingServerPort;
        }
        return new ChannelAccessSearchTCPServerMessage(messageHeader, messageHeader.getContextSpecific(), serverAddress, serverPort);
    }
}

