/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.exception.UnsupportedProtocolVersionException;
import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessSearchMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.util.Inet4AddressUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessSearchUDPServerMessage
extends ChannelAccessSearchMessage {
    private static final byte[] SIX_ZERO_BYTES = new byte[6];
    private static final int UNKNOWN_SERVER_ADDRESS = -1;
    private ChannelAccessVersion version;
    private int cid;
    private Inet4Address serverAddress;
    private int serverPort;

    public ChannelAccessSearchUDPServerMessage(ChannelAccessVersion version, int cid, Inet4Address serverAddress, int serverPort) {
        if (version == null) {
            throw new NullPointerException("Channel Acccess version must not be null.");
        }
        this.version = version;
        this.cid = cid;
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
    }

    private ChannelAccessSearchUDPServerMessage(ChannelAccessVersion version, ChannelAccessMessageHeader messageHeader, int cid, Inet4Address serverAddress, int serverPort) {
        super(messageHeader);
        this.version = version;
        this.cid = cid;
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
    }

    public int getChannelCID() {
        return this.cid;
    }

    public Inet4Address getServerAddress() {
        return this.serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public ChannelAccessVersion getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessSearchUDPServerMessage other = (ChannelAccessSearchUDPServerMessage)obj;
        return new EqualsBuilder().append((Object)this.version, (Object)other.version).append(this.cid, other.cid).append((Object)this.serverAddress, (Object)other.serverAddress).append(this.serverPort, other.serverPort).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.version).append(this.cid).append((Object)this.serverAddress).append(this.serverPort).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("version=");
        sb.append(this.version);
        sb.append(", cid=");
        sb.append(this.cid);
        sb.append(", serverAddress=");
        sb.append(this.serverAddress != null ? this.serverAddress.getHostAddress() : "null");
        sb.append(", serverPort=");
        sb.append(this.serverPort);
        sb.append('}');
        return sb.toString();
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (!version.includes(ChannelAccessVersion.V4_4)) {
            throw new UnsupportedProtocolVersionException("This library does not support clients with a protocol version before Channel Access version " + ChannelAccessVersion.V4_4 + ".");
        }
        int serverAddress = version.includes(ChannelAccessVersion.V4_8) && this.serverAddress != null && !this.serverAddress.isAnyLocalAddress() ? Inet4AddressUtil.addressToInt(this.serverAddress.getAddress()) : -1;
        short port = (short)this.serverPort;
        this.serializeHeader(byteSink, 8, port, 0, serverAddress, this.cid, version, maxPayloadSize);
        byteSink.putShort(this.version.getMinorVersionAsShort());
        byteSink.putByteArray(SIX_ZERO_BYTES);
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (!version.includes(ChannelAccessVersion.V4_4)) {
            throw new UnsupportedProtocolVersionException("This library does not support clients with a protocol version before Channel Access version " + ChannelAccessVersion.V4_4 + ".");
        }
    }

    protected static ChannelAccessSearchUDPServerMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, Inet4Address originatingServerAddress, int originatingServerPort) {
        int serverPort;
        Inet4Address serverAddress;
        ChannelAccessVersion version;
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_SEARCH.getCommandNumber());
        int payloadSize = messageHeader.getPayloadSize();
        if (payloadSize >= 2) {
            version = ChannelAccessVersion.forMinorVersion(byteSource.getShort());
            if (payloadSize > 2) {
                byteSource.skip(payloadSize - 2);
            }
        } else {
            version = ChannelAccessVersion.V4_0;
        }
        if (version.includes(ChannelAccessVersion.V4_8)) {
            int serverAddressAsInt = messageHeader.getCID();
            if (serverAddressAsInt != -1) {
                InetAddress tempAddress;
                try {
                    tempAddress = InetAddress.getByAddress(Inet4AddressUtil.addressToBytes(serverAddressAsInt));
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException("Cannot get inet address instance for address of four bytes.", e);
                }
                if (!(tempAddress instanceof Inet4Address)) {
                    throw new RuntimeException("Did not get IPv4 address where it was expected. Got address of type " + tempAddress.getClass().getName() + " instead.");
                }
                serverAddress = (Inet4Address)tempAddress;
            } else {
                serverAddress = originatingServerAddress;
            }
            serverPort = messageHeader.getDataType() & 0xFFFF;
        } else if (version.includes(ChannelAccessVersion.V4_5)) {
            serverAddress = originatingServerAddress;
            serverPort = messageHeader.getDataType() & 0xFFFF;
        } else {
            serverAddress = originatingServerAddress;
            serverPort = originatingServerPort;
        }
        return new ChannelAccessSearchUDPServerMessage(version, messageHeader, messageHeader.getContextSpecific(), serverAddress, serverPort);
    }
}

