/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessStatus {
    private static ConcurrentHashMap<Integer, ChannelAccessStatus> generatedStatusMap = new ConcurrentHashMap();
    private final int statusCode;
    private final StatusSeverity severity;
    private final StatusMessage message;

    private ChannelAccessStatus(int statusCode, StatusSeverity severity, StatusMessage message) {
        this.statusCode = statusCode;
        this.severity = severity;
        this.message = message;
    }

    public int toStatusCode() {
        return this.statusCode;
    }

    public StatusMessage getMessage() {
        return this.message;
    }

    public StatusSeverity getSeverity() {
        return this.severity;
    }

    public static String messageForStatusCode(int statusCode) {
        return ChannelAccessStatus.forStatusCode(statusCode).toString();
    }

    public static ChannelAccessStatus forStatusCode(int statusCode) {
        ChannelAccessStatus status = generatedStatusMap.get(statusCode &= 0xFFFF);
        if (status == null) {
            status = new ChannelAccessStatus(statusCode, ChannelAccessStatus.severityFromStatusCode(statusCode), ChannelAccessStatus.messageFromStatusCode(statusCode));
            ChannelAccessStatus existingStatus = generatedStatusMap.putIfAbsent(statusCode, status);
            if (existingStatus != null) {
                return existingStatus;
            }
        }
        return status;
    }

    private static StatusMessage messageFromStatusCode(int statusCode) {
        int messageNumber = (statusCode & 0xFFF8) >>> 3;
        if (messageNumber < StatusMessage.MESSAGE_INSTANCES.length) {
            return StatusMessage.MESSAGE_INSTANCES[messageNumber];
        }
        return null;
    }

    private static StatusSeverity severityFromStatusCode(int statusCode) {
        int severityNumber = statusCode & 7;
        return StatusSeverity.SEVERITY_INSTANCES[severityNumber];
    }

    public String toString() {
        if (this.message != null) {
            return this.severity.toString() + ": " + this.message.toString();
        }
        return "Status code sent by server is not known by this implementation";
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.statusCode).append((Object)this.severity).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChannelAccessStatus)) {
            return false;
        }
        ChannelAccessStatus other = (ChannelAccessStatus)obj;
        return this.statusCode == other.statusCode;
    }

    public boolean matchesMessage(StatusMessage message) {
        if (this.message == null) {
            return false;
        }
        return this.message == message;
    }

    public static class StatusSeverity {
        private static final StatusSeverity[] SEVERITY_INSTANCES = new StatusSeverity[]{new StatusSeverity(StatusSeverityLevel.WARNING, false, 564685104), new StatusSeverity(StatusSeverityLevel.SUCCESS, false, -1837262005), new StatusSeverity(StatusSeverityLevel.ERROR, false, -1706982248), new StatusSeverity(StatusSeverityLevel.INFO, false, -413279776), new StatusSeverity(StatusSeverityLevel.WARNING, true, 625469114), new StatusSeverity(StatusSeverityLevel.SUCCESS, true, -105788039), new StatusSeverity(StatusSeverityLevel.ERROR, true, 1424402941), new StatusSeverity(StatusSeverityLevel.INFO, true, -1194002941)};
        private int hashCode;
        private final StatusSeverityLevel level;
        private final boolean severe;

        private StatusSeverity(StatusSeverityLevel level, boolean severe, int hashCode) {
            this.hashCode = hashCode;
            this.level = level;
            this.severe = severe;
        }

        public StatusSeverityLevel getLevel() {
            return this.level;
        }

        public boolean isSevere() {
            return this.severe;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public String toString() {
            if (!this.severe) {
                return this.level.name();
            }
            switch (this.level) {
                case ERROR: {
                    return "FATAL";
                }
                case INFO: {
                    return "INFO (severe)";
                }
                case SUCCESS: {
                    return "SUCCESS (severe)";
                }
                case WARNING: {
                    return "WARNING (severe)";
                }
            }
            throw new RuntimeException("Unexpected value for enum of type " + StatusSeverityLevel.class.getName() + ": " + this.level.name());
        }
    }

    public static enum StatusSeverityLevel {
        SUCCESS(1),
        INFO(3),
        WARNING(0),
        ERROR(2);

        private final int severityNumber;

        private StatusSeverityLevel(int severityNumber) {
            this.severityNumber = severityNumber;
        }

        private int getSeverityNumber() {
            return this.severityNumber;
        }
    }

    public static enum StatusMessage {
        ECA_NORMAL(StatusSeverityLevel.SUCCESS, 0, "Normal successful completion"),
        ECA_MAXIOC(StatusSeverityLevel.ERROR, 1, "Maximum simultaneous IOC connections exceeded"),
        ECA_UKNHOST(StatusSeverityLevel.ERROR, 2, "Unknown Internet host"),
        ECA_UKNSERV(StatusSeverityLevel.ERROR, 3, "Unknown Internet service"),
        ECA_SOCK(StatusSeverityLevel.ERROR, 4, "Unable to allocate a new socket"),
        ECA_CONN(StatusSeverityLevel.WARNING, 5, "Unable to connect to Internet host or service"),
        ECA_ALLOCMEM(StatusSeverityLevel.WARNING, 6, "Unable to allocate additional dynamic memory"),
        ECA_UKNCHAN(StatusSeverityLevel.WARNING, 7, "Unknown IO channel"),
        ECA_UKNFIELD(StatusSeverityLevel.WARNING, 8, "Record field specified inappropriate for channel specified"),
        ECA_TOLARGE(StatusSeverityLevel.WARNING, 9, "The requested data transfer is greater than available memory or EPICS_CA_MAX_ARRAY_BYTES"),
        ECA_TIMEOUT(StatusSeverityLevel.WARNING, 10, "User specified timeout on IO operation expired"),
        ECA_NOSUPPORT(StatusSeverityLevel.WARNING, 11, "Sorry, that feature is planned but not supported at this time"),
        ECA_STRTOBIG(StatusSeverityLevel.WARNING, 12, "The supplied string is unusually large"),
        ECA_DISCONNCHID(StatusSeverityLevel.ERROR, 13, "The request was ignored because the specified channel is disconnected"),
        ECA_BADTYPE(StatusSeverityLevel.ERROR, 14, "The data type specifed is invalid"),
        ECA_CHIDNOTFND(StatusSeverityLevel.INFO, 15, "Remote Channel not found"),
        ECA_CHIDRETRY(StatusSeverityLevel.INFO, 16, "Unable to locate all user specified channels"),
        ECA_INTERNAL(StatusSeverityLevel.ERROR, true, 17, "Channel Access Internal Failure"),
        ECA_DBLCLFAIL(StatusSeverityLevel.WARNING, 18, "The requested local DB operation failed"),
        ECA_GETFAIL(StatusSeverityLevel.WARNING, 19, "Channel read request failed"),
        ECA_PUTFAIL(StatusSeverityLevel.WARNING, 20, "Channel write request failed"),
        ECA_ADDFAIL(StatusSeverityLevel.WARNING, 21, "Channel subscription request failed"),
        ECA_BADCOUNT(StatusSeverityLevel.WARNING, 22, "Invalid element count requested"),
        ECA_BADSTR(StatusSeverityLevel.ERROR, 23, "Invalid string"),
        ECA_DISCONN(StatusSeverityLevel.WARNING, 24, "Virtual circuit disconnect"),
        ECA_DBLCHNL(StatusSeverityLevel.WARNING, 25, "Identical process variable names on multiple servers"),
        ECA_EVDISALLOW(StatusSeverityLevel.ERROR, 26, "Request inappropriate within subscription (monitor) update callback"),
        ECA_BUILDGET(StatusSeverityLevel.WARNING, 27, "Database value get for that channel failed during channel search"),
        ECA_NEEDSFP(StatusSeverityLevel.WARNING, 28, "Unable to initialize without the vxWorks VX_FP_TASK task option set"),
        ECA_OVEFAIL(StatusSeverityLevel.WARNING, 29, "Event queue overflow has prevented first pass event after event add"),
        ECA_BADMONID(StatusSeverityLevel.ERROR, 30, "Bad event subscription (monitor) identifier"),
        ECA_NEWADDR(StatusSeverityLevel.WARNING, 31, "Remote channel has new network address"),
        ECA_NEWCONN(StatusSeverityLevel.INFO, 32, "New or resumed network connection"),
        ECA_NOCACTX(StatusSeverityLevel.WARNING, 33, "Specified task isn't a member of a CA context"),
        ECA_DEFUNCT(StatusSeverityLevel.ERROR, true, 34, "Attempt to use defunct CA feature failed"),
        ECA_EMPTYSTR(StatusSeverityLevel.WARNING, 35, "The supplied string is empty"),
        ECA_NOREPEATER(StatusSeverityLevel.WARNING, 36, "Unable to spawn the CA repeater thread- auto reconnect will fail"),
        ECA_NOCHANMSG(StatusSeverityLevel.WARNING, 37, "No channel id match for search reply- search reply ignored"),
        ECA_DLCKREST(StatusSeverityLevel.WARNING, 38, "Reseting dead connection- will try to reconnect"),
        ECA_SERVBEHIND(StatusSeverityLevel.WARNING, 39, "Server (IOC) has fallen behind or is not responding- still waiting"),
        ECA_NOCAST(StatusSeverityLevel.WARNING, 40, "No Internet interface with broadcast available"),
        ECA_BADMASK(StatusSeverityLevel.ERROR, 41, "Invalid event selection mask"),
        ECA_IODONE(StatusSeverityLevel.INFO, 42, "IO operations have completed"),
        ECA_IOINPROGRESS(StatusSeverityLevel.INFO, 43, "IO operations are in progress"),
        ECA_BADSYNCGRP(StatusSeverityLevel.ERROR, 44, "Invalid synchronous group identifier"),
        ECA_PUTCBINPROG(StatusSeverityLevel.ERROR, 45, "Put callback timed out"),
        ECA_NORDACCESS(StatusSeverityLevel.WARNING, 46, "Read access denied"),
        ECA_NOWTACCESS(StatusSeverityLevel.WARNING, 47, "Write access denied"),
        ECA_ANACHRONISM(StatusSeverityLevel.ERROR, 48, "Requested feature is no longer supported"),
        ECA_NOSEARCHADDR(StatusSeverityLevel.WARNING, 49, "Empty PV search address list"),
        ECA_NOCONVERT(StatusSeverityLevel.WARNING, 50, "No reasonable data conversion between client and server types"),
        ECA_BADCHID(StatusSeverityLevel.ERROR, 51, "Invalid channel identifier"),
        ECA_BADFUNCPTR(StatusSeverityLevel.ERROR, 52, "Invalid function pointer"),
        ECA_ISATTACHED(StatusSeverityLevel.WARNING, 53, "Thread is already attached to a client context"),
        ECA_UNAVAILINSERV(StatusSeverityLevel.WARNING, 54, "Not supported by attached service"),
        ECA_CHANDESTROY(StatusSeverityLevel.WARNING, 55, "User destroyed channel"),
        ECA_BADPRIORITY(StatusSeverityLevel.ERROR, 56, "Invalid channel priority"),
        ECA_NOTTHREADED(StatusSeverityLevel.ERROR, 57, "Preemptive callback not enabled - additional threads may not join context"),
        ECA_16KARRAYCLIENT(StatusSeverityLevel.WARNING, 58, "Client's protocol revision does not support transfers exceeding 16k bytes"),
        ECA_CONNSEQTMO(StatusSeverityLevel.WARNING, 59, "Virtual circuit connection sequence aborted"),
        ECA_UNRESPTMO(StatusSeverityLevel.WARNING, 60, "Virtual circuit unresponsive");

        private static final StatusMessage[] MESSAGE_INSTANCES;
        private final StatusSeverity defaultSeverity;
        private final int messageNumber;
        private final String message;
        private final int defaultStatusCode;

        private StatusMessage(StatusSeverityLevel level, int messageNumber, String message) {
            this(level, false, messageNumber, message);
        }

        private StatusMessage(StatusSeverityLevel level, boolean severe, int messageNumber, String message) {
            this.messageNumber = messageNumber;
            this.message = message;
            this.defaultSeverity = StatusSeverity.SEVERITY_INSTANCES[level.getSeverityNumber() + (severe ? 4 : 0)];
            this.defaultStatusCode = StatusMessage.calculateStatusCode(level.getSeverityNumber() + (severe ? 4 : 0), messageNumber);
        }

        private static int calculateStatusCode(int severityNumber, int messageNumber) {
            int statusCode = severityNumber & 7;
            return statusCode |= messageNumber << 3 & 0xFFF8;
        }

        public StatusSeverity getDefaultSeverity() {
            return this.defaultSeverity;
        }

        public int getDefaultStatusCode() {
            return this.defaultStatusCode;
        }

        public ChannelAccessStatus toStatus() {
            return ChannelAccessStatus.forStatusCode(this.defaultStatusCode);
        }

        public String toString() {
            return this.message;
        }

        static {
            StatusMessage[] enumInstances = StatusMessage.values();
            MESSAGE_INSTANCES = new StatusMessage[enumInstances.length];
            for (StatusMessage status : enumInstances) {
                int messageNumber = status.messageNumber;
                if (MESSAGE_INSTANCES[messageNumber] != null) {
                    throw new RuntimeException("Detected duplicate message number " + messageNumber + ".");
                }
                StatusMessage.MESSAGE_INSTANCES[messageNumber] = status;
            }
        }
    }
}

