/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.exception.ShortPayloadException;
import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessEventMask;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessSubscriptionMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import java.nio.charset.Charset;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessSubscriptionClientMessage
extends ChannelAccessSubscriptionMessage {
    private static final byte[] TWELVE_ZERO_BYTES = new byte[12];
    private static final int EXPECTED_PAYLOAD_SIZE = 16;
    private short dataType;
    private int count;
    private int sid;
    private int subscriptionId;
    private short mask;

    public ChannelAccessSubscriptionClientMessage(ChannelAccessValueType dataType, int count, int sid, int subscriptionId, ChannelAccessEventMask mask) {
        this.dataType = dataType.toTypeCode();
        this.count = count;
        this.sid = sid;
        this.subscriptionId = subscriptionId;
        this.mask = mask.toNumericMask();
    }

    private ChannelAccessSubscriptionClientMessage(ChannelAccessMessageHeader messageHeader, short dataType, int count, int channelSID, int subscriptionId, short mask) {
        super(messageHeader);
        this.dataType = dataType;
        this.count = count;
        this.sid = channelSID;
        this.subscriptionId = subscriptionId;
        this.mask = mask;
    }

    public ChannelAccessValueType getDataType() {
        try {
            return ChannelAccessValueType.forTypeNumber(this.dataType);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public int getCount() {
        return this.count;
    }

    public int getChannelSID() {
        return this.sid;
    }

    public int getSubscriptionId() {
        return this.subscriptionId;
    }

    public ChannelAccessEventMask getMask() {
        return ChannelAccessEventMask.forNumericMask(this.mask);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessSubscriptionClientMessage other = (ChannelAccessSubscriptionClientMessage)obj;
        return new EqualsBuilder().append(this.dataType, other.dataType).append(this.count, other.count).append(this.sid, other.sid).append(this.subscriptionId, other.subscriptionId).append(this.mask, other.mask).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.dataType).append(this.count).append(this.sid).append(this.subscriptionId).append(this.mask).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("dataType=");
        try {
            sb.append((Object)ChannelAccessValueType.forTypeNumber(this.dataType));
        }
        catch (IllegalArgumentException e) {
            sb.append("UNKNOWN(");
            sb.append(this.dataType);
            sb.append(')');
        }
        sb.append(", count=");
        sb.append(this.count);
        sb.append(", sid=");
        sb.append(this.sid);
        sb.append(", subscriptionId=");
        sb.append(this.subscriptionId);
        sb.append(", mask=");
        sb.append(ChannelAccessEventMask.forNumericMask(this.mask));
        sb.append('}');
        return sb.toString();
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        this.serializeHeader(byteSink, 16, this.dataType, this.count, this.sid, this.subscriptionId, version, maxPayloadSize);
        byteSink.putByteArray(TWELVE_ZERO_BYTES);
        byteSink.putShort(this.mask);
        byteSink.putShort((short)0);
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        this.verifyHeader(16, this.count, version, maxPayloadSize);
    }

    protected static ChannelAccessSubscriptionClientMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, boolean headerOnly) {
        short mask;
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_EVENT_ADD.getCommandNumber());
        if (!headerOnly) {
            int payloadSize = messageHeader.getPayloadSize();
            if (payloadSize < 16) {
                throw new ShortPayloadException("Received a CA_PROTO_EVENT_ADD message with a payload size of " + payloadSize + ". However, such a message should have a payload of at least " + 16 + " bytes.");
            }
            int extraPayloadSize = payloadSize - 16;
            byteSource.skip(12);
            mask = byteSource.getShort();
            byteSource.skip(2 + extraPayloadSize);
        } else {
            mask = 0;
        }
        return new ChannelAccessSubscriptionClientMessage(messageHeader, messageHeader.getDataType(), messageHeader.getCount(), messageHeader.getCID(), messageHeader.getContextSpecific(), mask);
    }
}

