/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.exception.SerializedPayloadTooLargeException;
import com.aquenos.epics.jackie.common.exception.ShortPayloadException;
import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessStatus;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessSubscriptionMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.value.ChannelAccessGettableValue;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueCodec;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import java.nio.charset.Charset;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessSubscriptionServerMessage
extends ChannelAccessSubscriptionMessage {
    private static final byte[] PADDING_BYTES = new byte[8];
    private short dataType;
    private int count;
    private ChannelAccessStatus status;
    private int subscriptionId;
    private ChannelAccessGettableValue<?> value;
    private byte[] rawValue;

    public ChannelAccessSubscriptionServerMessage(ChannelAccessValueType dataType, int count, ChannelAccessStatus status, int subscriptionId, ChannelAccessGettableValue<?> value) {
        if (count < 0) {
            throw new IllegalArgumentException("The count must not be negative.");
        }
        boolean successMessage = status.matchesMessage(ChannelAccessStatus.StatusMessage.ECA_NORMAL);
        if (value == null) {
            if (successMessage) {
                throw new IllegalArgumentException("The value must not be null if the status is ECA_NORMAL.");
            }
        } else {
            if (!successMessage) {
                throw new IllegalArgumentException("The value must be null if the status is not ECA_NORMAL.");
            }
            if (!dataType.equals((Object)value.getType())) {
                throw new IllegalArgumentException("The specified data type (" + dataType.toString() + ") does not match the value's data type (" + (Object)((Object)value.getType()) + ").");
            }
            if (count > value.getValueSize()) {
                throw new IllegalArgumentException("The count (" + count + ") exceeds the number of elements in the value (" + value.getValueSize() + ").");
            }
        }
        this.dataType = dataType.toTypeCode();
        this.count = count;
        this.status = status;
        this.subscriptionId = subscriptionId;
        if (value != null) {
            this.value = value.asReadOnlyValue();
        }
    }

    private ChannelAccessSubscriptionServerMessage(ChannelAccessMessageHeader messageHeader, short dataType, int count, ChannelAccessStatus status, int subscriptionId, ChannelAccessGettableValue<?> value, byte[] rawValue) {
        super(messageHeader);
        this.dataType = dataType;
        this.count = count;
        this.status = status;
        this.subscriptionId = subscriptionId;
        if (value != null) {
            this.value = value.asReadOnlyValue();
        }
        this.rawValue = rawValue;
    }

    public ChannelAccessValueType getDataType() {
        try {
            ChannelAccessValueType type = ChannelAccessValueType.forTypeNumber(this.dataType);
            if (type.isGettable()) {
                return type;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public int getCount() {
        return this.count;
    }

    public ChannelAccessStatus getStatus() {
        return this.status;
    }

    public int getSubscriptionId() {
        return this.subscriptionId;
    }

    public ChannelAccessGettableValue<?> getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        assert (maxPayloadSize % 8 == 0);
        ChannelAccessValueType dataTypeEnum = ChannelAccessValueType.forTypeNumber(this.dataType);
        if (this.rawValue == null) {
            int maxCount = ChannelAccessValueCodec.calculateMaxCount(dataTypeEnum, maxPayloadSize);
            if (this.count > maxCount || this.count < 0) {
                throw new SerializedPayloadTooLargeException("Cannot send message with value type " + dataTypeEnum.toString() + " and count " + ((long)this.count & 0xFFFFFFFFL) + " because payload size limit is set to " + maxPayloadSize + ".");
            }
            int payloadSize = ChannelAccessValueCodec.calculatePayloadSize(ChannelAccessValueType.forTypeNumber(this.dataType), this.count);
            int paddingSize = ChannelAccessSubscriptionServerMessage.calculatePaddingSize(payloadSize);
            this.serializeHeader(byteSink, payloadSize + paddingSize, this.dataType, this.count, this.status.toStatusCode(), this.subscriptionId, version, maxPayloadSize);
            if (this.value != null) {
                ChannelAccessValueCodec.encodeGettableValue(byteSink, this.value, this.count);
                byteSink.putByteArray(PADDING_BYTES, 0, paddingSize);
            } else {
                int numberOfBlocks = (payloadSize + paddingSize) / 8;
                for (int i = 0; i < numberOfBlocks; ++i) {
                    byteSink.putByteArray(PADDING_BYTES);
                }
            }
        } else {
            this.serializeHeader(byteSink, this.rawValue.length, this.dataType, this.count, this.status.toStatusCode(), this.subscriptionId, version, maxPayloadSize);
            byteSink.putByteArray(this.rawValue);
        }
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        assert (maxPayloadSize % 8 == 0);
        ChannelAccessValueType dataTypeEnum = ChannelAccessValueType.forTypeNumber(this.dataType);
        if (this.rawValue == null) {
            int maxCount = ChannelAccessValueCodec.calculateMaxCount(dataTypeEnum, maxPayloadSize);
            if (this.count > maxCount || this.count < 0) {
                throw new SerializedPayloadTooLargeException("Cannot send message with value type " + dataTypeEnum.toString() + " and count " + ((long)this.count & 0xFFFFFFFFL) + " because payload size limit is set to " + maxPayloadSize + ".");
            }
            int payloadSize = ChannelAccessValueCodec.calculatePayloadSize(ChannelAccessValueType.forTypeNumber(this.dataType), this.count);
            int paddingSize = ChannelAccessSubscriptionServerMessage.calculatePaddingSize(payloadSize);
            this.verifyHeader(payloadSize + paddingSize, this.count, version, maxPayloadSize);
        } else {
            this.verifyHeader(this.rawValue.length, this.count, version, maxPayloadSize);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessSubscriptionServerMessage other = (ChannelAccessSubscriptionServerMessage)obj;
        return new EqualsBuilder().append(this.dataType, other.dataType).append(this.count, other.count).append((Object)this.status, (Object)other.status).append(this.subscriptionId, other.subscriptionId).append(this.value, other.value).append(this.rawValue, other.rawValue).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.dataType).append(this.count).append((Object)this.status).append(this.subscriptionId).append(this.value).append(this.rawValue).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("dataType=");
        try {
            sb.append((Object)ChannelAccessValueType.forTypeNumber(this.dataType));
        }
        catch (IllegalArgumentException e) {
            sb.append("UNKNOWN(");
            sb.append(this.dataType);
            sb.append(')');
        }
        sb.append(", count=");
        sb.append(this.count);
        sb.append(", status=");
        sb.append(this.status);
        sb.append(", subscriptionId=");
        sb.append(this.subscriptionId);
        if (this.value != null) {
            sb.append(", value=");
            sb.append(this.value);
        }
        if (this.rawValue != null) {
            sb.append(", rawValue=");
            ChannelAccessSubscriptionServerMessage.addByteArrayToStringBuilder(sb, this.rawValue);
        }
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessSubscriptionServerMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, Charset charset) {
        byte[] rawValue;
        ChannelAccessGettableValue<?> value;
        ChannelAccessValueType dataType;
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_EVENT_ADD.getCommandNumber());
        short dataTypeNumber = messageHeader.getDataType();
        try {
            dataType = ChannelAccessValueType.forTypeNumber(dataTypeNumber);
            if (!dataType.isGettable()) {
                dataType = null;
            }
        }
        catch (IllegalArgumentException e) {
            dataType = null;
        }
        int count = messageHeader.getCount();
        ChannelAccessStatus status = ChannelAccessStatus.forStatusCode(messageHeader.getCID());
        int subscriptionId = messageHeader.getContextSpecific();
        int actualPayloadSize = messageHeader.getPayloadSize();
        assert (actualPayloadSize != 0);
        if (dataType == null) {
            value = null;
            rawValue = byteSource.getByteArray(actualPayloadSize);
        } else {
            if (status.matchesMessage(ChannelAccessStatus.StatusMessage.ECA_NORMAL)) {
                int expectedPayloadSize;
                try {
                    expectedPayloadSize = ChannelAccessValueCodec.calculatePayloadSize(dataType, count);
                }
                catch (IllegalArgumentException e) {
                    throw new ShortPayloadException("Payload size of " + actualPayloadSize + " is too small to hold a " + dataType.toString() + " with " + ((long)count & 0xFFFFFFFFL) + " elements.");
                }
                if (actualPayloadSize < expectedPayloadSize) {
                    if (count == 1 && dataType.toSimpleType().equals((Object)ChannelAccessValueType.DBR_STRING) && actualPayloadSize >= ChannelAccessValueCodec.calculatePayloadSize(dataType, 0)) {
                        expectedPayloadSize = actualPayloadSize;
                    } else {
                        throw new ShortPayloadException("Received a CA_PROTO_EVENT_ADD message with a payload size of " + actualPayloadSize + ". However, the message should have a payload of at least " + expectedPayloadSize + " bytes.");
                    }
                }
                value = ChannelAccessValueCodec.decodeGettableValue(byteSource, dataType, expectedPayloadSize, count, charset);
                byteSource.skip(actualPayloadSize - expectedPayloadSize);
            } else {
                byteSource.skip(actualPayloadSize);
                value = null;
            }
            rawValue = null;
        }
        return new ChannelAccessSubscriptionServerMessage(messageHeader, dataTypeNumber, count, status, subscriptionId, value, rawValue);
    }
}

