/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.exception.UnsupportedInThisVersionException;
import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.util.NullTerminatedStringUtil;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.Pair;

public final class ChannelAccessUserNameMessage
extends ChannelAccessMessage {
    private static final int OLD_PROTOCOL_MAX_PAYLOAD_SIZE = 65528;
    private String userName;

    public ChannelAccessUserNameMessage(String userName) {
        super(ChannelAccessCommand.CA_PROTO_CLIENT_NAME);
        if (userName == null) {
            throw new NullPointerException("User name must not be null.");
        }
        this.userName = userName;
    }

    private ChannelAccessUserNameMessage(ChannelAccessMessageHeader messageHeader, String userName) {
        super(ChannelAccessCommand.CA_PROTO_CLIENT_NAME, messageHeader);
        this.userName = userName;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (!version.includes(ChannelAccessVersion.V4_1)) {
            throw new UnsupportedInThisVersionException(version, ChannelAccessCommand.CA_PROTO_CLIENT_NAME);
        }
        if (this.userName == null) {
            throw new UnsupportedOperationException("Cannot serialize the message payload for a message that has been constructed without the payload.");
        }
        Pair<byte[], Integer> userNameBytesAndLength = NullTerminatedStringUtil.stringToTruncatedNullTerminatedBytes(this.userName, ChannelAccessUserNameMessage.calculateMaxPayloadSize(version, maxPayloadSize), 8, charset);
        byte[] userNameAsBytes = (byte[])userNameBytesAndLength.getLeft();
        int userNameLength = (Integer)userNameBytesAndLength.getRight();
        this.serializeHeader(byteSink, userNameLength, (short)0, 0, 0, 0, version, maxPayloadSize);
        byteSink.putByteArray(userNameAsBytes, 0, userNameLength);
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (!version.includes(ChannelAccessVersion.V4_1)) {
            throw new UnsupportedInThisVersionException(version, ChannelAccessCommand.CA_PROTO_CLIENT_NAME);
        }
        if (this.userName == null) {
            throw new UnsupportedOperationException("Cannot serialize the message payload for a message that has been constructed without the payload.");
        }
    }

    private static int calculateMaxPayloadSize(ChannelAccessVersion version, int maxPayloadSize) {
        if (!version.includes(ChannelAccessVersion.V4_9) && maxPayloadSize > 65528) {
            return 65528;
        }
        return maxPayloadSize;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessUserNameMessage other = (ChannelAccessUserNameMessage)obj;
        return new EqualsBuilder().append((Object)this.userName, (Object)other.userName).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.userName).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("userName=");
        if (this.userName != null) {
            sb.append('\"');
            sb.append(StringEscapeUtils.escapeJava((String)this.userName));
            sb.append('\"');
        } else {
            sb.append("null");
        }
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessUserNameMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, boolean headerOnly, Charset charset) {
        String userName;
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_CLIENT_NAME.getCommandNumber());
        if (!headerOnly) {
            byte[] userNameAsBytes = byteSource.getByteArray(messageHeader.getPayloadSize());
            userName = NullTerminatedStringUtil.nullTerminatedBytesToString(userNameAsBytes, charset);
        } else {
            userName = null;
        }
        return new ChannelAccessUserNameMessage(messageHeader, userName);
    }

    public String getUserName() {
        return this.userName;
    }
}

