/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

public enum ChannelAccessVersion implements Comparable<ChannelAccessVersion>
{
    V4_0(0),
    V4_1(1),
    V4_2(2),
    V4_3(3),
    V4_4(4),
    V4_5(5),
    V4_6(6),
    V4_7(7),
    V4_8(8),
    V4_9(9),
    V4_10(10),
    V4_11(11),
    V4_12(12),
    V4_13(13);

    public static final ChannelAccessVersion NEWEST_SUPPORTED_VERSION;
    private int majorVersion;
    private int minorVersion;
    private static final ChannelAccessVersion[] MINOR_VERSION_TO_ENUM;
    private static final int MAXIMUM_MINOR_VERSION;

    private ChannelAccessVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    private ChannelAccessVersion(int minorVersion) {
        this(4, minorVersion);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public short getMinorVersionAsShort() {
        if (this.minorVersion >= 65536) {
            throw new RuntimeException("Cannot cast version number " + this.minorVersion + " to a 16-bit integer.");
        }
        return (short)this.minorVersion;
    }

    public boolean includes(ChannelAccessVersion otherVersion) {
        return otherVersion.minorVersion <= this.minorVersion && otherVersion.majorVersion == this.majorVersion;
    }

    public static ChannelAccessVersion forVersion(int majorVersion, int minorVersion) {
        if (majorVersion != 4) {
            throw new IllegalArgumentException("Only major version 4 is supported.");
        }
        return ChannelAccessVersion.forMinorVersion(minorVersion);
    }

    public static ChannelAccessVersion forMinorVersion(int minorVersion) {
        if (minorVersion < 0) {
            throw new IllegalArgumentException("Minor version must be greater than or equal to 0.");
        }
        if (minorVersion > MAXIMUM_MINOR_VERSION) {
            minorVersion = MAXIMUM_MINOR_VERSION;
        }
        return MINOR_VERSION_TO_ENUM[minorVersion];
    }

    public static ChannelAccessVersion forMinorVersion(short minorVersion) {
        return ChannelAccessVersion.forMinorVersion(minorVersion & 0xFFFF);
    }

    public String toString() {
        return "" + this.majorVersion + "." + this.minorVersion;
    }

    static {
        NEWEST_SUPPORTED_VERSION = V4_13;
        MINOR_VERSION_TO_ENUM = new ChannelAccessVersion[]{V4_0, V4_1, V4_2, V4_3, V4_4, V4_5, V4_6, V4_7, V4_8, V4_9, V4_10, V4_11, V4_12, V4_13};
        MAXIMUM_MINOR_VERSION = MINOR_VERSION_TO_ENUM.length - 1;
    }
}

