/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.exception.InvalidPriorityException;
import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersionMessage;
import java.nio.charset.Charset;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessVersionTCPClientMessage
extends ChannelAccessVersionMessage {
    private short priority;

    public ChannelAccessVersionTCPClientMessage(ChannelAccessVersion version, short priority) {
        super(version);
        if (version == null) {
            throw new NullPointerException("Channel Acccess version must not be null.");
        }
        if (priority < 0 || priority > 99) {
            throw new InvalidPriorityException();
        }
        this.priority = priority;
    }

    private ChannelAccessVersionTCPClientMessage(ChannelAccessMessageHeader messageHeader, ChannelAccessVersion version, short priority) {
        super(messageHeader, version);
        if (priority < 0 || priority > 99) {
            throw new InvalidPriorityException();
        }
        this.priority = priority;
    }

    public short getPriority() {
        return this.priority;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        this.serializeHeader(byteSink, 0, this.priority, this.version.getMinorVersionAsShort(), 0, 0, version, maxPayloadSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessVersionTCPClientMessage other = (ChannelAccessVersionTCPClientMessage)obj;
        return this.priority == other.priority;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.priority).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("version=");
        sb.append(this.version);
        sb.append(", priority=");
        sb.append(this.priority);
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessVersionTCPClientMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, boolean headerOnly) {
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_VERSION.getCommandNumber());
        if (!headerOnly) {
            byteSource.skip(messageHeader.getPayloadSize());
        }
        return new ChannelAccessVersionTCPClientMessage(messageHeader, ChannelAccessVersion.forMinorVersion(messageHeader.getCount()), messageHeader.getDataType());
    }
}

