/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersionMessage;
import java.nio.charset.Charset;

public final class ChannelAccessVersionTCPServerMessage
extends ChannelAccessVersionMessage {
    public ChannelAccessVersionTCPServerMessage(ChannelAccessVersion version) {
        super(version);
        if (version == null) {
            throw new NullPointerException("Channel Acccess version must not be null.");
        }
    }

    private ChannelAccessVersionTCPServerMessage(ChannelAccessMessageHeader messageHeader, ChannelAccessVersion version) {
        super(messageHeader, version);
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        this.serializeHeader(byteSink, 0, (short)0, this.version.getMinorVersionAsShort(), 0, 0, version, maxPayloadSize);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("version=");
        sb.append(this.version);
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessVersionTCPServerMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource) {
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_VERSION.getCommandNumber());
        byteSource.skip(messageHeader.getPayloadSize());
        return new ChannelAccessVersionTCPServerMessage(messageHeader, ChannelAccessVersion.forMinorVersion(messageHeader.getCount()));
    }
}

