/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersionMessage;
import java.nio.charset.Charset;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessVersionUDPMessage
extends ChannelAccessVersionMessage {
    private boolean sequenceNumberIsValid;
    private int sequenceNumber;

    public ChannelAccessVersionUDPMessage(ChannelAccessVersion version, boolean sequenceNumberIsValid, int sequenceNumber) {
        super(version);
        if (version == null) {
            throw new NullPointerException("Channel Acccess version must not be null.");
        }
        this.sequenceNumberIsValid = sequenceNumberIsValid;
        this.sequenceNumber = sequenceNumber;
    }

    private ChannelAccessVersionUDPMessage(ChannelAccessMessageHeader messageHeader, ChannelAccessVersion version, boolean sequenceNumberIsValid, int sequenceNumber) {
        super(messageHeader, version);
        this.sequenceNumberIsValid = sequenceNumberIsValid;
        this.sequenceNumber = sequenceNumber;
    }

    public boolean isSequenceNumberValid() {
        return this.sequenceNumberIsValid;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        this.serializeHeader(byteSink, 0, (short)(this.sequenceNumberIsValid ? 1 : 0), this.version.getMinorVersionAsShort(), this.sequenceNumber, 0, version, maxPayloadSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessVersionUDPMessage other = (ChannelAccessVersionUDPMessage)obj;
        return new EqualsBuilder().append(this.sequenceNumberIsValid, other.sequenceNumberIsValid).append(this.sequenceNumber, other.sequenceNumber).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.sequenceNumberIsValid).append(this.sequenceNumber).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("version=");
        sb.append(this.version);
        sb.append(", sequenceNumberIsValid=");
        sb.append(this.sequenceNumberIsValid);
        sb.append(", sequenceNumber=");
        sb.append(this.sequenceNumber);
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessVersionUDPMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, boolean headerOnly) {
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_VERSION.getCommandNumber());
        if (!headerOnly) {
            byteSource.skip(messageHeader.getPayloadSize());
        }
        return new ChannelAccessVersionUDPMessage(messageHeader, ChannelAccessVersion.forMinorVersion(messageHeader.getCount()), (messageHeader.getDataType() & 1) != 0, messageHeader.getCID());
    }
}

