/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.exception.SerializedPayloadTooLargeException;
import com.aquenos.epics.jackie.common.exception.ShortPayloadException;
import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.value.ChannelAccessPuttableValue;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueCodec;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import java.nio.charset.Charset;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessWriteMessage
extends ChannelAccessMessage {
    private static final byte[] PADDING_BYTES = new byte[8];
    private short dataType;
    private int count;
    private int sid;
    private int cid;
    private ChannelAccessPuttableValue<?> value;
    private byte[] rawValue;

    public ChannelAccessWriteMessage(ChannelAccessValueType dataType, int count, int sid, int cid, ChannelAccessPuttableValue<?> value) {
        super(ChannelAccessCommand.CA_PROTO_WRITE);
        if (!dataType.equals((Object)value.getType())) {
            throw new IllegalArgumentException("Specified data type (" + dataType.toString() + ") does not match value's data type (" + value.getType().toString() + ").");
        }
        if (count < 0) {
            throw new IllegalArgumentException("Count must not be negative.");
        }
        if (count > value.getValueSize()) {
            throw new IllegalArgumentException("Number of elements to be sent must not exceed the number of elements the value has.");
        }
        this.dataType = dataType.toTypeCode();
        this.count = count;
        this.sid = sid;
        this.cid = cid;
        this.value = value.asReadOnlyValue();
    }

    private ChannelAccessWriteMessage(ChannelAccessMessageHeader messageHeader, short dataType, int count, int sid, int cid, ChannelAccessPuttableValue<?> value, byte[] rawValue) {
        super(ChannelAccessCommand.CA_PROTO_WRITE, messageHeader);
        this.dataType = dataType;
        this.count = count;
        this.sid = sid;
        this.cid = cid;
        if (value != null) {
            this.value = value.asReadOnlyValue();
        }
        this.rawValue = rawValue;
    }

    public ChannelAccessValueType getDataType() {
        try {
            ChannelAccessValueType type = ChannelAccessValueType.forTypeNumber(this.dataType);
            if (type.isPuttable()) {
                return type;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public int getCount() {
        return this.count;
    }

    public int getChannelSID() {
        return this.sid;
    }

    public int getChannelCID() {
        return this.cid;
    }

    public ChannelAccessPuttableValue<?> getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        assert (maxPayloadSize % 8 == 0);
        ChannelAccessValueType dataTypeEnum = ChannelAccessValueType.forTypeNumber(this.dataType);
        if (this.value != null) {
            int maxCount = ChannelAccessValueCodec.calculateMaxCount(dataTypeEnum, maxPayloadSize);
            if (this.count > maxCount || this.count < 0) {
                throw new SerializedPayloadTooLargeException("Cannot send message with value type " + dataTypeEnum.toString() + " and count " + ((long)this.count & 0xFFFFFFFFL) + " because payload size limit is set to " + maxPayloadSize + ".");
            }
            int payloadSize = ChannelAccessValueCodec.calculatePayloadSize(ChannelAccessValueType.forTypeNumber(this.dataType), this.count);
            int paddingSize = ChannelAccessWriteMessage.calculatePaddingSize(payloadSize);
            this.serializeHeader(byteSink, payloadSize + paddingSize, this.dataType, this.count, this.sid, this.cid, version, maxPayloadSize);
            ChannelAccessValueCodec.encodePuttableValue(byteSink, this.value, this.count);
            byteSink.putByteArray(PADDING_BYTES, 0, paddingSize);
        } else if (this.rawValue != null) {
            this.serializeHeader(byteSink, this.rawValue.length, this.dataType, this.count, this.sid, this.cid, version, maxPayloadSize);
            byteSink.putByteArray(this.rawValue);
        } else {
            throw new UnsupportedOperationException("Cannot serialize the message payload for a message that has been constructed without the payload.");
        }
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        assert (maxPayloadSize % 8 == 0);
        ChannelAccessValueType dataTypeEnum = ChannelAccessValueType.forTypeNumber(this.dataType);
        if (this.value != null) {
            int maxCount = ChannelAccessValueCodec.calculateMaxCount(dataTypeEnum, maxPayloadSize);
            if (this.count > maxCount || this.count < 0) {
                throw new SerializedPayloadTooLargeException("Cannot send message with value type " + dataTypeEnum.toString() + " and count " + ((long)this.count & 0xFFFFFFFFL) + " because payload size limit is set to " + maxPayloadSize + ".");
            }
            int payloadSize = ChannelAccessValueCodec.calculatePayloadSize(ChannelAccessValueType.forTypeNumber(this.dataType), this.count);
            int paddingSize = ChannelAccessWriteMessage.calculatePaddingSize(payloadSize);
            this.verifyHeader(payloadSize + paddingSize, this.count, version, maxPayloadSize);
        } else if (this.rawValue != null) {
            this.verifyHeader(this.rawValue.length, this.count, version, maxPayloadSize);
        } else {
            throw new UnsupportedOperationException("Cannot serialize the message payload for a message that has been constructed without the payload.");
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessWriteMessage other = (ChannelAccessWriteMessage)obj;
        return new EqualsBuilder().append(this.dataType, other.dataType).append(this.count, other.count).append(this.sid, other.sid).append(this.cid, other.cid).append(this.value, other.value).append(this.rawValue, other.rawValue).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.dataType).append(this.count).append(this.sid).append(this.cid).append(this.value).append(this.rawValue).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("dataType=");
        try {
            sb.append((Object)ChannelAccessValueType.forTypeNumber(this.dataType));
        }
        catch (IllegalArgumentException e) {
            sb.append("UNKNOWN(");
            sb.append(this.dataType);
            sb.append(')');
        }
        sb.append(", count=");
        sb.append(this.count);
        sb.append(", sid=");
        sb.append(this.sid);
        sb.append(", cid=");
        sb.append(this.cid);
        if (this.value != null) {
            sb.append(", value=");
            sb.append(this.value);
        }
        if (this.rawValue != null) {
            sb.append(", rawValue=");
            ChannelAccessWriteMessage.addByteArrayToStringBuilder(sb, this.rawValue);
        }
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessWriteMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, boolean headerOnly, Charset charset) {
        byte[] rawValue;
        ChannelAccessPuttableValue<?> value;
        ChannelAccessValueType dataType;
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_WRITE.getCommandNumber());
        short dataTypeNumber = messageHeader.getDataType();
        try {
            dataType = ChannelAccessValueType.forTypeNumber(dataTypeNumber);
            if (!dataType.isPuttable()) {
                dataType = null;
            }
        }
        catch (IllegalArgumentException e) {
            dataType = null;
        }
        int count = messageHeader.getCount();
        int sid = messageHeader.getCID();
        int cid = messageHeader.getContextSpecific();
        if (headerOnly) {
            value = null;
            rawValue = null;
        } else {
            int actualPayloadSize = messageHeader.getPayloadSize();
            if (dataType == null) {
                value = null;
                rawValue = byteSource.getByteArray(actualPayloadSize);
            } else {
                int expectedPayloadSize;
                try {
                    expectedPayloadSize = ChannelAccessValueCodec.calculatePayloadSize(dataType, count);
                }
                catch (IllegalArgumentException e) {
                    throw new ShortPayloadException("Payload size of " + actualPayloadSize + " is too small to hold a " + dataType.toString() + " with " + ((long)count & 0xFFFFFFFFL) + " elements.");
                }
                if (actualPayloadSize < expectedPayloadSize) {
                    if (count == 1 && dataType.toSimpleType().equals((Object)ChannelAccessValueType.DBR_STRING) && actualPayloadSize >= ChannelAccessValueCodec.calculatePayloadSize(dataType, 0)) {
                        expectedPayloadSize = actualPayloadSize;
                    } else {
                        throw new ShortPayloadException("Received a CA_PROTO_WRITE message with a payload size of " + actualPayloadSize + ". However, the message should have a payload of at least " + expectedPayloadSize + " bytes.");
                    }
                }
                value = ChannelAccessValueCodec.decodePuttableValue(byteSource, dataType, expectedPayloadSize, count, charset);
                byteSource.skip(actualPayloadSize - expectedPayloadSize);
                rawValue = null;
            }
        }
        return new ChannelAccessWriteMessage(messageHeader, dataTypeNumber, count, sid, cid, value, rawValue);
    }
}

