/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessStatus;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessWriteNotifyMessage;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import java.nio.charset.Charset;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessWriteNotifyServerMessage
extends ChannelAccessWriteNotifyMessage {
    private short dataType;
    private int count;
    private ChannelAccessStatus status;
    private int operationId;

    public ChannelAccessWriteNotifyServerMessage(ChannelAccessValueType dataType, int count, ChannelAccessStatus status, int operationId) {
        if (status == null) {
            throw new NullPointerException();
        }
        this.dataType = dataType.toTypeCode();
        this.count = count;
        this.status = status;
        this.operationId = operationId;
    }

    private ChannelAccessWriteNotifyServerMessage(ChannelAccessMessageHeader messageHeader, short dataType, int count, ChannelAccessStatus status, int operationId) {
        super(messageHeader);
        this.dataType = dataType;
        this.count = count;
        this.status = status;
        this.operationId = operationId;
    }

    public ChannelAccessValueType getDataType() {
        try {
            return ChannelAccessValueType.forTypeNumber(this.dataType);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public int getCount() {
        return this.count;
    }

    public ChannelAccessStatus getStatus() {
        return this.status;
    }

    public int getOperationId() {
        return this.operationId;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        this.serializeHeader(byteSink, 0, this.dataType, this.count, this.status.toStatusCode(), this.operationId, version, maxPayloadSize);
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        this.verifyHeader(0, this.count, version, maxPayloadSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessWriteNotifyServerMessage other = (ChannelAccessWriteNotifyServerMessage)obj;
        return new EqualsBuilder().append(this.dataType, other.dataType).append(this.count, other.count).append((Object)this.status, (Object)other.status).append(this.operationId, other.operationId).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.dataType).append(this.count).append((Object)this.status).append(this.operationId).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("dataType=");
        try {
            sb.append((Object)ChannelAccessValueType.forTypeNumber(this.dataType));
        }
        catch (IllegalArgumentException e) {
            sb.append("UNKNOWN(");
            sb.append(this.dataType);
            sb.append(')');
        }
        sb.append(", count=");
        sb.append(this.count);
        sb.append(", status=");
        sb.append(this.status);
        sb.append(", operationId=");
        sb.append(this.operationId);
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessWriteNotifyServerMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource) {
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_WRITE_NOTIFY.getCommandNumber());
        byteSource.skip(messageHeader.getPayloadSize());
        return new ChannelAccessWriteNotifyServerMessage(messageHeader, messageHeader.getDataType(), messageHeader.getCount(), ChannelAccessStatus.forStatusCode(messageHeader.getCID()), messageHeader.getContextSpecific());
    }
}

