/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.util;

import com.aquenos.epics.jackie.common.exception.ConcurrentNotificationException;
import com.aquenos.epics.jackie.common.util.FutureCompletionListener;
import com.aquenos.epics.jackie.common.util.ListenableFuture;
import com.aquenos.epics.jackie.common.util.ListenerLockPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractListenableFuture<V>
implements ListenableFuture<V> {
    protected final Object completionListenerLock = new Object();
    protected final ListenerLockPolicy listenerLockPolicy;
    private HashMap<FutureCompletionListener<? super V>, ListenerRegistration<V>> listeners = new HashMap();
    private boolean notificationDone;

    protected AbstractListenableFuture() {
        this(ListenerLockPolicy.BLOCK);
    }

    protected AbstractListenableFuture(ListenerLockPolicy listenerLockPolicy) {
        if (listenerLockPolicy == null) {
            throw new NullPointerException("The listener lock-policy must not be null.");
        }
        this.listenerLockPolicy = listenerLockPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCompletionListeners() {
        ArrayList<ListenerRegistration<V>> localListeners;
        Iterator<ListenerRegistration<V>> iterator = this.completionListenerLock;
        synchronized (iterator) {
            if (this.notificationDone) {
                throw new IllegalStateException("notifyCompletionListeners() has already been called.");
            }
            if (!this.isDone()) {
                throw new IllegalStateException("The notifyCompletionListeners() method should only be called if the future has completed (isDone() returns true).");
            }
            this.notificationDone = true;
            localListeners = new ArrayList<ListenerRegistration<V>>(this.listeners.values());
        }
        for (ListenerRegistration<V> listenerRegistration : localListeners) {
            listenerRegistration.lock.lock();
            try {
                if (!listenerRegistration.active) continue;
                this.notifyCompletionListener(listenerRegistration.listener);
            }
            finally {
                listenerRegistration.lock.unlock();
            }
        }
    }

    protected void notifyCompletionListener(FutureCompletionListener<? super V> listener) {
        listener.completed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addCompletionListener(FutureCompletionListener<? super V> listener) {
        boolean gotLock;
        boolean localNotificationDone;
        ListenerRegistration<? super V> listenerRegistration;
        if (listener == null) {
            throw new NullPointerException("The listener parameter must not be null.");
        }
        Object object = this.completionListenerLock;
        synchronized (object) {
            if (this.listeners.containsKey(listener)) {
                return false;
            }
            listenerRegistration = new ListenerRegistration<V>(listener);
            this.listeners.put(listener, listenerRegistration);
            localNotificationDone = this.notificationDone;
        }
        if (localNotificationDone && (gotLock = listenerRegistration.lock.tryLock())) {
            try {
                if (listenerRegistration.active) {
                    this.notifyCompletionListener(listener);
                }
            }
            finally {
                listenerRegistration.lock.unlock();
            }
        }
        return true;
    }

    @Override
    public ListenerLockPolicy getListenerLockPolicy() {
        return this.listenerLockPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCompletionListener(FutureCompletionListener<? super V> listener) {
        ListenerRegistration<V> listenerRegistration;
        Object object = this.completionListenerLock;
        synchronized (object) {
            listenerRegistration = this.listeners.remove(listener);
        }
        if (listenerRegistration != null) {
            boolean gotLock;
            if (this.listenerLockPolicy == ListenerLockPolicy.BLOCK) {
                listenerRegistration.lock.lock();
                gotLock = true;
            } else {
                gotLock = listenerRegistration.lock.tryLock();
            }
            if (gotLock) {
                try {
                    listenerRegistration.active = false;
                }
                finally {
                    listenerRegistration.lock.unlock();
                }
            } else if (this.listenerLockPolicy == ListenerLockPolicy.REPORT) {
                throw new ConcurrentNotificationException("The listener has been removed but a notification is already in progress, so the listener is still going to be notified.");
            }
            return true;
        }
        return false;
    }

    private static class ListenerRegistration<V> {
        public final FutureCompletionListener<? super V> listener;
        public boolean active = true;
        public final ReentrantLock lock = new ReentrantLock();

        public ListenerRegistration(FutureCompletionListener<? super V> listener) {
            this.listener = listener;
        }
    }
}

