/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.util;

import com.aquenos.epics.jackie.common.util.SimpleConcurrentQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class BasicIntegerIdPool {
    private int minimumId;
    private int maximumId;
    private boolean wrapAround;
    private long blockFromReuseTime;
    private boolean earlyReuseOnExhaustion;
    private AtomicInteger nextId;
    private SimpleConcurrentQueue<ReusableId> reusableIds;

    public BasicIntegerIdPool(int minimumId, int maximumId, long blockFromReuseTime, boolean earlyReuseOnExhaustion) {
        this.minimumId = minimumId;
        this.maximumId = maximumId;
        if (minimumId == maximumId || maximumId == minimumId - 1 || minimumId == Integer.MIN_VALUE && maximumId == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The minimum ID and maximum ID must be chosen so that there is at least one ID that will never be used.");
        }
        boolean bl = this.wrapAround = maximumId <= minimumId;
        if (blockFromReuseTime < 0L) {
            throw new IllegalArgumentException("The block-from-reuse time must not be negative.");
        }
        this.blockFromReuseTime = blockFromReuseTime;
        this.earlyReuseOnExhaustion = earlyReuseOnExhaustion;
        this.nextId = new AtomicInteger(minimumId);
        this.reusableIds = new SimpleConcurrentQueue();
    }

    public int acquireId() {
        return this.acquireIdInternal(false);
    }

    private int acquireIdInternal(boolean ignoreReuseTime) {
        ReusableId nextReusableId;
        long currentTime = System.currentTimeMillis();
        while ((nextReusableId = this.reusableIds.peek()) != null && (nextReusableId.reuseAfter <= currentTime || ignoreReuseTime)) {
            if (!this.reusableIds.removeIfMatch(nextReusableId)) continue;
            return nextReusableId.id;
        }
        if (ignoreReuseTime) {
            throw new IllegalStateException("No ID could be acquired because all possible IDs are currently in use.");
        }
        Integer newId = this.acquireNewId();
        if (newId != null) {
            return newId;
        }
        if (this.earlyReuseOnExhaustion) {
            return this.acquireIdInternal(true);
        }
        throw new IllegalStateException("No ID could be acquired because all possible IDs are currently in use or still blocked from reuse.");
    }

    private Integer acquireNewId() {
        int nextNextId;
        int currentNextId = this.nextId.get();
        if (!this.isWithinLimits(currentNextId)) {
            return null;
        }
        int n = nextNextId = currentNextId == Integer.MAX_VALUE ? Integer.MIN_VALUE : currentNextId + 1;
        if (this.nextId.compareAndSet(currentNextId, nextNextId)) {
            return currentNextId;
        }
        return this.acquireNewId();
    }

    private boolean isWithinLimits(int id) {
        if (this.wrapAround) {
            return id >= this.minimumId || id <= this.maximumId;
        }
        return id >= this.minimumId && id <= this.maximumId;
    }

    public void releaseId(int id) {
        ReusableId reusableId = new ReusableId();
        reusableId.id = id;
        reusableId.reuseAfter = System.currentTimeMillis() + this.blockFromReuseTime;
        this.reusableIds.add(reusableId);
    }

    private static class ReusableId {
        public int id;
        public long reuseAfter;

        private ReusableId() {
        }
    }
}

