/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.util;

import com.aquenos.epics.jackie.common.exception.ErrorHandler;
import com.aquenos.epics.jackie.common.exception.ExceptionSafeErrorHandler;
import com.aquenos.epics.jackie.common.exception.NullErrorHandler;
import com.aquenos.epics.jackie.common.util.Inet4AddressUtil;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrMatcher;
import org.apache.commons.lang3.text.StrTokenizer;
import org.apache.commons.lang3.tuple.Pair;

public final class EnvironmentUtil {
    private EnvironmentUtil() {
    }

    private static int toPortNumber(String portString) {
        if (!StringUtils.isNumeric((CharSequence)portString) || portString.isEmpty() || portString.length() > 5) {
            return -1;
        }
        int port = Integer.parseInt(portString, 10);
        if (port > 65535) {
            return -1;
        }
        return port;
    }

    @Deprecated
    public static List<Pair<Inet4Address, Integer>> addressAndPortListFromEnvironment(String environmentVariableName, int defaultPort) {
        if (defaultPort < 0 || defaultPort > 65535) {
            throw new IllegalArgumentException("Not a valid port number: " + defaultPort);
        }
        LinkedList<Pair<Inet4Address, Integer>> addressList = new LinkedList<Pair<Inet4Address, Integer>>();
        String environmentVariable = System.getenv(environmentVariableName);
        if (environmentVariable == null) {
            return Collections.emptyList();
        }
        StrTokenizer tokenizer = new StrTokenizer(environmentVariable);
        tokenizer.setTrimmerMatcher(StrMatcher.splitMatcher());
        while (tokenizer.hasNext()) {
            Inet4Address address;
            String portPart;
            String addressPart;
            String token = tokenizer.next();
            int indexOfColon = token.indexOf(58);
            if (indexOfColon == -1) {
                addressPart = token;
                portPart = null;
            } else {
                addressPart = token.substring(0, indexOfColon);
                portPart = token.substring(indexOfColon + 1, token.length());
            }
            try {
                address = Inet4AddressUtil.stringToInetAddress(addressPart);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            int port = defaultPort;
            if (portPart != null && (port = EnvironmentUtil.toPortNumber(portPart)) < 1) continue;
            addressList.add((Pair<Inet4Address, Integer>)Pair.of((Object)address, (Object)port));
        }
        return addressList;
    }

    public static boolean booleanFromEnvironment(String environmentVariableName, boolean defaultValue) {
        String environmentVariable = System.getenv(environmentVariableName);
        if (environmentVariable == null) {
            return defaultValue;
        }
        if (environmentVariable.equalsIgnoreCase("YES")) {
            return true;
        }
        if (environmentVariable.equalsIgnoreCase("NO")) {
            return false;
        }
        return defaultValue;
    }

    @Deprecated
    public static int portNumberFromEnvironment(String environmentVariableName, int defaultValue, boolean allowZero) {
        return EnvironmentUtil.portNumberFromEnvironment(environmentVariableName, defaultValue, allowZero, null);
    }

    public static int portNumberFromEnvironment(String environmentVariableName, int defaultValue, boolean allowZero, ErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = new NullErrorHandler();
        } else if (!(errorHandler instanceof ExceptionSafeErrorHandler)) {
            errorHandler = new ExceptionSafeErrorHandler(errorHandler);
        }
        String environmentVariable = System.getenv(environmentVariableName);
        if (environmentVariable == null) {
            return defaultValue;
        }
        int port = EnvironmentUtil.toPortNumber(environmentVariable);
        if (port == -1 || port == 0 && !allowZero) {
            errorHandler.handleError(EnvironmentUtil.class, null, "Using default value " + defaultValue + " for " + environmentVariableName + " because specified value is invalid: " + environmentVariable);
            return defaultValue;
        }
        return port;
    }

    @Deprecated
    public static double doubleFromEnvironment(String environmentVariableName, double defaultValue) {
        return EnvironmentUtil.doubleFromEnvironment(environmentVariableName, defaultValue, null);
    }

    public static double doubleFromEnvironment(String environmentVariableName, double defaultValue, ErrorHandler errorHandler) {
        double value;
        if (errorHandler == null) {
            errorHandler = new NullErrorHandler();
        } else if (!(errorHandler instanceof ExceptionSafeErrorHandler)) {
            errorHandler = new ExceptionSafeErrorHandler(errorHandler);
        }
        String environmentVariable = System.getenv(environmentVariableName);
        if (environmentVariable == null) {
            return defaultValue;
        }
        try {
            value = Double.parseDouble(environmentVariable);
        }
        catch (NumberFormatException e) {
            value = Double.NaN;
        }
        if (!Double.isFinite(value)) {
            errorHandler.handleError(EnvironmentUtil.class, null, "Using default value " + defaultValue + " for " + environmentVariableName + " because specified value is invalid: " + environmentVariable);
            return defaultValue;
        }
        return value;
    }

    public static List<InetSocketAddress> inet4SocketAddressListFromEnvironment(String environmentVariableName, int defaultPort, boolean allowZero, ErrorHandler errorHandler) {
        String environmentVariable = System.getenv(environmentVariableName);
        if (environmentVariable == null) {
            return Collections.emptyList();
        }
        ErrorHandler wrappingErrorHandler = null;
        if (errorHandler != null) {
            wrappingErrorHandler = (context, e, description) -> {
                description = "Error while parsing environment variable " + environmentVariableName + ": " + description;
                errorHandler.handleError(context, e, description);
            };
        }
        return Inet4AddressUtil.stringToInet4SocketAddressList(environmentVariable, defaultPort, allowZero, wrappingErrorHandler);
    }

    @Deprecated
    public static int integerFromEnvironment(String environmentVariableName, int defaultValue, int lowerLimit, int upperLimit) {
        return EnvironmentUtil.integerFromEnvironment(environmentVariableName, defaultValue, lowerLimit, upperLimit, null);
    }

    public static int integerFromEnvironment(String environmentVariableName, int defaultValue, int lowerLimit, int upperLimit, ErrorHandler errorHandler) {
        int value;
        if (lowerLimit > upperLimit) {
            throw new IllegalArgumentException("Lower limit must not be greater than upperLimit.");
        }
        if (defaultValue < lowerLimit || defaultValue > upperLimit) {
            throw new IllegalArgumentException("The default value must be within the interval defined by the lower and upper limit.");
        }
        if (errorHandler == null) {
            errorHandler = new NullErrorHandler();
        } else if (!(errorHandler instanceof ExceptionSafeErrorHandler)) {
            errorHandler = new ExceptionSafeErrorHandler(errorHandler);
        }
        String environmentVariable = System.getenv(environmentVariableName);
        if (environmentVariable == null) {
            return defaultValue;
        }
        try {
            value = Integer.parseInt(environmentVariable);
        }
        catch (NumberFormatException e) {
            errorHandler.handleError(EnvironmentUtil.class, null, "Using default value " + defaultValue + " for " + environmentVariableName + " because specified value is invalid: " + environmentVariable);
            return defaultValue;
        }
        if (value < lowerLimit) {
            errorHandler.handleError(EnvironmentUtil.class, null, "Using value " + lowerLimit + " for " + environmentVariableName + " because specified value is invalid: " + environmentVariable);
            return lowerLimit;
        }
        if (value > upperLimit) {
            errorHandler.handleError(EnvironmentUtil.class, null, "Using value " + upperLimit + " for " + environmentVariableName + " because specified value is invalid: " + environmentVariable);
            return upperLimit;
        }
        return value;
    }
}

