/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public final class HostNameUtil {
    private HostNameUtil() {
    }

    public static String getHostName() {
        String hostName = HostNameUtil.hostNameFromCommand();
        if (hostName != null) {
            return hostName;
        }
        if (SystemUtils.IS_OS_UNIX) {
            hostName = System.getenv("HOSTNAME");
        } else if (SystemUtils.IS_OS_WINDOWS) {
            hostName = System.getenv("COMPUTERNAME");
        }
        if (hostName != null) {
            return hostName;
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
            int firstDot = hostName.indexOf(46);
            if (firstDot == -1) {
                return hostName;
            }
            if (!StringUtils.isNumeric((CharSequence)(hostName = hostName.substring(0, firstDot)))) {
                return hostName;
            }
            hostName = null;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    private static String hostNameFromCommand() {
        Process process;
        try {
            process = new ProcessBuilder("hostname").start();
        }
        catch (IOException e) {
            return null;
        }
        FutureTask<String> hostnameTask = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                int nextChar;
                StringBuilder sb = new StringBuilder();
                InputStreamReader reader = new InputStreamReader(process.getInputStream());
                while ((nextChar = reader.read()) != -1) {
                    sb.append((char)nextChar);
                }
                return sb.toString();
            }
        });
        Thread readThread = new Thread(hostnameTask);
        readThread.setDaemon(true);
        readThread.start();
        String hostName = null;
        try {
            hostName = hostnameTask.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        try {
            if (process.exitValue() == 0) {
                return hostName.trim();
            }
            return null;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            process.destroy();
            return null;
        }
    }
}

