/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.util;

import com.aquenos.epics.jackie.common.exception.ErrorHandler;
import com.aquenos.epics.jackie.common.exception.ExceptionSafeErrorHandler;
import com.aquenos.epics.jackie.common.exception.NullErrorHandler;
import com.aquenos.epics.jackie.common.util.EnvironmentUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class Inet4AddressUtil {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("[ \t\n\r\f]");
    public static final Inet4Address LOOPBACK_ADDRESS;

    private Inet4AddressUtil() {
    }

    public static int addressToInt(byte[] address) {
        if (address.length != 4) {
            throw new IllegalArgumentException("An IPv4 address must have 4 bytes, but this address has " + address.length + " bytes.");
        }
        int intAddress = address[3] & 0xFF;
        intAddress |= address[2] << 8 & 0xFF00;
        intAddress |= address[1] << 16 & 0xFF0000;
        return intAddress |= address[0] << 24 & 0xFF000000;
    }

    public static byte[] addressToBytes(int address) {
        byte[] byteAddress = new byte[]{(byte)(address >>> 24 & 0xFF), (byte)(address >>> 16 & 0xFF), (byte)(address >>> 8 & 0xFF), (byte)(address & 0xFF)};
        return byteAddress;
    }

    public static List<InetSocketAddress> stringToInet4SocketAddressList(String addressListString, int defaultPort, boolean allowZero, ErrorHandler errorHandler) {
        if (defaultPort < 0 || defaultPort > 65535 || !allowZero && defaultPort < 1) {
            throw new IllegalArgumentException("Not a valid port number: " + defaultPort);
        }
        if (errorHandler == null) {
            errorHandler = new NullErrorHandler();
        } else if (!(errorHandler instanceof ExceptionSafeErrorHandler)) {
            errorHandler = new ExceptionSafeErrorHandler(errorHandler);
        }
        LinkedList<InetSocketAddress> addressList = new LinkedList<InetSocketAddress>();
        for (String token : WHITESPACE_PATTERN.split(addressListString)) {
            int port;
            String portPart;
            String hostPart;
            if (token.isEmpty()) continue;
            if (token.startsWith("[") && token.endsWith("]")) {
                hostPart = token;
                portPart = null;
            } else {
                int indexOfColon = token.lastIndexOf(58);
                if (indexOfColon == -1) {
                    hostPart = token;
                    portPart = null;
                } else {
                    hostPart = token.substring(0, indexOfColon);
                    portPart = token.substring(indexOfColon + 1);
                }
            }
            if (portPart != null) {
                try {
                    port = Integer.parseInt(portPart);
                }
                catch (NumberFormatException e) {
                    port = -1;
                }
                if (port > 65535 || port < 0 || port == 0 && !allowZero) {
                    errorHandler.handleError(Inet4AddressUtil.class, null, "Ignoring token with invalid port number: " + token);
                    continue;
                }
            } else {
                port = defaultPort;
            }
            boolean foundValidAddress = false;
            try {
                InetAddress[] allAddresses;
                for (InetAddress address : allAddresses = InetAddress.getAllByName(hostPart)) {
                    if (!(address instanceof Inet4Address)) continue;
                    addressList.add(new InetSocketAddress(address, port));
                    foundValidAddress = true;
                }
            }
            catch (UnknownHostException e) {
                errorHandler.handleError(EnvironmentUtil.class, null, "Ignoring token with unresolvable hostname: " + token);
                continue;
            }
            if (foundValidAddress) continue;
            errorHandler.handleError(EnvironmentUtil.class, null, "Ignoring token that does not resolve to an IPv4 address: " + token);
        }
        return addressList;
    }

    public static Inet4Address stringToInetAddress(String addressString) {
        String[] addressParts = StringUtils.split((String)addressString, (char)'.');
        if (addressParts.length != 4) {
            throw new IllegalArgumentException("Not a valid IPv4 address: " + addressString);
        }
        byte[] addressBytes = new byte[4];
        for (int i = 0; i < addressBytes.length; ++i) {
            String addressPart = addressParts[i];
            if (addressPart.length() < 1 || addressPart.length() > 3 || !StringUtils.isNumeric((CharSequence)addressPart)) {
                throw new IllegalArgumentException("Not a valid IPv4 address: " + addressString);
            }
            int numericPart = Integer.parseInt(addressPart, 10);
            if (numericPart > 255) {
                throw new IllegalArgumentException("Not a valid IPv4 address: " + addressString);
            }
            addressBytes[i] = (byte)numericPart;
        }
        try {
            return (Inet4Address)InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            LOOPBACK_ADDRESS = (Inet4Address)InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unexpected exception when trying to generate loopback address.");
        }
    }
}

