/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.util;

import com.aquenos.epics.jackie.common.util.BasicIntegerIdPool;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class IntegerIdPool {
    private BasicIntegerIdPool idPool;

    public IntegerIdPool(int minimumId, int maximumId, long blockFromReuseTime, boolean earlyReuseOnExhaustion) {
        this.idPool = new BasicIntegerIdPool(minimumId, maximumId, blockFromReuseTime, earlyReuseOnExhaustion);
    }

    public Id acquireId() {
        return new Id(this.idPool);
    }

    public static final class Id {
        private static final AtomicIntegerFieldUpdater<Id> RELEASED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Id.class, "released");
        private BasicIntegerIdPool idPool;
        private volatile int released;
        private int id;

        private Id(BasicIntegerIdPool idPool) {
            this.idPool = idPool;
            this.id = this.idPool.acquireId();
            this.released = 0;
        }

        public int get() {
            if (this.isAlive()) {
                return this.id;
            }
            throw new IllegalStateException("This ID has already been released.");
        }

        public void release() {
            if (!this.isAlive()) {
                return;
            }
            if (this.atomicMarkAsReleased()) {
                this.idPool.releaseId(this.id);
            }
        }

        public boolean isAlive() {
            return RELEASED_UPDATER.get(this) == 0;
        }

        private boolean atomicMarkAsReleased() {
            return RELEASED_UPDATER.compareAndSet(this, 0, 1);
        }

        public String toString() {
            if (this.isAlive()) {
                return Integer.toString(this.id);
            }
            return "<released>";
        }

        protected void finalize() throws Throwable {
            try {
                this.release();
            }
            finally {
                super.finalize();
            }
        }
    }
}

