/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LinkedWeakIdentityHashSet<E>
extends AbstractSet<E> {
    private WeakIdentityReference<E> first = null;
    private WeakIdentityReference<E> last = null;
    private HashMap<WeakIdentityReference<E>, Object> map;
    private transient int modCount = 0;
    private ReferenceQueue<E> queue = new ReferenceQueue();

    public LinkedWeakIdentityHashSet() {
        this.map = new HashMap();
    }

    public LinkedWeakIdentityHashSet(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
    }

    public LinkedWeakIdentityHashSet(int initialCapacity, float loadFactor) {
        this.map = new HashMap(initialCapacity, loadFactor);
    }

    public LinkedWeakIdentityHashSet(Collection<? extends E> c) {
        this(Math.max((int)((float)c.size() / 0.75f) + 1, 16), 0.75f);
        this.addAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReferenceQueue() {
        Reference<E> reference;
        while ((reference = this.queue.poll()) != null) {
            ReferenceQueue<E> referenceQueue = this.queue;
            synchronized (referenceQueue) {
                this.removeInternal(reference);
            }
        }
    }

    private boolean removeInternal(Object o) {
        if (o == null) {
            return false;
        }
        StrongIdentityReference key = o instanceof WeakIdentityReference ? o : new StrongIdentityReference(o);
        WeakIdentityReference entry = (WeakIdentityReference)this.map.remove(key);
        if (entry != null) {
            ++this.modCount;
            WeakIdentityReference previous = entry.previous;
            WeakIdentityReference next = entry.next;
            if (previous != null) {
                previous.next = next;
            } else {
                this.first = next;
            }
            if (next != null) {
                next.previous = previous;
            } else {
                this.last = previous;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        boolean modified;
        this.processReferenceQueue();
        if (e == null) {
            throw new NullPointerException();
        }
        WeakIdentityReference entry = new WeakIdentityReference(e, this.queue);
        boolean bl = modified = this.map.put(entry, entry) == null;
        if (modified) {
            ++this.modCount;
            if (this.last == null) {
                this.last = entry;
                this.first = this.last;
            } else {
                ((WeakIdentityReference)this.last).next = entry;
                entry.previous = (WeakIdentityReference)this.last;
                this.last = entry;
            }
        }
        return modified;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.last = null;
        this.first = null;
        ++this.modCount;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean contains(Object o) {
        this.processReferenceQueue();
        if (o == null) {
            return false;
        }
        return this.map.containsKey(new StrongIdentityReference(o));
    }

    @Override
    public Iterator<E> iterator() {
        this.processReferenceQueue();
        return new Iterator<E>(){
            private WeakIdentityReference<E> current = null;
            private int modCountAtStart = LinkedWeakIdentityHashSet.access$400(LinkedWeakIdentityHashSet.this);
            private WeakIdentityReference<E> next = null;
            private WeakIdentityReference<E> nextNext = LinkedWeakIdentityHashSet.access$500(LinkedWeakIdentityHashSet.this);
            private E nextValue;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (this.modCountAtStart != LinkedWeakIdentityHashSet.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                while (this.nextNext != null && this.nextValue == null) {
                    Object nextValue = this.nextNext.get();
                    if (nextValue != null) {
                        this.next = this.nextNext;
                        this.nextValue = nextValue;
                    } else {
                        ReferenceQueue referenceQueue = LinkedWeakIdentityHashSet.this.queue;
                        synchronized (referenceQueue) {
                            LinkedWeakIdentityHashSet.this.removeInternal(this.nextNext);
                        }
                    }
                    this.nextNext = this.nextNext.next;
                }
                return this.nextValue != null;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object value = this.nextValue;
                this.current = this.next;
                this.nextValue = null;
                this.next = null;
                return value;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                if (this.modCountAtStart != LinkedWeakIdentityHashSet.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                LinkedWeakIdentityHashSet.this.removeInternal(this.current);
                LinkedWeakIdentityHashSet.this.modCount++;
                this.modCountAtStart = LinkedWeakIdentityHashSet.this.modCount;
                this.current = null;
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        this.processReferenceQueue();
        return this.removeInternal(o);
    }

    @Override
    public int size() {
        this.processReferenceQueue();
        return this.map.size();
    }

    static /* synthetic */ WeakIdentityReference access$500(LinkedWeakIdentityHashSet x0) {
        return x0.first;
    }

    private static class StrongIdentityReference<E> {
        private E referent;

        private StrongIdentityReference(E referent) {
            assert (referent != null);
            this.referent = referent;
        }

        public E get() {
            return this.referent;
        }

        public int hashCode() {
            return System.identityHashCode(this.referent);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof WeakIdentityReference) {
                WeakIdentityReference other = (WeakIdentityReference)obj;
                return this.referent == other.get();
            }
            if (obj instanceof StrongIdentityReference) {
                StrongIdentityReference other = (StrongIdentityReference)obj;
                return this.referent == other.referent;
            }
            return false;
        }
    }

    private static class WeakIdentityReference<E>
    extends WeakReference<E> {
        private int hashCode;
        private WeakIdentityReference<E> next = null;
        private WeakIdentityReference<E> previous = null;

        private WeakIdentityReference(E referent, ReferenceQueue<? super E> q) {
            super(referent, q);
            this.hashCode = System.identityHashCode(referent);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof WeakIdentityReference) {
                WeakIdentityReference other = (WeakIdentityReference)obj;
                Object referent = this.get();
                if (referent == null) {
                    return this == other;
                }
                return referent == other.get();
            }
            if (obj instanceof StrongIdentityReference) {
                StrongIdentityReference other = (StrongIdentityReference)obj;
                return this.get() == other.get();
            }
            return false;
        }
    }
}

