/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class NullTerminatedStringUtil {
    private NullTerminatedStringUtil() {
    }

    public static String nullTerminatedBytesToString(byte[] bytes, int offset, int length, Charset encoding, boolean strict) {
        int end = offset + length;
        int usedLength = length;
        for (int i = offset; i < end; ++i) {
            if (bytes[i] != 0) continue;
            usedLength = i - offset;
            break;
        }
        if (strict && usedLength == length) {
            throw new IllegalArgumentException("The string is not null terminated.");
        }
        return new String(bytes, offset, usedLength, encoding);
    }

    public static String nullTerminatedBytesToString(byte[] bytes, Charset encoding, boolean strict) {
        return NullTerminatedStringUtil.nullTerminatedBytesToString(bytes, 0, bytes.length, encoding, strict);
    }

    public static String nullTerminatedBytesToString(byte[] bytes, Charset encoding) {
        return NullTerminatedStringUtil.nullTerminatedBytesToString(bytes, encoding, false);
    }

    public static Pair<byte[], Integer> stringToTruncatedNullTerminatedBytes(String string, int maximumLength, int alignTo, Charset encoding) {
        int maxPosition;
        CharsetEncoder encoder;
        double maximumBytesLength;
        int bytesLength;
        if (maximumLength < 0) {
            throw new IllegalArgumentException("Maxium length must not be negative.");
        }
        if (alignTo <= 0) {
            throw new IllegalArgumentException("Alignment must be at least 1.");
        }
        if (maximumLength < alignTo) {
            throw new IllegalArgumentException("The maximum length must be greater than or equal to the requested alignment.");
        }
        if (maximumLength % alignTo != 0) {
            maximumLength -= maximumLength % alignTo;
        }
        if ((bytesLength = (maximumBytesLength = (double)((encoder = encoding.newEncoder()).maxBytesPerChar() * (float)string.length())) > (double)(maximumLength - 1) ? maximumLength : (int)Math.ceil(maximumBytesLength) + 1) < maximumLength) {
            int paddingLength = alignTo - bytesLength % alignTo;
            if (paddingLength == alignTo) {
                paddingLength = 0;
            }
            maximumLength = bytesLength + paddingLength;
        }
        if (bytesLength > maximumLength) {
            bytesLength = maximumLength;
        }
        byte[] bytes = new byte[maximumLength];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        char[] characters = string.toCharArray();
        int numberOfCharacters = characters.length;
        if (numberOfCharacters > maximumLength) {
            numberOfCharacters = maximumLength;
        }
        try {
            CoderResult cr = encoder.encode(CharBuffer.wrap(characters, 0, numberOfCharacters), buffer, true);
            if (!cr.isUnderflow() && !cr.isOverflow()) {
                cr.throwException();
            }
            if (cr.isUnderflow() && !(cr = encoder.flush(buffer)).isUnderflow() && !cr.isOverflow()) {
                cr.throwException();
            }
            maxPosition = buffer.position();
            while (cr.isOverflow() || buffer.remaining() == 0) {
                encoder.reset();
                buffer.clear();
                cr = encoder.encode(CharBuffer.wrap(characters, 0, --numberOfCharacters), buffer, true);
                if (!cr.isUnderflow() && !cr.isOverflow()) {
                    cr.throwException();
                }
                if (!cr.isUnderflow() || (cr = encoder.flush(buffer)).isUnderflow() || cr.isOverflow()) continue;
                cr.throwException();
            }
        }
        catch (CharacterCodingException e) {
            throw new Error(e);
        }
        int numberOfBytes = buffer.position() + 1;
        while (buffer.position() < maxPosition) {
            buffer.put((byte)0);
        }
        if (numberOfBytes % alignTo != 0) {
            numberOfBytes += alignTo - numberOfBytes % alignTo;
        }
        return new ImmutablePair((Object)bytes, (Object)numberOfBytes);
    }

    public static Pair<byte[], Integer> stringToTruncatedNullTerminatedBytes(String string, int maximumLength, Charset encoding) {
        return NullTerminatedStringUtil.stringToTruncatedNullTerminatedBytes(string, maximumLength, 1, encoding);
    }

    public static byte[] stringToTruncatedNullTerminatedFixedBytes(String string, int fixedLength, Charset encoding) {
        return (byte[])NullTerminatedStringUtil.stringToTruncatedNullTerminatedBytes(string, fixedLength, fixedLength, encoding).getLeft();
    }

    public static Pair<byte[], Integer> stringToSizeLimitedNullTerminatedBytesOrNull(String string, int maximumLength, int alignTo, Charset encoding) {
        if (maximumLength < 0) {
            throw new IllegalArgumentException("Maxium length must not be negative.");
        }
        if (maximumLength % alignTo != 0) {
            maximumLength -= maximumLength % alignTo;
        }
        if (alignTo <= 0) {
            throw new IllegalArgumentException("Alignment must be at least 1.");
        }
        CharsetEncoder encoder = encoding.newEncoder();
        double maximumBytesLength = encoder.maxBytesPerChar() * (float)string.length();
        int bytesLength = maximumBytesLength > (double)(maximumLength - 1) ? maximumLength : (int)Math.ceil(maximumBytesLength) + 1;
        if (bytesLength < maximumLength) {
            int paddingLength = alignTo - bytesLength % alignTo;
            if (paddingLength == alignTo) {
                paddingLength = 0;
            }
            maximumLength = bytesLength + paddingLength;
        }
        if (bytesLength > maximumLength) {
            bytesLength = maximumLength;
        }
        byte[] bytes = new byte[maximumLength];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        char[] characters = string.toCharArray();
        try {
            CoderResult cr = encoder.encode(CharBuffer.wrap(characters, 0, characters.length), buffer, true);
            if (cr.isOverflow()) {
                return null;
            }
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if ((cr = encoder.flush(buffer)).isOverflow()) {
                return null;
            }
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (buffer.remaining() == 0) {
                return null;
            }
        }
        catch (CharacterCodingException e) {
            throw new Error(e);
        }
        int numberOfBytes = buffer.position() + 1;
        if (numberOfBytes % alignTo != 0) {
            numberOfBytes += alignTo - numberOfBytes % alignTo;
        }
        return new ImmutablePair((Object)bytes, (Object)numberOfBytes);
    }

    public static Pair<byte[], Integer> stringToSizeLimitedNullTerminatedBytesOrNull(String string, int maximumLength, Charset encoding) {
        return NullTerminatedStringUtil.stringToSizeLimitedNullTerminatedBytesOrNull(string, maximumLength, 1, encoding);
    }
}

