/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.util;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class SimpleConcurrentQueue<E> {
    private static final AtomicReferenceFieldUpdater<SimpleConcurrentQueue, Node> HEAD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SimpleConcurrentQueue.class, Node.class, "head");
    private volatile Node<E> head = new Node<Object>(null, null);
    private volatile Node<E> tail = this.head;

    public void add(E e) {
        Node oldTail;
        if (e == null) {
            throw new NullPointerException("Null elements are not supported by this queue.");
        }
        Node<E> newNode = new Node<E>(null, e);
        while (!(oldTail = this.tail).compareAndSetNext(null, newNode)) {
        }
        this.tail = newNode;
    }

    public boolean removeIfMatch(E expect) {
        Node<E> head;
        if (expect == null) {
            throw new NullPointerException("Null elements are not supported by this queue.");
        }
        Node<E> node = head = this.getHead();
        do {
            E nodeValue;
            if ((nodeValue = node.getValue()) != null) {
                if (!nodeValue.equals(expect)) {
                    return false;
                }
                if (node.compareAndSetValue(nodeValue, null)) {
                    Node<E> nextHead = node.getNext();
                    if (nextHead == null) {
                        nextHead = node;
                    }
                    if (nextHead != head) {
                        this.compareAndSetHead(head, nextHead);
                    }
                    return true;
                }
                return false;
            }
            node = node.getNext();
        } while (node != null);
        return false;
    }

    public E peek() {
        Node<E> nextNode;
        Node<E> head;
        Node<E> node = head = this.getHead();
        do {
            E value;
            if ((value = node.getValue()) != null) {
                if (node != head) {
                    this.compareAndSetHead(head, node);
                }
                return value;
            }
            nextNode = node.getNext();
            if (nextNode != null || node == head) continue;
            this.compareAndSetHead(head, node);
        } while ((node = nextNode) != null);
        return null;
    }

    private boolean compareAndSetHead(Node<E> expect, Node<E> update) {
        return HEAD_UPDATER.compareAndSet(this, expect, update);
    }

    private Node<E> getHead() {
        return HEAD_UPDATER.get(this);
    }

    private static class Node<E> {
        private static final AtomicReferenceFieldUpdater<Node, Node> NEXT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
        private static final AtomicReferenceFieldUpdater<Node, Object> VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Node.class, Object.class, "value");
        private volatile Node<E> next;
        private volatile E value;

        public Node(Node<E> next, E value) {
            this.next = next;
            this.value = value;
        }

        public boolean compareAndSetNext(Node<E> expect, Node<E> update) {
            return NEXT_UPDATER.compareAndSet(this, expect, update);
        }

        public boolean compareAndSetValue(E expect, E update) {
            return VALUE_UPDATER.compareAndSet(this, expect, update);
        }

        public Node<E> getNext() {
            return NEXT_UPDATER.get(this);
        }

        public E getValue() {
            return (E)VALUE_UPDATER.get(this);
        }
    }
}

