/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.util;

import com.aquenos.epics.jackie.common.util.AbstractListenableFuture;
import com.aquenos.epics.jackie.common.util.ListenerLockPolicy;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SimpleListenableFuture<V>
extends AbstractListenableFuture<V> {
    private boolean done;
    private Throwable executionException;
    private final Object lock = new Object();
    private V result;

    public SimpleListenableFuture() {
    }

    public SimpleListenableFuture(ListenerLockPolicy listenerLockPolicy) {
        super(listenerLockPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(V result) {
        Object object = this.lock;
        synchronized (object) {
            if (this.done) {
                throw new IllegalStateException("A result cannot be set after the future completed.");
            }
            this.result = result;
            this.done = true;
            this.lock.notifyAll();
        }
        this.notifyCompletionListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecutionException(Throwable executionException) {
        Object object = this.lock;
        synchronized (object) {
            if (executionException == null) {
                throw new NullPointerException("Parameter executionException must not be null.");
            }
            if (this.done) {
                throw new IllegalStateException("An exception cannot be set after the future completed.");
            }
            this.executionException = executionException;
            this.done = true;
            this.lock.notifyAll();
        }
        this.notifyCompletionListeners();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.done;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.done) {
                this.lock.wait();
                assert (this.done);
            }
            if (this.executionException != null) {
                throw new ExecutionException(this.executionException);
            }
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.done) {
                unit.timedWait(this.lock, timeout);
                if (!this.done) {
                    throw new TimeoutException("The future did not complete in time.");
                }
            }
            if (this.executionException != null) {
                throw new ExecutionException(this.executionException);
            }
            return this.result;
        }
    }
}

