/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class UserNameUtil {
    private static final Object SYSTEM_OBJECT;
    private static final Method USER_NAME_METHOD;

    private UserNameUtil() {
    }

    public static String getUserName() {
        String userName = UserNameUtil.userNameFromSystem();
        if (userName != null) {
            return userName;
        }
        userName = System.getProperty("user.name");
        if (userName != null) {
            return userName;
        }
        userName = System.getenv("USERNAME");
        return userName;
    }

    private static String userNameFromSystem() {
        if (SYSTEM_OBJECT != null && USER_NAME_METHOD != null) {
            try {
                return (String)USER_NAME_METHOD.invoke(SYSTEM_OBJECT, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        Class<?> systemClass = null;
        Object systemObject = null;
        Method method = null;
        try {
            try {
                systemClass = Class.forName("com.sun.security.auth.module.UnixSystem");
                method = systemClass.getMethod("getUsername", new Class[0]);
                systemObject = systemClass.newInstance();
            }
            catch (ClassNotFoundException | LinkageError throwable) {
                // empty catch block
            }
            if (systemObject == null) {
                try {
                    systemClass = Class.forName("com.sun.security.auth.module.NTSystem");
                    method = systemClass.getMethod("getName", new Class[0]);
                    systemObject = systemClass.newInstance();
                }
                catch (ClassNotFoundException | LinkageError throwable) {
                    // empty catch block
                }
            }
            if (systemObject == null) {
                try {
                    systemClass = Class.forName("com.sun.security.auth.module.SolarisSystem");
                    method = systemClass.getMethod("getUsername", new Class[0]);
                    systemObject = systemClass.newInstance();
                }
                catch (ClassNotFoundException | LinkageError throwable) {}
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (systemObject != null && method != null && String.class.isAssignableFrom(method.getReturnType())) {
            SYSTEM_OBJECT = systemObject;
            USER_NAME_METHOD = method;
        } else {
            SYSTEM_OBJECT = null;
            USER_NAME_METHOD = null;
        }
    }
}

