/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value;

import java.util.concurrent.ConcurrentHashMap;

public final class ChannelAccessAlarmStatus {
    public static final ChannelAccessAlarmStatus NO_ALARM = new ChannelAccessAlarmStatus("NO_ALARM", 0);
    public static final ChannelAccessAlarmStatus READ = new ChannelAccessAlarmStatus("READ", 1);
    public static final ChannelAccessAlarmStatus WRITE = new ChannelAccessAlarmStatus("WRITE", 2);
    public static final ChannelAccessAlarmStatus HIHI = new ChannelAccessAlarmStatus("HIHI", 3);
    public static final ChannelAccessAlarmStatus HIGH = new ChannelAccessAlarmStatus("HIGH", 4);
    public static final ChannelAccessAlarmStatus LOLO = new ChannelAccessAlarmStatus("LOLO", 5);
    public static final ChannelAccessAlarmStatus LOW = new ChannelAccessAlarmStatus("LOW", 6);
    public static final ChannelAccessAlarmStatus STATE = new ChannelAccessAlarmStatus("STATE", 7);
    public static final ChannelAccessAlarmStatus COS = new ChannelAccessAlarmStatus("COS", 8);
    public static final ChannelAccessAlarmStatus COMM = new ChannelAccessAlarmStatus("COMM", 9);
    public static final ChannelAccessAlarmStatus TIMEOUT = new ChannelAccessAlarmStatus("TIMEOUT", 10);
    public static final ChannelAccessAlarmStatus HWLIMIT = new ChannelAccessAlarmStatus("HWLIMIT", 11);
    public static final ChannelAccessAlarmStatus CALC = new ChannelAccessAlarmStatus("CALC", 12);
    public static final ChannelAccessAlarmStatus SCAN = new ChannelAccessAlarmStatus("SCAN", 13);
    public static final ChannelAccessAlarmStatus LINK = new ChannelAccessAlarmStatus("LINK", 14);
    public static final ChannelAccessAlarmStatus SOFT = new ChannelAccessAlarmStatus("SOFT", 15);
    public static final ChannelAccessAlarmStatus BAD_SUB = new ChannelAccessAlarmStatus("BAD_SUB", 16);
    public static final ChannelAccessAlarmStatus UDF = new ChannelAccessAlarmStatus("UDF", 17);
    public static final ChannelAccessAlarmStatus DISABLE = new ChannelAccessAlarmStatus("DISABLE", 18);
    public static final ChannelAccessAlarmStatus SIMM = new ChannelAccessAlarmStatus("SIMM", 19);
    public static final ChannelAccessAlarmStatus READ_ACCESS = new ChannelAccessAlarmStatus("READ_ACCESS", 20);
    public static final ChannelAccessAlarmStatus WRITE_ACCESS = new ChannelAccessAlarmStatus("WRITE_ACCESS", 21);
    private static ConcurrentHashMap<Short, ChannelAccessAlarmStatus> generatedAlarmStatusMap = new ConcurrentHashMap();
    private static final ChannelAccessAlarmStatus[] statusCodeToStatus = new ChannelAccessAlarmStatus[]{NO_ALARM, READ, WRITE, HIHI, HIGH, LOLO, LOW, STATE, COS, COMM, TIMEOUT, HWLIMIT, CALC, SCAN, LINK, SOFT, BAD_SUB, UDF, DISABLE, SIMM, READ_ACCESS, WRITE_ACCESS};
    private String name;
    private short statusCode;

    private ChannelAccessAlarmStatus(String name, short statusCode) {
        this.name = name;
        this.statusCode = statusCode;
    }

    public short toAlarmStatusCode() {
        return this.statusCode;
    }

    public String toString() {
        return this.name;
    }

    public static ChannelAccessAlarmStatus forAlarmStatusCode(short statusCode) {
        if (statusCode >= 0 && statusCode < statusCodeToStatus.length) {
            return statusCodeToStatus[statusCode];
        }
        ChannelAccessAlarmStatus status = generatedAlarmStatusMap.get((short)statusCode);
        if (status == null) {
            int intStatusCode = statusCode;
            if (intStatusCode < 0) {
                intStatusCode += 65536;
            }
            status = new ChannelAccessAlarmStatus("ALARM_" + intStatusCode, (short)statusCode);
            ChannelAccessAlarmStatus existingStatus = generatedAlarmStatusMap.putIfAbsent((short)statusCode, status);
            if (existingStatus != null) {
                return existingStatus;
            }
        }
        return status;
    }

    public int hashCode() {
        return 41 + 19 * this.statusCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChannelAccessAlarmStatus)) {
            return false;
        }
        return ((ChannelAccessAlarmStatus)obj).statusCode == this.statusCode;
    }
}

