/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.value.ChannelAccessGettableValue;
import com.aquenos.epics.jackie.common.value.ChannelAccessPuttableValue;
import com.aquenos.epics.jackie.common.value.ChannelAccessValue;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessAcknowledgeAlarmImpl;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessAlarmAcknowledgementStatusImpl;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessCharBase;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessClassNameImpl;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessConfigureAcknowledgeTransientAlarmsImpl;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessDoubleBase;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessEnumBase;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessFloatBase;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessLongBase;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessShortBase;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessStringBase;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessValueBase;
import java.nio.charset.Charset;

public final class ChannelAccessValueCodec {
    private static final int[] BASE_SIZE = new int[]{0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 5, 4, 8, 12, 14, 12, 14, 15, 12, 16, 4, 24, 40, 422, 19, 36, 64, 4, 28, 48, 422, 21, 44, 80, 0, 0, 8, 0};
    private static final int[] ELEMENT_SIZE = new int[]{40, 2, 4, 2, 1, 4, 8, 40, 2, 4, 2, 1, 4, 8, 40, 2, 4, 2, 1, 4, 8, 40, 2, 4, 2, 1, 4, 8, 40, 2, 4, 2, 1, 4, 8, 2, 2, 40, 40};
    private static final int[] MAX_COUNT;

    private ChannelAccessValueCodec() {
    }

    public static ChannelAccessGettableValue<?> decodeGettableValue(ByteSource byteSource, ChannelAccessValueType type, int dataSize, int count, Charset charset) {
        if (type == ChannelAccessValueType.DBR_PUT_ACKT || type == ChannelAccessValueType.DBR_PUT_ACKS) {
            throw new IllegalArgumentException("Type " + (Object)((Object)type) + " is not gettable.");
        }
        return (ChannelAccessGettableValue)ChannelAccessValueCodec.decodeValue(byteSource, type, dataSize, count, charset);
    }

    public static ChannelAccessPuttableValue<?> decodePuttableValue(ByteSource byteSource, ChannelAccessValueType type, int dataSize, int count, Charset charset) {
        if (type.isSimpleType() || type == ChannelAccessValueType.DBR_PUT_ACKT || type == ChannelAccessValueType.DBR_PUT_ACKS) {
            return (ChannelAccessPuttableValue)ChannelAccessValueCodec.decodeValue(byteSource, type, dataSize, count, charset);
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)type) + " is not puttable.");
    }

    public static ChannelAccessValue<?> decodeValue(final ByteSource byteSource, final ChannelAccessValueType type, final int dataSize, final int count, final Charset charset) {
        if (count < 0) {
            throw new IllegalArgumentException("Number of expected elements must not be negative.");
        }
        int valueSize = ChannelAccessValueCodec.calculatePayloadSize(type, count);
        if (dataSize < valueSize) {
            if (count == 1 && type.toSimpleType().equals((Object)ChannelAccessValueType.DBR_STRING) && dataSize >= ChannelAccessValueCodec.calculatePayloadSize(type, 0)) {
                valueSize = dataSize;
            } else {
                throw new IllegalArgumentException("A value of type " + (Object)((Object)type) + " needs more than " + dataSize + " bytes.");
            }
        }
        final int valueSizeFinal = valueSize;
        return (ChannelAccessValue)byteSource.atomicGet(new ByteSource.AtomicGetOperation<ChannelAccessValue<?>>(){

            @Override
            public ChannelAccessValue<?> get() {
                ChannelAccessValue value = ChannelAccessValueCodec.decodeInternal(byteSource, valueSizeFinal, type, count, charset);
                byteSource.skip(dataSize - valueSizeFinal);
                return value;
            }
        });
    }

    private static ChannelAccessValue<?> decodeInternal(ByteSource byteSource, int numberOfBytes, ChannelAccessValueType type, int count, Charset charset) {
        switch (type) {
            case DBR_STRING: {
                return ChannelAccessStringBase.ChannelAccessStringImpl.deserialize(byteSource, numberOfBytes, count, charset);
            }
            case DBR_SHORT: {
                return ChannelAccessShortBase.ChannelAccessShortImpl.deserialize(byteSource, count);
            }
            case DBR_FLOAT: {
                return ChannelAccessFloatBase.ChannelAccessFloatImpl.deserialize(byteSource, count);
            }
            case DBR_ENUM: {
                return ChannelAccessEnumBase.ChannelAccessEnumImpl.deserialize(byteSource, count);
            }
            case DBR_CHAR: {
                return ChannelAccessCharBase.ChannelAccessCharImpl.deserialize(byteSource, count);
            }
            case DBR_LONG: {
                return ChannelAccessLongBase.ChannelAccessLongImpl.deserialize(byteSource, count);
            }
            case DBR_DOUBLE: {
                return ChannelAccessDoubleBase.ChannelAccessDoubleImpl.deserialize(byteSource, count);
            }
            case DBR_STS_STRING: {
                return ChannelAccessStringBase.ChannelAccessAlarmStringImpl.deserialize(type, byteSource, numberOfBytes, count, charset);
            }
            case DBR_STS_SHORT: {
                return ChannelAccessShortBase.ChannelAccessAlarmShortImpl.deserialize(byteSource, count);
            }
            case DBR_STS_FLOAT: {
                return ChannelAccessFloatBase.ChannelAccessAlarmFloatImpl.deserialize(byteSource, count);
            }
            case DBR_STS_ENUM: {
                return ChannelAccessEnumBase.ChannelAccessAlarmEnumImpl.deserialize(byteSource, count);
            }
            case DBR_STS_CHAR: {
                return ChannelAccessCharBase.ChannelAccessAlarmCharImpl.deserialize(byteSource, count);
            }
            case DBR_STS_LONG: {
                return ChannelAccessLongBase.ChannelAccessAlarmLongImpl.deserialize(byteSource, count);
            }
            case DBR_STS_DOUBLE: {
                return ChannelAccessDoubleBase.ChannelAccessAlarmDoubleImpl.deserialize(byteSource, count);
            }
            case DBR_TIME_STRING: {
                return ChannelAccessStringBase.ChannelAccessTimeStringImpl.deserialize(byteSource, numberOfBytes, count, charset);
            }
            case DBR_TIME_SHORT: {
                return ChannelAccessShortBase.ChannelAccessTimeShortImpl.deserialize(byteSource, count);
            }
            case DBR_TIME_FLOAT: {
                return ChannelAccessFloatBase.ChannelAccessTimeFloatImpl.deserialize(byteSource, count);
            }
            case DBR_TIME_ENUM: {
                return ChannelAccessEnumBase.ChannelAccessTimeEnumImpl.deserialize(byteSource, count);
            }
            case DBR_TIME_CHAR: {
                return ChannelAccessCharBase.ChannelAccessTimeCharImpl.deserialize(byteSource, count);
            }
            case DBR_TIME_LONG: {
                return ChannelAccessLongBase.ChannelAccessTimeLongImpl.deserialize(byteSource, count);
            }
            case DBR_TIME_DOUBLE: {
                return ChannelAccessDoubleBase.ChannelAccessTimeDoubleImpl.deserialize(byteSource, count);
            }
            case DBR_GR_STRING: {
                return ChannelAccessStringBase.ChannelAccessAlarmStringImpl.deserialize(type, byteSource, numberOfBytes, count, charset);
            }
            case DBR_GR_SHORT: {
                return ChannelAccessShortBase.ChannelAccessGraphicsShortImpl.deserialize(byteSource, count, charset);
            }
            case DBR_GR_FLOAT: {
                return ChannelAccessFloatBase.ChannelAccessGraphicsFloatImpl.deserialize(byteSource, count, charset);
            }
            case DBR_GR_ENUM: {
                return ChannelAccessEnumBase.ChannelAccessGraphicsEnumImpl.deserialize(type, byteSource, count, charset);
            }
            case DBR_GR_CHAR: {
                return ChannelAccessCharBase.ChannelAccessGraphicsCharImpl.deserialize(byteSource, count, charset);
            }
            case DBR_GR_LONG: {
                return ChannelAccessLongBase.ChannelAccessGraphicsLongImpl.deserialize(byteSource, count, charset);
            }
            case DBR_GR_DOUBLE: {
                return ChannelAccessDoubleBase.ChannelAccessGraphicsDoubleImpl.deserialize(byteSource, count, charset);
            }
            case DBR_CTRL_STRING: {
                return ChannelAccessStringBase.ChannelAccessAlarmStringImpl.deserialize(type, byteSource, numberOfBytes, count, charset);
            }
            case DBR_CTRL_SHORT: {
                return ChannelAccessShortBase.ChannelAccessControlsShortImpl.deserialize(byteSource, count, charset);
            }
            case DBR_CTRL_FLOAT: {
                return ChannelAccessFloatBase.ChannelAccessControlsFloatImpl.deserialize(byteSource, count, charset);
            }
            case DBR_CTRL_ENUM: {
                return ChannelAccessEnumBase.ChannelAccessGraphicsEnumImpl.deserialize(type, byteSource, count, charset);
            }
            case DBR_CTRL_CHAR: {
                return ChannelAccessCharBase.ChannelAccessControlsCharImpl.deserialize(byteSource, count, charset);
            }
            case DBR_CTRL_LONG: {
                return ChannelAccessLongBase.ChannelAccessControlsLongImpl.deserialize(byteSource, count, charset);
            }
            case DBR_CTRL_DOUBLE: {
                return ChannelAccessDoubleBase.ChannelAccessControlsDoubleImpl.deserialize(byteSource, count, charset);
            }
            case DBR_PUT_ACKT: {
                return ChannelAccessConfigureAcknowledgeTransientAlarmsImpl.deserialize(byteSource, count);
            }
            case DBR_PUT_ACKS: {
                return ChannelAccessAcknowledgeAlarmImpl.deserialize(byteSource, count);
            }
            case DBR_STSACK_STRING: {
                return ChannelAccessAlarmAcknowledgementStatusImpl.deserialize(byteSource, numberOfBytes, count, charset);
            }
            case DBR_CLASS_NAME: {
                return ChannelAccessClassNameImpl.deserialize(byteSource, numberOfBytes, count, charset);
            }
        }
        throw new RuntimeException("Unhandled type " + (Object)((Object)type));
    }

    public static void encodeGettableValue(ByteSink byteSink, ChannelAccessGettableValue<?> value, int count) {
        ChannelAccessValueCodec.encodeValue(byteSink, value, count);
    }

    public static void encodePuttableValue(ByteSink byteSink, ChannelAccessPuttableValue<?> value, int count) {
        ChannelAccessValueCodec.encodeValue(byteSink, value, count);
    }

    public static void encodeValue(final ByteSink byteSink, ChannelAccessValue<?> value, final int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Number of elements must not be negative.");
        }
        if (count > value.getValueSize()) {
            throw new IllegalArgumentException("Number of elements to be serialized (" + count + ") must not be greater than number of elements in the value (" + value.getValueSize() + ").");
        }
        final ChannelAccessValueBase valueImpl = (ChannelAccessValueBase)value;
        byteSink.atomicPut(new ByteSink.AtomicPutOperation<Void>(){

            @Override
            public Void put() {
                valueImpl.serialize(byteSink, count);
                return null;
            }
        });
    }

    public static int calculatePayloadSize(ChannelAccessValueType type, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Element count must not be negative.");
        }
        short typeNumber = type.toTypeCode();
        int baseSize = BASE_SIZE[typeNumber];
        int elementSize = ELEMENT_SIZE[typeNumber];
        if (count > MAX_COUNT[typeNumber]) {
            throw new IllegalArgumentException("Cannot calculate the size of a " + (Object)((Object)type) + " with " + count + " elements, because the size would exceed the maximum integer value.");
        }
        return baseSize + elementSize * count;
    }

    public static int calculateMaxCount(ChannelAccessValueType type, int maxDataSize) {
        short typeNumber = type.toTypeCode();
        int baseSize = BASE_SIZE[typeNumber];
        int elementSize = ELEMENT_SIZE[typeNumber];
        if (maxDataSize < baseSize) {
            return 0;
        }
        int maxCount = (maxDataSize - baseSize) / elementSize;
        return maxCount;
    }

    static {
        ChannelAccessValueType[] allTypes = ChannelAccessValueType.values();
        MAX_COUNT = new int[allTypes.length];
        for (ChannelAccessValueType type : ChannelAccessValueType.values()) {
            short typeNumber = type.toTypeCode();
            int baseSize = BASE_SIZE[typeNumber];
            int elementSize = ELEMENT_SIZE[typeNumber];
            ChannelAccessValueCodec.MAX_COUNT[typeNumber] = (Integer.MAX_VALUE - baseSize) / elementSize;
        }
    }
}

