/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value;

import com.aquenos.epics.jackie.common.value.ChannelAccessAcknowledgeAlarm;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmAcknowledgementStatus;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmOnlyChar;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmOnlyDouble;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmOnlyEnum;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmOnlyFloat;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmOnlyLong;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmOnlyShort;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmOnlyString;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmSeverity;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmStatus;
import com.aquenos.epics.jackie.common.value.ChannelAccessClassName;
import com.aquenos.epics.jackie.common.value.ChannelAccessConfigureAcknowledgeTransientAlarms;
import com.aquenos.epics.jackie.common.value.ChannelAccessControlsChar;
import com.aquenos.epics.jackie.common.value.ChannelAccessControlsDouble;
import com.aquenos.epics.jackie.common.value.ChannelAccessControlsFloat;
import com.aquenos.epics.jackie.common.value.ChannelAccessControlsLong;
import com.aquenos.epics.jackie.common.value.ChannelAccessControlsShort;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsEnum;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsOnlyChar;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsOnlyDouble;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsOnlyFloat;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsOnlyLong;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsOnlyShort;
import com.aquenos.epics.jackie.common.value.ChannelAccessSimpleOnlyChar;
import com.aquenos.epics.jackie.common.value.ChannelAccessSimpleOnlyDouble;
import com.aquenos.epics.jackie.common.value.ChannelAccessSimpleOnlyEnum;
import com.aquenos.epics.jackie.common.value.ChannelAccessSimpleOnlyFloat;
import com.aquenos.epics.jackie.common.value.ChannelAccessSimpleOnlyLong;
import com.aquenos.epics.jackie.common.value.ChannelAccessSimpleOnlyShort;
import com.aquenos.epics.jackie.common.value.ChannelAccessSimpleOnlyString;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeChar;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeDouble;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeEnum;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeFloat;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeLong;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeShort;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeStamp;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeString;
import com.aquenos.epics.jackie.common.value.ChannelAccessValue;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessAcknowledgeAlarmImpl;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessAlarmAcknowledgementStatusImpl;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessCharBase;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessClassNameImpl;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessConfigureAcknowledgeTransientAlarmsImpl;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessDoubleBase;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessEnumBase;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessFloatBase;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessLongBase;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessShortBase;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessStringBase;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessTimeStampImpl;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.ArrayUtils;

public final class ChannelAccessValueFactory {
    private ChannelAccessValueFactory() {
    }

    public static ChannelAccessTimeStamp createTimeStamp(int seconds, int nanoseconds) {
        return new ChannelAccessTimeStampImpl(seconds, nanoseconds);
    }

    public static ChannelAccessValue<?> createValue(ChannelAccessValueType valueType, Charset charset) {
        switch (valueType) {
            case DBR_STRING: {
                return ChannelAccessValueFactory.createString(Collections.emptyList(), charset);
            }
            case DBR_SHORT: {
                return ChannelAccessValueFactory.createShort(ArrayUtils.EMPTY_SHORT_ARRAY);
            }
            case DBR_FLOAT: {
                return ChannelAccessValueFactory.createFloat(ArrayUtils.EMPTY_FLOAT_ARRAY);
            }
            case DBR_ENUM: {
                return ChannelAccessValueFactory.createEnum(ArrayUtils.EMPTY_SHORT_ARRAY);
            }
            case DBR_CHAR: {
                return ChannelAccessValueFactory.createChar(ArrayUtils.EMPTY_BYTE_ARRAY);
            }
            case DBR_LONG: {
                return ChannelAccessValueFactory.createLong(ArrayUtils.EMPTY_INT_ARRAY);
            }
            case DBR_DOUBLE: {
                return ChannelAccessValueFactory.createDouble(ArrayUtils.EMPTY_DOUBLE_ARRAY);
            }
            case DBR_STS_STRING: {
                return ChannelAccessValueFactory.createAlarmString(Collections.emptyList(), charset, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM);
            }
            case DBR_STS_SHORT: {
                return ChannelAccessValueFactory.createAlarmShort(ArrayUtils.EMPTY_SHORT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM);
            }
            case DBR_STS_FLOAT: {
                return ChannelAccessValueFactory.createAlarmFloat(ArrayUtils.EMPTY_FLOAT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM);
            }
            case DBR_STS_ENUM: {
                return ChannelAccessValueFactory.createAlarmEnum(ArrayUtils.EMPTY_SHORT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM);
            }
            case DBR_STS_CHAR: {
                return ChannelAccessValueFactory.createAlarmChar(ArrayUtils.EMPTY_BYTE_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM);
            }
            case DBR_STS_LONG: {
                return ChannelAccessValueFactory.createAlarmLong(ArrayUtils.EMPTY_INT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM);
            }
            case DBR_STS_DOUBLE: {
                return ChannelAccessValueFactory.createAlarmDouble(ArrayUtils.EMPTY_DOUBLE_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM);
            }
            case DBR_TIME_STRING: {
                return ChannelAccessValueFactory.createTimeString(Collections.emptyList(), charset, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, 0, 0);
            }
            case DBR_TIME_SHORT: {
                return ChannelAccessValueFactory.createTimeShort(ArrayUtils.EMPTY_SHORT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, 0, 0);
            }
            case DBR_TIME_FLOAT: {
                return ChannelAccessValueFactory.createTimeFloat(ArrayUtils.EMPTY_FLOAT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, 0, 0);
            }
            case DBR_TIME_ENUM: {
                return ChannelAccessValueFactory.createTimeEnum(ArrayUtils.EMPTY_SHORT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, 0, 0);
            }
            case DBR_TIME_CHAR: {
                return ChannelAccessValueFactory.createTimeChar(ArrayUtils.EMPTY_BYTE_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, 0, 0);
            }
            case DBR_TIME_LONG: {
                return ChannelAccessValueFactory.createTimeLong(ArrayUtils.EMPTY_INT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, 0, 0);
            }
            case DBR_TIME_DOUBLE: {
                return ChannelAccessValueFactory.createTimeDouble(ArrayUtils.EMPTY_DOUBLE_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, 0, 0);
            }
            case DBR_GR_STRING: {
                return ChannelAccessValueFactory.createGraphicsString(Collections.emptyList(), charset, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM);
            }
            case DBR_GR_SHORT: {
                return ChannelAccessValueFactory.createGraphicsShort(ArrayUtils.EMPTY_SHORT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, "", charset);
            }
            case DBR_GR_FLOAT: {
                return ChannelAccessValueFactory.createGraphicsFloat(ArrayUtils.EMPTY_FLOAT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, "", charset, (short)0);
            }
            case DBR_GR_ENUM: {
                return ChannelAccessValueFactory.createGraphicsEnum(ArrayUtils.EMPTY_SHORT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, Collections.emptyList(), charset);
            }
            case DBR_GR_CHAR: {
                return ChannelAccessValueFactory.createGraphicsChar(ArrayUtils.EMPTY_BYTE_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, "", charset);
            }
            case DBR_GR_LONG: {
                return ChannelAccessValueFactory.createGraphicsLong(ArrayUtils.EMPTY_INT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, 0, 0, 0, 0, 0, 0, "", charset);
            }
            case DBR_GR_DOUBLE: {
                return ChannelAccessValueFactory.createGraphicsDouble(ArrayUtils.EMPTY_DOUBLE_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "", charset, (short)0);
            }
            case DBR_CTRL_STRING: {
                return ChannelAccessValueFactory.createControlsString(Collections.emptyList(), charset, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM);
            }
            case DBR_CTRL_SHORT: {
                return ChannelAccessValueFactory.createControlsShort(ArrayUtils.EMPTY_SHORT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, "", charset, (short)0, (short)0);
            }
            case DBR_CTRL_FLOAT: {
                return ChannelAccessValueFactory.createControlsFloat(ArrayUtils.EMPTY_FLOAT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, "", charset, (short)0, 0.0f, 0.0f);
            }
            case DBR_CTRL_ENUM: {
                return ChannelAccessValueFactory.createControlsEnum(ArrayUtils.EMPTY_SHORT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, Collections.emptyList(), charset);
            }
            case DBR_CTRL_CHAR: {
                return ChannelAccessValueFactory.createControlsChar(ArrayUtils.EMPTY_BYTE_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, "", charset, (byte)0, (byte)0);
            }
            case DBR_CTRL_LONG: {
                return ChannelAccessValueFactory.createControlsLong(ArrayUtils.EMPTY_INT_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, 0, 0, 0, 0, 0, 0, "", charset, 0, 0);
            }
            case DBR_CTRL_DOUBLE: {
                return ChannelAccessValueFactory.createControlsDouble(ArrayUtils.EMPTY_DOUBLE_ARRAY, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "", charset, (short)0, 0.0, 0.0);
            }
            case DBR_PUT_ACKT: {
                return ChannelAccessValueFactory.createConfigureAcknowledgeTransientAlarms(false);
            }
            case DBR_PUT_ACKS: {
                return ChannelAccessValueFactory.createAcknowledgeAlarm(ChannelAccessAlarmSeverity.NO_ALARM);
            }
            case DBR_STSACK_STRING: {
                return ChannelAccessValueFactory.createAlarmAcknowledgementStatus(Collections.emptyList(), charset, ChannelAccessAlarmSeverity.NO_ALARM, ChannelAccessAlarmStatus.NO_ALARM, false, ChannelAccessAlarmSeverity.NO_ALARM);
            }
            case DBR_CLASS_NAME: {
                return ChannelAccessValueFactory.createClassName(Collections.emptyList(), charset);
            }
        }
        throw new RuntimeException("Unhandled type " + (Object)((Object)valueType));
    }

    public static ChannelAccessSimpleOnlyString createString(Collection<String> value, Charset charset) {
        return new ChannelAccessStringBase.ChannelAccessStringImpl(value, charset);
    }

    public static ChannelAccessAlarmOnlyString createAlarmString(Collection<String> value, Charset charset, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus) {
        return new ChannelAccessStringBase.ChannelAccessAlarmStringImpl(ChannelAccessValueType.DBR_STS_STRING, value, alarmStatus, alarmSeverity, charset);
    }

    public static ChannelAccessTimeString createTimeString(Collection<String> value, Charset charset, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, int timeStampSeconds, int timeStampNanoSeconds) {
        return new ChannelAccessStringBase.ChannelAccessTimeStringImpl(value, alarmStatus, alarmSeverity, timeStampSeconds, timeStampNanoSeconds, charset);
    }

    public static ChannelAccessAlarmOnlyString createGraphicsString(Collection<String> value, Charset charset, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus) {
        return new ChannelAccessStringBase.ChannelAccessAlarmStringImpl(ChannelAccessValueType.DBR_GR_STRING, value, alarmStatus, alarmSeverity, charset);
    }

    public static ChannelAccessAlarmOnlyString createControlsString(Collection<String> value, Charset charset, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus) {
        return new ChannelAccessStringBase.ChannelAccessAlarmStringImpl(ChannelAccessValueType.DBR_CTRL_STRING, value, alarmStatus, alarmSeverity, charset);
    }

    public static ChannelAccessSimpleOnlyShort createShort(short[] value) {
        return new ChannelAccessShortBase.ChannelAccessShortImpl(value);
    }

    public static ChannelAccessAlarmOnlyShort createAlarmShort(short[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus) {
        return new ChannelAccessShortBase.ChannelAccessAlarmShortImpl(value, alarmStatus, alarmSeverity);
    }

    public static ChannelAccessTimeShort createTimeShort(short[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, int timeStampSeconds, int timeStampNanoSeconds) {
        return new ChannelAccessShortBase.ChannelAccessTimeShortImpl(value, alarmStatus, alarmSeverity, timeStampSeconds, timeStampNanoSeconds);
    }

    public static ChannelAccessGraphicsOnlyShort createGraphicsShort(short[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, short lowerAlarmLimit, short upperAlarmLimit, short lowerWarningLimit, short upperWarningLimit, short lowerDisplayLimit, short upperDisplayLimit, String engineeringUnits, Charset charset) {
        return new ChannelAccessShortBase.ChannelAccessGraphicsShortImpl(value, alarmStatus, alarmSeverity, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, charset);
    }

    public static ChannelAccessControlsShort createControlsShort(short[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, short lowerAlarmLimit, short upperAlarmLimit, short lowerWarningLimit, short upperWarningLimit, short lowerDisplayLimit, short upperDisplayLimit, String engineeringUnits, Charset charset, short lowerControlLimit, short upperControlLimit) {
        return new ChannelAccessShortBase.ChannelAccessControlsShortImpl(value, alarmStatus, alarmSeverity, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, upperControlLimit, lowerControlLimit, charset);
    }

    public static ChannelAccessSimpleOnlyFloat createFloat(float[] value) {
        return new ChannelAccessFloatBase.ChannelAccessFloatImpl(value);
    }

    public static ChannelAccessAlarmOnlyFloat createAlarmFloat(float[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus) {
        return new ChannelAccessFloatBase.ChannelAccessAlarmFloatImpl(value, alarmStatus, alarmSeverity);
    }

    public static ChannelAccessTimeFloat createTimeFloat(float[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, int timeStampSeconds, int timeStampNanoSeconds) {
        return new ChannelAccessFloatBase.ChannelAccessTimeFloatImpl(value, alarmStatus, alarmSeverity, timeStampSeconds, timeStampNanoSeconds);
    }

    public static ChannelAccessGraphicsOnlyFloat createGraphicsFloat(float[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, float lowerAlarmLimit, float upperAlarmLimit, float lowerWarningLimit, float upperWarningLimit, float lowerDisplayLimit, float upperDisplayLimit, String engineeringUnits, Charset charset, short precision) {
        return new ChannelAccessFloatBase.ChannelAccessGraphicsFloatImpl(value, alarmStatus, alarmSeverity, precision, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, charset);
    }

    public static ChannelAccessControlsFloat createControlsFloat(float[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, float lowerAlarmLimit, float upperAlarmLimit, float lowerWarningLimit, float upperWarningLimit, float lowerDisplayLimit, float upperDisplayLimit, String engineeringUnits, Charset charset, short precision, float lowerControlLimit, float upperControlLimit) {
        return new ChannelAccessFloatBase.ChannelAccessControlsFloatImpl(value, alarmStatus, alarmSeverity, precision, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, upperControlLimit, lowerControlLimit, charset);
    }

    public static ChannelAccessSimpleOnlyEnum createEnum(short[] value) {
        return new ChannelAccessEnumBase.ChannelAccessEnumImpl(value);
    }

    public static ChannelAccessAlarmOnlyEnum createAlarmEnum(short[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus) {
        return new ChannelAccessEnumBase.ChannelAccessAlarmEnumImpl(value, alarmStatus, alarmSeverity);
    }

    public static ChannelAccessTimeEnum createTimeEnum(short[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, int timeStampSeconds, int timeStampNanoSeconds) {
        return new ChannelAccessEnumBase.ChannelAccessTimeEnumImpl(value, alarmStatus, alarmSeverity, timeStampSeconds, timeStampNanoSeconds);
    }

    public static ChannelAccessGraphicsEnum createGraphicsEnum(short[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, Collection<String> labels, Charset charset) {
        return new ChannelAccessEnumBase.ChannelAccessGraphicsEnumImpl(ChannelAccessValueType.DBR_GR_ENUM, value, alarmStatus, alarmSeverity, labels, charset);
    }

    public static ChannelAccessGraphicsEnum createControlsEnum(short[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, Collection<String> labels, Charset charset) {
        return new ChannelAccessEnumBase.ChannelAccessGraphicsEnumImpl(ChannelAccessValueType.DBR_CTRL_ENUM, value, alarmStatus, alarmSeverity, labels, charset);
    }

    public static ChannelAccessSimpleOnlyChar createChar(byte[] value) {
        return new ChannelAccessCharBase.ChannelAccessCharImpl(value);
    }

    public static ChannelAccessAlarmOnlyChar createAlarmChar(byte[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus) {
        return new ChannelAccessCharBase.ChannelAccessAlarmCharImpl(value, alarmStatus, alarmSeverity);
    }

    public static ChannelAccessTimeChar createTimeChar(byte[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, int timeStampSeconds, int timeStampNanoSeconds) {
        return new ChannelAccessCharBase.ChannelAccessTimeCharImpl(value, alarmStatus, alarmSeverity, timeStampSeconds, timeStampNanoSeconds);
    }

    public static ChannelAccessGraphicsOnlyChar createGraphicsChar(byte[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, byte lowerAlarmLimit, byte upperAlarmLimit, byte lowerWarningLimit, byte upperWarningLimit, byte lowerDisplayLimit, byte upperDisplayLimit, String engineeringUnits, Charset charset) {
        return new ChannelAccessCharBase.ChannelAccessGraphicsCharImpl(value, alarmStatus, alarmSeverity, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, charset);
    }

    public static ChannelAccessControlsChar createControlsChar(byte[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, byte lowerAlarmLimit, byte upperAlarmLimit, byte lowerWarningLimit, byte upperWarningLimit, byte lowerDisplayLimit, byte upperDisplayLimit, String engineeringUnits, Charset charset, byte lowerControlLimit, byte upperControlLimit) {
        return new ChannelAccessCharBase.ChannelAccessControlsCharImpl(value, alarmStatus, alarmSeverity, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, upperControlLimit, lowerControlLimit, charset);
    }

    public static ChannelAccessSimpleOnlyLong createLong(int[] value) {
        return new ChannelAccessLongBase.ChannelAccessLongImpl(value);
    }

    public static ChannelAccessAlarmOnlyLong createAlarmLong(int[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus) {
        return new ChannelAccessLongBase.ChannelAccessAlarmLongImpl(value, alarmStatus, alarmSeverity);
    }

    public static ChannelAccessTimeLong createTimeLong(int[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, int timeStampSeconds, int timeStampNanoSeconds) {
        return new ChannelAccessLongBase.ChannelAccessTimeLongImpl(value, alarmStatus, alarmSeverity, timeStampSeconds, timeStampNanoSeconds);
    }

    public static ChannelAccessGraphicsOnlyLong createGraphicsLong(int[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, int lowerAlarmLimit, int upperAlarmLimit, int lowerWarningLimit, int upperWarningLimit, int lowerDisplayLimit, int upperDisplayLimit, String engineeringUnits, Charset charset) {
        return new ChannelAccessLongBase.ChannelAccessGraphicsLongImpl(value, alarmStatus, alarmSeverity, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, charset);
    }

    public static ChannelAccessControlsLong createControlsLong(int[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, int lowerAlarmLimit, int upperAlarmLimit, int lowerWarningLimit, int upperWarningLimit, int lowerDisplayLimit, int upperDisplayLimit, String engineeringUnits, Charset charset, int lowerControlLimit, int upperControlLimit) {
        return new ChannelAccessLongBase.ChannelAccessControlsLongImpl(value, alarmStatus, alarmSeverity, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, upperControlLimit, lowerControlLimit, charset);
    }

    public static ChannelAccessSimpleOnlyDouble createDouble(double[] value) {
        return new ChannelAccessDoubleBase.ChannelAccessDoubleImpl(value);
    }

    public static ChannelAccessAlarmOnlyDouble createAlarmDouble(double[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus) {
        return new ChannelAccessDoubleBase.ChannelAccessAlarmDoubleImpl(value, alarmStatus, alarmSeverity);
    }

    public static ChannelAccessTimeDouble createTimeDouble(double[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, int timeStampSeconds, int timeStampNanoSeconds) {
        return new ChannelAccessDoubleBase.ChannelAccessTimeDoubleImpl(value, alarmStatus, alarmSeverity, timeStampSeconds, timeStampNanoSeconds);
    }

    public static ChannelAccessGraphicsOnlyDouble createGraphicsDouble(double[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, double lowerAlarmLimit, double upperAlarmLimit, double lowerWarningLimit, double upperWarningLimit, double lowerDisplayLimit, double upperDisplayLimit, String engineeringUnits, Charset charset, short precision) {
        return new ChannelAccessDoubleBase.ChannelAccessGraphicsDoubleImpl(value, alarmStatus, alarmSeverity, precision, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, charset);
    }

    public static ChannelAccessControlsDouble createControlsDouble(double[] value, ChannelAccessAlarmSeverity alarmSeverity, ChannelAccessAlarmStatus alarmStatus, double lowerAlarmLimit, double upperAlarmLimit, double lowerWarningLimit, double upperWarningLimit, double lowerDisplayLimit, double upperDisplayLimit, String engineeringUnits, Charset charset, short precision, double lowerControlLimit, double upperControlLimit) {
        return new ChannelAccessDoubleBase.ChannelAccessControlsDoubleImpl(value, alarmStatus, alarmSeverity, precision, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, upperControlLimit, lowerControlLimit, charset);
    }

    public static ChannelAccessConfigureAcknowledgeTransientAlarms createConfigureAcknowledgeTransientAlarms(boolean explicitlyAcknowledgeTransientAlarms) {
        return new ChannelAccessConfigureAcknowledgeTransientAlarmsImpl(explicitlyAcknowledgeTransientAlarms);
    }

    public static ChannelAccessAcknowledgeAlarm createAcknowledgeAlarm(ChannelAccessAlarmSeverity acknowledgeAlarmSeverity) {
        return new ChannelAccessAcknowledgeAlarmImpl(acknowledgeAlarmSeverity);
    }

    public static ChannelAccessAlarmAcknowledgementStatus createAlarmAcknowledgementStatus(Collection<String> value, Charset charset, ChannelAccessAlarmSeverity currentAlarmSeverity, ChannelAccessAlarmStatus alarmStatus, boolean explicitlyAcknowledgeTransientAlarms, ChannelAccessAlarmSeverity unackowledgedAlarmSeverity) {
        return new ChannelAccessAlarmAcknowledgementStatusImpl(value, alarmStatus, currentAlarmSeverity, explicitlyAcknowledgeTransientAlarms, unackowledgedAlarmSeverity, charset);
    }

    public static ChannelAccessClassName createClassName(Collection<String> value, Charset charset) {
        return new ChannelAccessClassNameImpl(value, charset);
    }
}

