/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value;

public enum ChannelAccessValueType {
    DBR_STRING(0),
    DBR_SHORT(1),
    DBR_FLOAT(2),
    DBR_ENUM(3),
    DBR_CHAR(4),
    DBR_LONG(5),
    DBR_DOUBLE(6),
    DBR_STS_STRING(7),
    DBR_STS_SHORT(8),
    DBR_STS_FLOAT(9),
    DBR_STS_ENUM(10),
    DBR_STS_CHAR(11),
    DBR_STS_LONG(12),
    DBR_STS_DOUBLE(13),
    DBR_TIME_STRING(14),
    DBR_TIME_SHORT(15),
    DBR_TIME_FLOAT(16),
    DBR_TIME_ENUM(17),
    DBR_TIME_CHAR(18),
    DBR_TIME_LONG(19),
    DBR_TIME_DOUBLE(20),
    DBR_GR_STRING(21),
    DBR_GR_SHORT(22),
    DBR_GR_FLOAT(23),
    DBR_GR_ENUM(24),
    DBR_GR_CHAR(25),
    DBR_GR_LONG(26),
    DBR_GR_DOUBLE(27),
    DBR_CTRL_STRING(28),
    DBR_CTRL_SHORT(29),
    DBR_CTRL_FLOAT(30),
    DBR_CTRL_ENUM(31),
    DBR_CTRL_CHAR(32),
    DBR_CTRL_LONG(33),
    DBR_CTRL_DOUBLE(34),
    DBR_PUT_ACKT(35),
    DBR_PUT_ACKS(36),
    DBR_STSACK_STRING(37),
    DBR_CLASS_NAME(38);

    private static final ChannelAccessValueType[] typeByCode;
    private short typeCode;
    private boolean simpleType;
    private boolean alarmType;
    private boolean timeType;
    private boolean graphicsType;
    private boolean controlsType;
    private boolean specialType;

    private ChannelAccessValueType(int typeCode) {
        this.typeCode = (short)typeCode;
        this.simpleType = this.typeCode < 7;
        this.alarmType = this.typeCode >= 7 && this.typeCode < 14;
        this.timeType = this.typeCode >= 14 && this.typeCode < 21;
        this.graphicsType = this.typeCode >= 21 && this.typeCode < 28;
        this.controlsType = this.typeCode >= 28 && this.typeCode < 35;
        this.specialType = this.typeCode >= 35;
    }

    public short toTypeCode() {
        return this.typeCode;
    }

    public boolean isSimpleType() {
        return this.simpleType;
    }

    public boolean isAlarmType() {
        return this.alarmType;
    }

    public boolean isTimeType() {
        return this.timeType;
    }

    public boolean isGraphicsType() {
        return this.graphicsType;
    }

    public boolean isControlsType() {
        return this.controlsType;
    }

    public boolean isSpecialType() {
        return this.specialType;
    }

    public boolean isGettable() {
        return this.typeCode != 35 && this.typeCode != 36;
    }

    public boolean isPuttable() {
        return this.isSimpleType() || this.typeCode == 35 || this.typeCode == 36;
    }

    public boolean includesAlarm() {
        return this.alarmType || this.timeType || this.graphicsType || this.controlsType;
    }

    public boolean includesGraphics() {
        return this.graphicsType || this.controlsType;
    }

    public ChannelAccessValueType toSimpleType() {
        if (this.typeCode >= 35) {
            throw new IllegalArgumentException("Type " + this.toString() + " is a special type and cannot be converted to a \"simple\" type.");
        }
        return typeByCode[this.typeCode % 7];
    }

    public ChannelAccessValueType toAlarmType() {
        if (this.typeCode >= 35) {
            throw new IllegalArgumentException("Type " + this.toString() + " does not have a corresponding DBR_STS_* type.");
        }
        return typeByCode[this.typeCode % 7 + 7];
    }

    public ChannelAccessValueType toTimeType() {
        if (this.typeCode >= 35) {
            throw new IllegalArgumentException("Type " + this.toString() + " does not have a corresponding DBR_TIME_* type.");
        }
        return typeByCode[this.typeCode % 7 + 14];
    }

    public ChannelAccessValueType toGraphicsType() {
        if (this.typeCode >= 35) {
            throw new IllegalArgumentException("Type " + this.toString() + " does not have a corresponding DBR_GR_* type.");
        }
        return typeByCode[this.typeCode % 7 + 21];
    }

    public ChannelAccessValueType toControlsType() {
        if (this.typeCode >= 35) {
            throw new IllegalArgumentException("Type " + this.toString() + " does not have a corresponding DBR_CTRL_* type.");
        }
        return typeByCode[this.typeCode % 7 + 28];
    }

    public static ChannelAccessValueType forTypeNumber(short typeNumber) {
        if (typeNumber < 0 || typeNumber > 38) {
            throw new IllegalArgumentException("Type number for a Channel Access type must be between 0 and 38.");
        }
        return typeByCode[typeNumber];
    }

    static {
        ChannelAccessValueType[] allValues = ChannelAccessValueType.values();
        typeByCode = new ChannelAccessValueType[allValues.length];
        ChannelAccessValueType[] channelAccessValueTypeArray = allValues;
        int n = channelAccessValueTypeArray.length;
        for (int i = 0; i < n; ++i) {
            ChannelAccessValueType valueType;
            ChannelAccessValueType.typeByCode[valueType.toTypeCode()] = valueType = channelAccessValueTypeArray[i];
        }
    }
}

