/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value.internal;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.util.NullTerminatedStringUtil;
import com.aquenos.epics.jackie.common.value.ChannelAccessValue;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessValueBase;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class AbstractStringBase<ImplementationType extends AbstractStringBase<ImplementationType>>
extends ChannelAccessValueBase<String, ImplementationType> {
    private static final int EPICS_STRING_SIZE = 40;
    private static final byte[] EMPTY_STRING_BYTES = new byte[40];
    protected ArrayList<String> value;
    protected byte[] rawValue;
    protected Charset charset;

    AbstractStringBase(Collection<String> value, Charset charset) {
        assert (value != null);
        assert (charset != null);
        this.charset = charset;
        int numberOfElements = value.size();
        this.rawValue = new byte[numberOfElements * 40];
        this.value = new ArrayList(numberOfElements);
        int stringIndex = 0;
        for (String element : value) {
            if (element == null) {
                throw new NullPointerException();
            }
            this.value.add(element);
            this.updateRawValue(stringIndex, element);
            ++stringIndex;
        }
    }

    AbstractStringBase(ImplementationType delegate) {
        super(delegate);
    }

    AbstractStringBase(Charset charset) {
        assert (charset != null);
        this.charset = charset;
    }

    @Override
    public int getValueSize() {
        if (this.delegate != null) {
            return ((AbstractStringBase)this.delegate).getValueSize();
        }
        return this.value.size();
    }

    public List<String> getValue() {
        if (this.delegate != null) {
            return Collections.unmodifiableList(((AbstractStringBase)this.delegate).getValue());
        }
        return new WrappedStringList();
    }

    public void setValue(Collection<String> value) {
        if (this.delegate != null) {
            throw new UnsupportedOperationException("Cannot modify a read-only value.");
        }
        for (String element : value) {
            if (element != null) continue;
            throw new NullPointerException();
        }
        this.value.clear();
        this.adjustRawValueSize(value.size());
        int stringIndex = 0;
        for (String element : value) {
            this.value.add(element);
            this.updateRawValue(stringIndex, element);
            ++stringIndex;
        }
    }

    @Override
    public String getGenericValueElement(int index) {
        if (this.delegate != null) {
            return ((AbstractStringBase)this.delegate).getGenericValueElement(index);
        }
        return this.value.get(index);
    }

    private void adjustRawValueSize(int numberOfElements) {
        int minimumSize = numberOfElements * 40;
        if (this.rawValue.length < minimumSize) {
            this.rawValue = Arrays.copyOf(this.rawValue, minimumSize);
        }
    }

    private void updateRawValue(int stringIndex, String newValue) {
        assert ((stringIndex + 1) * 40 <= this.rawValue.length);
        byte[] rawString = NullTerminatedStringUtil.stringToTruncatedNullTerminatedFixedBytes(newValue, 40, this.charset);
        System.arraycopy(rawString, 0, this.rawValue, stringIndex * 40, 40);
    }

    public byte[] getRawValue() {
        if (this.delegate != null) {
            return ((AbstractStringBase)this.delegate).getRawValue();
        }
        return Arrays.copyOf(this.rawValue, this.value.size() * 40);
    }

    public void setRawValue(byte[] rawValue) {
        if (this.delegate != null) {
            throw new UnsupportedOperationException("Cannot modify a read-only value.");
        }
        if (rawValue.length % 40 != 0) {
            throw new IllegalArgumentException("The length of the string's raw-value must be an integer multiple of 40.");
        }
        int numberOfStrings = rawValue.length / 40;
        LinkedList<String> newStrings = new LinkedList<String>();
        for (int stringIndex = 0; stringIndex < numberOfStrings; ++stringIndex) {
            newStrings.add(NullTerminatedStringUtil.nullTerminatedBytesToString(rawValue, stringIndex * 40, 40, this.charset, true));
        }
        if (this.rawValue.length >= rawValue.length) {
            System.arraycopy(rawValue, 0, this.rawValue, 0, rawValue.length);
        } else {
            this.rawValue = (byte[])rawValue.clone();
        }
        this.value.clear();
        this.value.addAll(newStrings);
    }

    public Charset getCharset() {
        if (this.delegate != null) {
            return ((AbstractStringBase)this.delegate).getCharset();
        }
        return this.charset;
    }

    protected void deserializeValue(ByteSource byteSource, int numberOfBytes, int count) {
        assert (count >= 0);
        assert (numberOfBytes >= 0);
        this.value = new ArrayList(count);
        if (count == 0) {
            assert (numberOfBytes <= 40);
            byteSource.skip(numberOfBytes);
            this.rawValue = ArrayUtils.EMPTY_BYTE_ARRAY;
        } else if (count == 1 && numberOfBytes < 40) {
            this.rawValue = Arrays.copyOf(byteSource.getByteArray(numberOfBytes), 40);
            this.value.add(NullTerminatedStringUtil.nullTerminatedBytesToString(this.rawValue, 0, 40, this.charset, true));
        } else {
            assert (numberOfBytes == 40 * count);
            this.rawValue = byteSource.getByteArray(40 * count);
            for (int stringIndex = 0; stringIndex < count; ++stringIndex) {
                this.rawValue[(stringIndex + 1) * 40 - 1] = 0;
                this.value.add(NullTerminatedStringUtil.nullTerminatedBytesToString(this.rawValue, stringIndex * 40, 40, this.charset, true));
            }
        }
    }

    protected void serializeValue(ByteSink byteSink, int count) {
        assert (count >= 0);
        assert (count <= this.value.size());
        if (count != 0) {
            byteSink.putByteArray(this.rawValue, 0, 40 * count);
        }
    }

    @Override
    public boolean equals(Object obj) {
        assert (!this.isReadOnly());
        if (!super.equals(obj)) {
            return false;
        }
        AbstractStringBase other = (AbstractStringBase)obj;
        if (!this.value.equals(other.value)) {
            return false;
        }
        if (!this.charset.equals(other.charset)) {
            return false;
        }
        int rawSize = this.value.size() * 40;
        for (int byteIndex = 0; byteIndex < rawSize; ++byteIndex) {
            if (this.rawValue[byteIndex] == other.rawValue[byteIndex]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        assert (!this.isReadOnly());
        HashCodeBuilder hcb = new HashCodeBuilder().appendSuper(super.hashCode()).append(this.value).append((Object)this.charset);
        int rawSize = this.value.size() * 40;
        for (int byteIndex = 0; byteIndex < rawSize; ++byteIndex) {
            hcb.append(this.rawValue[byteIndex]);
        }
        return hcb.toHashCode();
    }

    @Override
    public ChannelAccessValue<String> clone() {
        assert (!this.isReadOnly());
        AbstractStringBase copy = (AbstractStringBase)super.clone();
        copy.value = (ArrayList)this.value.clone();
        copy.rawValue = (byte[])this.rawValue.clone();
        return copy;
    }

    private class WrappedStringList
    extends AbstractList<String> {
        private WrappedStringList() {
        }

        @Override
        public String get(int index) {
            return AbstractStringBase.this.value.get(index);
        }

        @Override
        public int size() {
            return AbstractStringBase.this.value.size();
        }

        @Override
        public String set(int index, String element) {
            if (element == null) {
                throw new NullPointerException();
            }
            String old = AbstractStringBase.this.value.set(index, element);
            AbstractStringBase.this.updateRawValue(index, element);
            return old;
        }

        @Override
        public void add(int index, String element) {
            if (element == null) {
                throw new NullPointerException();
            }
            AbstractStringBase.this.value.add(index, element);
            int newSize = AbstractStringBase.this.value.size();
            AbstractStringBase.this.adjustRawValueSize(newSize);
            for (int stringIndex = index; stringIndex < newSize; ++stringIndex) {
                AbstractStringBase.this.updateRawValue(stringIndex, AbstractStringBase.this.value.get(stringIndex));
            }
        }

        @Override
        public String remove(int index) {
            String removed = AbstractStringBase.this.value.remove(index);
            int newSize = AbstractStringBase.this.value.size();
            for (int stringIndex = index; stringIndex < newSize; ++stringIndex) {
                AbstractStringBase.this.updateRawValue(stringIndex, AbstractStringBase.this.value.get(stringIndex));
            }
            return removed;
        }

        @Override
        public void clear() {
            AbstractStringBase.this.value.clear();
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            return this.addAll(AbstractStringBase.this.value.size(), c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends String> c) {
            for (String string : c) {
                if (string != null) continue;
                throw new NullPointerException();
            }
            boolean modified = AbstractStringBase.this.value.addAll(index, c);
            if (modified) {
                int n = AbstractStringBase.this.value.size();
                AbstractStringBase.this.adjustRawValueSize(n);
                for (int stringIndex = index; stringIndex < n; ++stringIndex) {
                    AbstractStringBase.this.updateRawValue(stringIndex, AbstractStringBase.this.value.get(stringIndex));
                }
            }
            return modified;
        }

        @Override
        public Object[] toArray() {
            return AbstractStringBase.this.value.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return AbstractStringBase.this.value.toArray(a);
        }
    }
}

