/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value.internal;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.value.ChannelAccessAcknowledgeAlarm;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmSeverity;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessValueBase;
import java.nio.ShortBuffer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessAcknowledgeAlarmImpl
extends ChannelAccessValueBase<Short, ChannelAccessAcknowledgeAlarmImpl>
implements ChannelAccessAcknowledgeAlarm {
    protected short[] value;

    public ChannelAccessAcknowledgeAlarmImpl(ChannelAccessAlarmSeverity acknowledgeAlarmSeverity) {
        this.value = new short[]{acknowledgeAlarmSeverity.toSeverityCode()};
    }

    private ChannelAccessAcknowledgeAlarmImpl(ChannelAccessAcknowledgeAlarmImpl delegate) {
        super(delegate);
    }

    private ChannelAccessAcknowledgeAlarmImpl() {
    }

    @Override
    public ChannelAccessValueType getType() {
        return ChannelAccessValueType.DBR_PUT_ACKS;
    }

    @Override
    public int getValueSize() {
        if (this.delegate != null) {
            return ((ChannelAccessAcknowledgeAlarmImpl)this.delegate).getValueSize();
        }
        return this.value.length;
    }

    @Override
    public Short getGenericValueElement(int index) {
        if (this.delegate != null) {
            return ((ChannelAccessAcknowledgeAlarmImpl)this.delegate).getGenericValueElement(index);
        }
        return this.value[index];
    }

    @Override
    public ChannelAccessAlarmSeverity getAcknowledgeAlarmSeverity() {
        if (this.delegate != null) {
            return ((ChannelAccessAcknowledgeAlarmImpl)this.delegate).getAcknowledgeAlarmSeverity();
        }
        if (this.value.length == 0) {
            return ChannelAccessAlarmSeverity.NO_ALARM;
        }
        try {
            return ChannelAccessAlarmSeverity.forSeverityCode(this.value[0]);
        }
        catch (IllegalArgumentException e) {
            return ChannelAccessAlarmSeverity.INVALID_ALARM;
        }
    }

    @Override
    public void setAcknowledgeAlarmSeverity(ChannelAccessAlarmSeverity acknowledgeAlarmSeverity) {
        if (this.delegate != null) {
            throw new UnsupportedOperationException("Cannot modify a read-only value.");
        }
        if (this.value.length != 1) {
            this.value = new short[1];
        }
        this.value[0] = acknowledgeAlarmSeverity.toSeverityCode();
    }

    @Override
    public ShortBuffer getValue() {
        if (this.delegate != null) {
            return ((ChannelAccessAcknowledgeAlarmImpl)this.delegate).getValue().asReadOnlyBuffer();
        }
        return ShortBuffer.wrap(this.value);
    }

    @Override
    public void setValue(short[] value) {
        if (this.delegate != null) {
            throw new UnsupportedOperationException("Cannot modify a read-only value.");
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    @Override
    public void serialize(ByteSink byteSink, int count) {
        if (this.delegate != null) {
            ((ChannelAccessAcknowledgeAlarmImpl)this.delegate).serialize(byteSink, count);
            return;
        }
        assert (count >= 0);
        assert (count <= this.value.length);
        if (count != 0) {
            byteSink.putShortArray(this.value, 0, count);
        }
    }

    @Override
    public ChannelAccessAcknowledgeAlarm asReadOnlyValue() {
        if (this.delegate != null) {
            return this;
        }
        return new ChannelAccessAcknowledgeAlarmImpl(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.delegate != null) {
            return ((ChannelAccessAcknowledgeAlarmImpl)this.delegate).equals(obj);
        }
        if (!super.equals(obj = ChannelAccessAcknowledgeAlarmImpl.extractDelegate(obj))) {
            return false;
        }
        ChannelAccessAcknowledgeAlarmImpl other = (ChannelAccessAcknowledgeAlarmImpl)obj;
        return new EqualsBuilder().append(this.value, other.value).isEquals();
    }

    @Override
    public int hashCode() {
        if (this.delegate != null) {
            return ((ChannelAccessAcknowledgeAlarmImpl)this.delegate).hashCode();
        }
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.value).toHashCode();
    }

    @Override
    public ChannelAccessAcknowledgeAlarm clone() {
        if (this.delegate != null) {
            return ((ChannelAccessAcknowledgeAlarmImpl)this.delegate).clone();
        }
        ChannelAccessAcknowledgeAlarmImpl copy = (ChannelAccessAcknowledgeAlarmImpl)super.clone();
        copy.value = (short[])this.value.clone();
        return copy;
    }

    public static ChannelAccessAcknowledgeAlarmImpl deserialize(ByteSource byteSource, int count) {
        assert (count >= 0);
        ChannelAccessAcknowledgeAlarmImpl value = new ChannelAccessAcknowledgeAlarmImpl();
        value.value = count == 0 ? ArrayUtils.EMPTY_SHORT_ARRAY : byteSource.getShortArray(count);
        return value;
    }
}

