/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value.internal;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmAcknowledgementStatus;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmSeverity;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmStatus;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueCodec;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import com.aquenos.epics.jackie.common.value.internal.AbstractStringBase;
import com.aquenos.epics.jackie.common.value.internal.ValueCodecUtils;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessAlarmAcknowledgementStatusImpl
extends AbstractStringBase<ChannelAccessAlarmAcknowledgementStatusImpl>
implements ChannelAccessAlarmAcknowledgementStatus {
    private static final int META_DATA_SIZE = ChannelAccessValueCodec.calculatePayloadSize(ChannelAccessValueType.DBR_STSACK_STRING, 0);
    protected ChannelAccessAlarmStatus alarmStatus;
    protected ChannelAccessAlarmSeverity currentAlarmSeverity;
    protected boolean explicitlyAcknowledgeTransientAlarms;
    protected ChannelAccessAlarmSeverity unacknowledgedAlarmSeverity;

    public ChannelAccessAlarmAcknowledgementStatusImpl(Collection<String> value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity currentAlarmSeverity, boolean explicitlyAcknowledgeTransientAlarms, ChannelAccessAlarmSeverity unackowledgedAlarmSeverity, Charset charset) {
        super(value, charset);
        assert (alarmStatus != null);
        this.alarmStatus = alarmStatus;
        assert (currentAlarmSeverity != null);
        this.currentAlarmSeverity = currentAlarmSeverity;
        this.explicitlyAcknowledgeTransientAlarms = explicitlyAcknowledgeTransientAlarms;
        assert (unackowledgedAlarmSeverity != null);
        this.unacknowledgedAlarmSeverity = unackowledgedAlarmSeverity;
    }

    private ChannelAccessAlarmAcknowledgementStatusImpl(ChannelAccessAlarmAcknowledgementStatusImpl delegate) {
        super(delegate);
    }

    private ChannelAccessAlarmAcknowledgementStatusImpl(Charset charset) {
        super(charset);
    }

    @Override
    public ChannelAccessValueType getType() {
        return ChannelAccessValueType.DBR_STSACK_STRING;
    }

    @Override
    public ChannelAccessAlarmStatus getAlarmStatus() {
        if (this.delegate != null) {
            return ((ChannelAccessAlarmAcknowledgementStatusImpl)this.delegate).getAlarmStatus();
        }
        return this.alarmStatus;
    }

    @Override
    public void setAlarmStatus(ChannelAccessAlarmStatus alarmStatus) {
        if (this.delegate != null) {
            throw new UnsupportedOperationException("Cannot modify a read-only value.");
        }
        this.alarmStatus = alarmStatus;
    }

    @Override
    public ChannelAccessAlarmSeverity getAlarmSeverity() {
        if (this.delegate != null) {
            return ((ChannelAccessAlarmAcknowledgementStatusImpl)this.delegate).getAlarmSeverity();
        }
        return this.currentAlarmSeverity;
    }

    @Override
    public void setAlarmSeverity(ChannelAccessAlarmSeverity alarmSeverity) {
        if (this.delegate != null) {
            throw new UnsupportedOperationException("Cannot modify a read-only value.");
        }
        this.currentAlarmSeverity = alarmSeverity;
    }

    @Override
    public boolean isExplicitlyAcknowledgeTransientAlarms() {
        if (this.delegate != null) {
            return ((ChannelAccessAlarmAcknowledgementStatusImpl)this.delegate).isExplicitlyAcknowledgeTransientAlarms();
        }
        return this.explicitlyAcknowledgeTransientAlarms;
    }

    @Override
    public void setExplicitlyAcknowledgeTransientAlarms(boolean explicitlyAcknowledgeTransientAlarms) {
        if (this.delegate != null) {
            throw new UnsupportedOperationException("Cannot modify a read-only value.");
        }
        this.explicitlyAcknowledgeTransientAlarms = explicitlyAcknowledgeTransientAlarms;
    }

    @Override
    public ChannelAccessAlarmSeverity getUnacknowledgedAlarmSeverity() {
        if (this.delegate != null) {
            return ((ChannelAccessAlarmAcknowledgementStatusImpl)this.delegate).getUnacknowledgedAlarmSeverity();
        }
        return this.unacknowledgedAlarmSeverity;
    }

    @Override
    public void setUnacknowledgedAlarmSeverity(ChannelAccessAlarmSeverity unacknowledgedAlarmSeverity) {
        if (this.delegate != null) {
            throw new UnsupportedOperationException("Cannot modify a read-only value.");
        }
        this.unacknowledgedAlarmSeverity = unacknowledgedAlarmSeverity;
    }

    @Override
    public void serialize(ByteSink byteSink, int count) {
        if (this.delegate != null) {
            ((ChannelAccessAlarmAcknowledgementStatusImpl)this.delegate).serialize(byteSink, count);
            return;
        }
        assert (count >= 0);
        assert (count <= this.value.size());
        ValueCodecUtils.serializeAlarms(byteSink, this.alarmStatus, this.currentAlarmSeverity);
        ValueCodecUtils.serializeBooleanAsShort(byteSink, this.explicitlyAcknowledgeTransientAlarms);
        ValueCodecUtils.serializeAlarmSeverity(byteSink, this.unacknowledgedAlarmSeverity);
        this.serializeValue(byteSink, count);
    }

    @Override
    public ChannelAccessAlarmAcknowledgementStatus asReadOnlyValue() {
        if (this.delegate != null) {
            return this;
        }
        return new ChannelAccessAlarmAcknowledgementStatusImpl(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.delegate != null) {
            return ((ChannelAccessAlarmAcknowledgementStatusImpl)this.delegate).equals(obj);
        }
        if (!super.equals(obj = ChannelAccessAlarmAcknowledgementStatusImpl.extractDelegate(obj))) {
            return false;
        }
        ChannelAccessAlarmAcknowledgementStatusImpl other = (ChannelAccessAlarmAcknowledgementStatusImpl)obj;
        return new EqualsBuilder().append((Object)this.alarmStatus, (Object)other.alarmStatus).append((Object)this.currentAlarmSeverity, (Object)other.currentAlarmSeverity).append(this.explicitlyAcknowledgeTransientAlarms, other.explicitlyAcknowledgeTransientAlarms).append((Object)this.unacknowledgedAlarmSeverity, (Object)other.unacknowledgedAlarmSeverity).isEquals();
    }

    @Override
    public int hashCode() {
        if (this.delegate != null) {
            return ((ChannelAccessAlarmAcknowledgementStatusImpl)this.delegate).hashCode();
        }
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.alarmStatus).append((Object)this.currentAlarmSeverity).append(this.explicitlyAcknowledgeTransientAlarms).append((Object)this.unacknowledgedAlarmSeverity).toHashCode();
    }

    @Override
    public ChannelAccessAlarmAcknowledgementStatus clone() {
        if (this.delegate != null) {
            return ((ChannelAccessAlarmAcknowledgementStatusImpl)this.delegate).clone();
        }
        ChannelAccessAlarmAcknowledgementStatusImpl copy = (ChannelAccessAlarmAcknowledgementStatusImpl)super.clone();
        return copy;
    }

    public static ChannelAccessAlarmAcknowledgementStatusImpl deserialize(ByteSource byteSource, int numberOfBytes, int count, Charset charset) {
        ChannelAccessAlarmAcknowledgementStatusImpl value = new ChannelAccessAlarmAcknowledgementStatusImpl(charset);
        value.alarmStatus = ValueCodecUtils.deserializeAlarmStatus(byteSource);
        value.currentAlarmSeverity = ValueCodecUtils.deserializeAlarmSeverity(byteSource);
        value.explicitlyAcknowledgeTransientAlarms = ValueCodecUtils.deserializeBooleanFromShort(byteSource);
        value.unacknowledgedAlarmSeverity = ValueCodecUtils.deserializeAlarmSeverity(byteSource);
        value.deserializeValue(byteSource, numberOfBytes - META_DATA_SIZE, count);
        return value;
    }
}

