/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value.internal;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.util.NullTerminatedStringUtil;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmChar;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmOnlyChar;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmSeverity;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmStatus;
import com.aquenos.epics.jackie.common.value.ChannelAccessChar;
import com.aquenos.epics.jackie.common.value.ChannelAccessControlsChar;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsChar;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsOnlyChar;
import com.aquenos.epics.jackie.common.value.ChannelAccessSimpleOnlyChar;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeChar;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeStamp;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueFactory;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessValueBase;
import com.aquenos.epics.jackie.common.value.internal.ValueCodecUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class ChannelAccessCharBase<ImplementationType extends ChannelAccessCharBase<ImplementationType>>
extends ChannelAccessValueBase<Byte, ImplementationType>
implements ChannelAccessChar {
    protected byte[] value;

    private ChannelAccessCharBase(byte[] value) {
        assert (value != null);
        this.value = value;
    }

    private ChannelAccessCharBase(ImplementationType delegate) {
        super(delegate);
    }

    private ChannelAccessCharBase() {
    }

    @Override
    public int getValueSize() {
        if (this.delegate != null) {
            return ((ChannelAccessCharBase)this.delegate).getValueSize();
        }
        return this.value.length;
    }

    @Override
    public Byte getGenericValueElement(int index) {
        if (this.delegate != null) {
            return ((ChannelAccessCharBase)this.delegate).getGenericValueElement(index);
        }
        return this.value[index];
    }

    @Override
    public ByteBuffer getValue() {
        if (this.delegate != null) {
            return ((ChannelAccessCharBase)this.delegate).getValue().asReadOnlyBuffer();
        }
        return ByteBuffer.wrap(this.value);
    }

    @Override
    public void setValue(byte[] value) {
        if (this.delegate != null) {
            throw new UnsupportedOperationException("Cannot modify a read-only value.");
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    protected void deserializeValue(ByteSource byteSource, int count) {
        assert (count >= 0);
        this.value = count == 0 ? ArrayUtils.EMPTY_BYTE_ARRAY : byteSource.getByteArray(count);
    }

    protected void serializeValue(ByteSink byteSink, int count) {
        if (count != 0) {
            byteSink.putByteArray(this.value, 0, count);
        }
    }

    @Override
    public boolean equals(Object obj) {
        assert (!this.isReadOnly());
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessCharBase other = (ChannelAccessCharBase)obj;
        return new EqualsBuilder().append(this.value, other.value).isEquals();
    }

    @Override
    public int hashCode() {
        assert (!this.isReadOnly());
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.value).toHashCode();
    }

    @Override
    public ChannelAccessChar clone() {
        assert (!this.isReadOnly());
        ChannelAccessCharBase copy = (ChannelAccessCharBase)super.clone();
        copy.value = (byte[])this.value.clone();
        return copy;
    }

    /* synthetic */ ChannelAccessCharBase(ChannelAccessCharBase x0, 1 x1) {
        this(x0);
    }

    public static final class ChannelAccessControlsCharImpl
    extends ChannelAccessGraphicsCharBase<ChannelAccessControlsCharImpl>
    implements ChannelAccessControlsChar {
        protected byte upperControlLimit;
        protected byte lowerControlLimit;

        public ChannelAccessControlsCharImpl(byte[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, String engineeringUnits, byte upperDisplayLimit, byte lowerDisplayLimit, byte upperAlarmLimit, byte upperWarningLimit, byte lowerWarningLimit, byte lowerAlarmLimit, byte upperControlLimit, byte lowerControlLimit, Charset charset) {
            super(value, alarmStatus, alarmSeverity, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, charset);
            this.upperControlLimit = upperControlLimit;
            this.lowerControlLimit = lowerControlLimit;
        }

        private ChannelAccessControlsCharImpl(ChannelAccessControlsCharImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessControlsCharImpl(Charset charset) {
            super(charset);
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_CTRL_CHAR;
        }

        @Override
        public Byte getGenericUpperControlLimit() {
            return this.getUpperControlLimit();
        }

        @Override
        public Byte getGenericLowerControlLimit() {
            return this.getLowerControlLimit();
        }

        @Override
        public byte getUpperControlLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsCharImpl)this.delegate).getUpperControlLimit();
            }
            return this.upperControlLimit;
        }

        @Override
        public void setUpperControlLimit(byte upperControlLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperControlLimit = upperControlLimit;
        }

        @Override
        public byte getLowerControlLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsCharImpl)this.delegate).getLowerControlLimit();
            }
            return this.lowerControlLimit;
        }

        @Override
        public void setLowerControlLimit(byte lowerControlLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerControlLimit = lowerControlLimit;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessControlsCharImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            this.serializeGraphics(byteSink);
            byteSink.putByte(this.upperControlLimit);
            byteSink.putByte(this.lowerControlLimit);
            byteSink.putByte((byte)0);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessControlsChar asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessControlsCharImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessControlsCharImpl)this.delegate).equals(obj);
            }
            if (!super.equals(obj = ChannelAccessControlsCharImpl.extractDelegate(obj))) {
                return false;
            }
            ChannelAccessControlsCharImpl other = (ChannelAccessControlsCharImpl)obj;
            return new EqualsBuilder().append(this.upperControlLimit, other.upperControlLimit).append(this.lowerControlLimit, other.lowerControlLimit).isEquals();
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsCharImpl)this.delegate).hashCode();
            }
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.upperControlLimit).append(this.lowerControlLimit).toHashCode();
        }

        @Override
        public ChannelAccessControlsChar clone() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsCharImpl)this.delegate).clone();
            }
            return (ChannelAccessControlsChar)super.clone();
        }

        public static ChannelAccessControlsCharImpl deserialize(ByteSource byteSource, int count, Charset charset) {
            ChannelAccessControlsCharImpl value = new ChannelAccessControlsCharImpl(charset);
            value.deserializeAlarms(byteSource);
            value.deserializeGraphics(byteSource);
            value.upperControlLimit = byteSource.getByte();
            value.lowerControlLimit = byteSource.getByte();
            byteSource.skip(1);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static final class ChannelAccessGraphicsCharImpl
    extends ChannelAccessGraphicsCharBase<ChannelAccessGraphicsCharImpl>
    implements ChannelAccessGraphicsOnlyChar {
        public ChannelAccessGraphicsCharImpl(byte[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, String engineeringUnits, byte upperDisplayLimit, byte lowerDisplayLimit, byte upperAlarmLimit, byte upperWarningLimit, byte lowerWarningLimit, byte lowerAlarmLimit, Charset charset) {
            super(value, alarmStatus, alarmSeverity, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, charset);
        }

        private ChannelAccessGraphicsCharImpl(ChannelAccessGraphicsCharImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessGraphicsCharImpl(Charset charset) {
            super(charset);
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_GR_CHAR;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessGraphicsCharImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            this.serializeGraphics(byteSink);
            byteSink.putByte((byte)0);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessGraphicsOnlyChar asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessGraphicsCharImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsCharImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessGraphicsCharImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsCharImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessGraphicsOnlyChar clone() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsCharImpl)this.delegate).clone();
            }
            return (ChannelAccessGraphicsOnlyChar)super.clone();
        }

        public static ChannelAccessGraphicsCharImpl deserialize(ByteSource byteSource, int count, Charset charset) {
            ChannelAccessGraphicsCharImpl value = new ChannelAccessGraphicsCharImpl(charset);
            value.deserializeAlarms(byteSource);
            value.deserializeGraphics(byteSource);
            byteSource.skip(1);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static abstract class ChannelAccessGraphicsCharBase<ImplementationType extends ChannelAccessGraphicsCharBase<ImplementationType>>
    extends ChannelAccessAlarmCharBase<ImplementationType>
    implements ChannelAccessGraphicsChar {
        private static final int ENGINEERING_UNITS_STRING_SIZE = 8;
        protected String engineeringUnits;
        protected byte[] rawEngineeringUnits;
        protected byte upperDisplayLimit;
        protected byte lowerDisplayLimit;
        protected byte upperAlarmLimit;
        protected byte upperWarningLimit;
        protected byte lowerWarningLimit;
        protected byte lowerAlarmLimit;
        protected Charset charset;

        private ChannelAccessGraphicsCharBase(byte[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, String engineeringUnits, byte upperDisplayLimit, byte lowerDisplayLimit, byte upperAlarmLimit, byte upperWarningLimit, byte lowerWarningLimit, byte lowerAlarmLimit, Charset charset) {
            super(value, alarmStatus, alarmSeverity);
            this.engineeringUnits = engineeringUnits;
            assert (charset != null);
            this.charset = charset;
            this.rawEngineeringUnits = NullTerminatedStringUtil.stringToTruncatedNullTerminatedFixedBytes(this.engineeringUnits, 8, charset);
            this.upperDisplayLimit = upperDisplayLimit;
            this.lowerDisplayLimit = lowerDisplayLimit;
            this.upperAlarmLimit = upperAlarmLimit;
            this.upperWarningLimit = upperWarningLimit;
            this.lowerWarningLimit = lowerWarningLimit;
            this.lowerAlarmLimit = lowerAlarmLimit;
        }

        private ChannelAccessGraphicsCharBase(ImplementationType delegate) {
            super((ChannelAccessAlarmCharBase)delegate, null);
        }

        private ChannelAccessGraphicsCharBase(Charset charset) {
            this.charset = charset;
        }

        @Override
        public String getUnits() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsCharBase)this.delegate).getUnits();
            }
            return this.engineeringUnits;
        }

        @Override
        public byte[] getRawUnits() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsCharBase)this.delegate).getRawUnits();
            }
            return (byte[])this.rawEngineeringUnits.clone();
        }

        @Override
        public void setUnits(String units) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.engineeringUnits = units;
            this.rawEngineeringUnits = NullTerminatedStringUtil.stringToTruncatedNullTerminatedFixedBytes(this.engineeringUnits, 8, this.charset);
        }

        @Override
        public void setRawUnits(byte[] rawUnits) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.rawEngineeringUnits = new byte[8];
            int copyLength = Math.min(rawUnits.length, 7);
            System.arraycopy(rawUnits, 0, this.rawEngineeringUnits, 0, copyLength);
            this.engineeringUnits = NullTerminatedStringUtil.nullTerminatedBytesToString(this.rawEngineeringUnits, this.charset);
        }

        @Override
        public Byte getGenericUpperDisplayLimit() {
            return this.getUpperDisplayLimit();
        }

        @Override
        public Byte getGenericLowerDisplayLimit() {
            return this.getLowerDisplayLimit();
        }

        @Override
        public Byte getGenericUpperAlarmLimit() {
            return this.getUpperAlarmLimit();
        }

        @Override
        public Byte getGenericUpperWarningLimit() {
            return this.getUpperWarningLimit();
        }

        @Override
        public Byte getGenericLowerWarningLimit() {
            return this.getLowerWarningLimit();
        }

        @Override
        public Byte getGenericLowerAlarmLimit() {
            return this.getLowerAlarmLimit();
        }

        @Override
        public Charset getCharset() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsCharBase)this.delegate).getCharset();
            }
            return this.charset;
        }

        @Override
        public byte getUpperDisplayLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsCharBase)this.delegate).getUpperDisplayLimit();
            }
            return this.upperDisplayLimit;
        }

        @Override
        public void setUpperDisplayLimit(byte upperDisplayLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperDisplayLimit = upperDisplayLimit;
        }

        @Override
        public byte getLowerDisplayLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsCharBase)this.delegate).getLowerDisplayLimit();
            }
            return this.lowerDisplayLimit;
        }

        @Override
        public void setLowerDisplayLimit(byte lowerDisplayLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerDisplayLimit = lowerDisplayLimit;
        }

        @Override
        public byte getUpperAlarmLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsCharBase)this.delegate).getUpperAlarmLimit();
            }
            return this.upperAlarmLimit;
        }

        @Override
        public void setUpperAlarmLimit(byte upperAlarmLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperAlarmLimit = upperAlarmLimit;
        }

        @Override
        public byte getUpperWarningLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsCharBase)this.delegate).getUpperWarningLimit();
            }
            return this.upperWarningLimit;
        }

        @Override
        public void setUpperWarningLimit(byte upperWarningLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperWarningLimit = upperWarningLimit;
        }

        @Override
        public byte getLowerWarningLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsCharBase)this.delegate).getLowerWarningLimit();
            }
            return this.lowerWarningLimit;
        }

        @Override
        public void setLowerWarningLimit(byte lowerWarningLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerWarningLimit = lowerWarningLimit;
        }

        @Override
        public byte getLowerAlarmLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsCharBase)this.delegate).getLowerAlarmLimit();
            }
            return this.lowerAlarmLimit;
        }

        @Override
        public void setLowerAlarmLimit(byte lowerAlarmLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerAlarmLimit = lowerAlarmLimit;
        }

        protected void deserializeGraphics(ByteSource byteSource) {
            this.rawEngineeringUnits = byteSource.getByteArray(8);
            this.rawEngineeringUnits[7] = 0;
            this.engineeringUnits = NullTerminatedStringUtil.nullTerminatedBytesToString(this.rawEngineeringUnits, this.charset);
            this.upperDisplayLimit = byteSource.getByte();
            this.lowerDisplayLimit = byteSource.getByte();
            this.upperAlarmLimit = byteSource.getByte();
            this.upperWarningLimit = byteSource.getByte();
            this.lowerWarningLimit = byteSource.getByte();
            this.lowerAlarmLimit = byteSource.getByte();
        }

        protected void serializeGraphics(ByteSink byteSink) {
            byteSink.putByteArray(this.rawEngineeringUnits);
            byteSink.putByte(this.upperDisplayLimit);
            byteSink.putByte(this.lowerDisplayLimit);
            byteSink.putByte(this.upperAlarmLimit);
            byteSink.putByte(this.upperWarningLimit);
            byteSink.putByte(this.lowerWarningLimit);
            byteSink.putByte(this.lowerAlarmLimit);
        }

        @Override
        public boolean equals(Object obj) {
            assert (!this.isReadOnly());
            if (!super.equals(obj)) {
                return false;
            }
            ChannelAccessGraphicsCharBase other = (ChannelAccessGraphicsCharBase)obj;
            return new EqualsBuilder().append((Object)this.engineeringUnits, (Object)other.engineeringUnits).append(this.rawEngineeringUnits, other.rawEngineeringUnits).append(this.upperDisplayLimit, other.upperDisplayLimit).append(this.lowerDisplayLimit, other.lowerDisplayLimit).append(this.upperAlarmLimit, other.upperAlarmLimit).append(this.upperWarningLimit, other.upperWarningLimit).append(this.lowerWarningLimit, other.lowerWarningLimit).append(this.lowerAlarmLimit, other.lowerAlarmLimit).append((Object)this.charset, (Object)other.charset).isEquals();
        }

        @Override
        public int hashCode() {
            assert (!this.isReadOnly());
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.engineeringUnits).append(this.rawEngineeringUnits).append(this.upperDisplayLimit).append(this.lowerDisplayLimit).append(this.upperAlarmLimit).append(this.upperWarningLimit).append(this.lowerWarningLimit).append(this.lowerAlarmLimit).append((Object)this.charset).toHashCode();
        }

        @Override
        public ChannelAccessGraphicsChar clone() {
            assert (!this.isReadOnly());
            return (ChannelAccessGraphicsChar)super.clone();
        }

        /* synthetic */ ChannelAccessGraphicsCharBase(ChannelAccessGraphicsCharBase x0, 1 x1) {
            this(x0);
        }
    }

    public static final class ChannelAccessTimeCharImpl
    extends ChannelAccessAlarmCharBase<ChannelAccessTimeCharImpl>
    implements ChannelAccessTimeChar {
        private static final byte[] THREE_BYTES = new byte[3];
        protected int timeStampSeconds;
        protected int timeStampNanoseconds;

        public ChannelAccessTimeCharImpl(byte[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, int timeStampSeconds, int timeStampNanoSeconds) {
            super(value, alarmStatus, alarmSeverity);
            this.timeStampSeconds = timeStampSeconds;
            if (timeStampNanoSeconds < 0 || timeStampNanoSeconds > 999999999) {
                throw new IllegalArgumentException("Nanoseconds part of timestamp must be a number between 0 and 999999999.");
            }
            this.timeStampNanoseconds = timeStampNanoSeconds;
        }

        private ChannelAccessTimeCharImpl(ChannelAccessTimeCharImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessTimeCharImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_TIME_CHAR;
        }

        @Override
        public ChannelAccessTimeStamp getTimeStamp() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeCharImpl)this.delegate).getTimeStamp();
            }
            return ChannelAccessValueFactory.createTimeStamp(this.timeStampSeconds, this.timeStampNanoseconds);
        }

        @Override
        public int getTimeSeconds() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeCharImpl)this.delegate).getTimeSeconds();
            }
            return this.timeStampSeconds;
        }

        @Override
        public int getTimeNanoseconds() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeCharImpl)this.delegate).getTimeNanoseconds();
            }
            return this.timeStampNanoseconds;
        }

        @Override
        public void setTimeStamp(ChannelAccessTimeStamp timeStamp) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.timeStampSeconds = timeStamp.getSeconds();
            this.timeStampNanoseconds = timeStamp.getNanoseconds();
        }

        @Override
        public void setTimeSeconds(int timeStampSeconds) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.timeStampSeconds = timeStampSeconds;
        }

        @Override
        public void setTimeNanoseconds(int timeStampNanoseconds) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            if (timeStampNanoseconds < 0 || timeStampNanoseconds > 999999999) {
                throw new IllegalArgumentException("Nanoseconds part of time-stamp must be a number between 0 and 999999999.");
            }
            this.timeStampNanoseconds = timeStampNanoseconds;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessTimeCharImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            ValueCodecUtils.serializeTime(byteSink, this.timeStampSeconds, this.timeStampNanoseconds);
            byteSink.putByteArray(THREE_BYTES);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessTimeChar asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessTimeCharImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessTimeCharImpl)this.delegate).equals(obj);
            }
            if (!super.equals(obj = ChannelAccessTimeCharImpl.extractDelegate(obj))) {
                return false;
            }
            ChannelAccessTimeCharImpl other = (ChannelAccessTimeCharImpl)obj;
            return new EqualsBuilder().append(this.timeStampSeconds, other.timeStampSeconds).append(this.timeStampNanoseconds, other.timeStampNanoseconds).isEquals();
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeCharImpl)this.delegate).hashCode();
            }
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.timeStampSeconds).append(this.timeStampNanoseconds).toHashCode();
        }

        @Override
        public ChannelAccessTimeChar clone() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeCharImpl)this.delegate).clone();
            }
            return (ChannelAccessTimeChar)super.clone();
        }

        public static ChannelAccessTimeCharImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessTimeCharImpl value = new ChannelAccessTimeCharImpl();
            value.deserializeAlarms(byteSource);
            value.timeStampSeconds = ValueCodecUtils.deserializeTimeSeconds(byteSource);
            value.timeStampNanoseconds = ValueCodecUtils.deserializeTimeNanoseconds(byteSource);
            byteSource.skip(3);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static final class ChannelAccessAlarmCharImpl
    extends ChannelAccessAlarmCharBase<ChannelAccessAlarmCharImpl>
    implements ChannelAccessAlarmOnlyChar {
        public ChannelAccessAlarmCharImpl(byte[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity) {
            super(value, alarmStatus, alarmSeverity);
        }

        private ChannelAccessAlarmCharImpl(ChannelAccessAlarmCharImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessAlarmCharImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_STS_CHAR;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessAlarmCharImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            byteSink.putByte((byte)0);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessAlarmOnlyChar asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessAlarmCharImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmCharImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessAlarmCharImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmCharImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessAlarmOnlyChar clone() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmCharImpl)this.delegate).clone();
            }
            return (ChannelAccessAlarmOnlyChar)super.clone();
        }

        public static ChannelAccessAlarmCharImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessAlarmCharImpl value = new ChannelAccessAlarmCharImpl();
            value.deserializeAlarms(byteSource);
            byteSource.skip(1);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static abstract class ChannelAccessAlarmCharBase<ImplementationType extends ChannelAccessAlarmCharBase<ImplementationType>>
    extends ChannelAccessCharBase<ImplementationType>
    implements ChannelAccessAlarmChar {
        protected ChannelAccessAlarmStatus alarmStatus;
        protected ChannelAccessAlarmSeverity alarmSeverity;

        private ChannelAccessAlarmCharBase(byte[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity) {
            super(value);
            this.alarmStatus = alarmStatus;
            this.alarmSeverity = alarmSeverity;
        }

        private ChannelAccessAlarmCharBase(ImplementationType delegate) {
            super((ChannelAccessCharBase)delegate, null);
        }

        private ChannelAccessAlarmCharBase() {
        }

        @Override
        public ChannelAccessAlarmStatus getAlarmStatus() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmCharBase)this.delegate).getAlarmStatus();
            }
            return this.alarmStatus;
        }

        @Override
        public void setAlarmStatus(ChannelAccessAlarmStatus alarmStatus) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            assert (alarmStatus != null);
            this.alarmStatus = alarmStatus;
        }

        @Override
        public ChannelAccessAlarmSeverity getAlarmSeverity() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmCharBase)this.delegate).getAlarmSeverity();
            }
            return this.alarmSeverity;
        }

        @Override
        public void setAlarmSeverity(ChannelAccessAlarmSeverity alarmSeverity) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            assert (alarmSeverity != null);
            this.alarmSeverity = alarmSeverity;
        }

        protected void deserializeAlarms(ByteSource byteSource) {
            this.alarmStatus = ValueCodecUtils.deserializeAlarmStatus(byteSource);
            this.alarmSeverity = ValueCodecUtils.deserializeAlarmSeverity(byteSource);
        }

        protected void serializeAlarms(ByteSink byteSink) {
            ValueCodecUtils.serializeAlarms(byteSink, this.alarmStatus, this.alarmSeverity);
        }

        @Override
        public boolean equals(Object obj) {
            assert (!this.isReadOnly());
            if (!super.equals(obj)) {
                return false;
            }
            ChannelAccessAlarmCharBase other = (ChannelAccessAlarmCharBase)obj;
            return new EqualsBuilder().append((Object)this.alarmStatus, (Object)other.alarmStatus).append((Object)this.alarmSeverity, (Object)other.alarmSeverity).isEquals();
        }

        @Override
        public int hashCode() {
            assert (!this.isReadOnly());
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.alarmStatus).append((Object)this.alarmSeverity).toHashCode();
        }

        @Override
        public ChannelAccessAlarmChar clone() {
            assert (!this.isReadOnly());
            return (ChannelAccessAlarmChar)super.clone();
        }

        /* synthetic */ ChannelAccessAlarmCharBase(ChannelAccessAlarmCharBase x0, 1 x1) {
            this(x0);
        }
    }

    public static final class ChannelAccessCharImpl
    extends ChannelAccessCharBase<ChannelAccessCharImpl>
    implements ChannelAccessSimpleOnlyChar {
        public ChannelAccessCharImpl(byte[] value) {
            super(value);
        }

        private ChannelAccessCharImpl(ChannelAccessCharImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessCharImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_CHAR;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessCharImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessSimpleOnlyChar asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessCharImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessCharImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessCharImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessCharImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessSimpleOnlyChar clone() {
            if (this.delegate != null) {
                return ((ChannelAccessCharImpl)this.delegate).clone();
            }
            return (ChannelAccessSimpleOnlyChar)super.clone();
        }

        public static ChannelAccessCharImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessCharImpl value = new ChannelAccessCharImpl();
            value.deserializeValue(byteSource, count);
            return value;
        }
    }
}

