/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value.internal;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.util.NullTerminatedStringUtil;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmDouble;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmOnlyDouble;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmSeverity;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmStatus;
import com.aquenos.epics.jackie.common.value.ChannelAccessControlsDouble;
import com.aquenos.epics.jackie.common.value.ChannelAccessDouble;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsDouble;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsOnlyDouble;
import com.aquenos.epics.jackie.common.value.ChannelAccessSimpleOnlyDouble;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeDouble;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeStamp;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueFactory;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessValueBase;
import com.aquenos.epics.jackie.common.value.internal.ValueCodecUtils;
import java.nio.DoubleBuffer;
import java.nio.charset.Charset;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class ChannelAccessDoubleBase<ImplementationType extends ChannelAccessDoubleBase<ImplementationType>>
extends ChannelAccessValueBase<Double, ImplementationType>
implements ChannelAccessDouble {
    protected double[] value;

    private ChannelAccessDoubleBase(double[] value) {
        assert (value != null);
        this.value = value;
    }

    private ChannelAccessDoubleBase(ImplementationType delegate) {
        super(delegate);
    }

    private ChannelAccessDoubleBase() {
    }

    @Override
    public int getValueSize() {
        if (this.delegate != null) {
            return ((ChannelAccessDoubleBase)this.delegate).getValueSize();
        }
        return this.value.length;
    }

    @Override
    public Double getGenericValueElement(int index) {
        if (this.delegate != null) {
            return ((ChannelAccessDoubleBase)this.delegate).getGenericValueElement(index);
        }
        return this.value[index];
    }

    @Override
    public DoubleBuffer getValue() {
        if (this.delegate != null) {
            return ((ChannelAccessDoubleBase)this.delegate).getValue().asReadOnlyBuffer();
        }
        return DoubleBuffer.wrap(this.value);
    }

    @Override
    public void setValue(double[] value) {
        if (this.delegate != null) {
            throw new UnsupportedOperationException("Cannot modify a read-only value.");
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    protected void deserializeValue(ByteSource byteSource, int count) {
        assert (count >= 0);
        this.value = count == 0 ? ArrayUtils.EMPTY_DOUBLE_ARRAY : byteSource.getDoubleArray(count);
    }

    protected void serializeValue(ByteSink byteSink, int count) {
        if (count != 0) {
            byteSink.putDoubleArray(this.value, 0, count);
        }
    }

    @Override
    public boolean equals(Object obj) {
        assert (!this.isReadOnly());
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessDoubleBase other = (ChannelAccessDoubleBase)obj;
        return new EqualsBuilder().append(this.value, other.value).isEquals();
    }

    @Override
    public int hashCode() {
        assert (!this.isReadOnly());
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.value).toHashCode();
    }

    @Override
    public ChannelAccessDouble clone() {
        assert (!this.isReadOnly());
        ChannelAccessDoubleBase copy = (ChannelAccessDoubleBase)super.clone();
        copy.value = (double[])this.value.clone();
        return copy;
    }

    /* synthetic */ ChannelAccessDoubleBase(ChannelAccessDoubleBase x0, 1 x1) {
        this(x0);
    }

    public static final class ChannelAccessControlsDoubleImpl
    extends ChannelAccessGraphicsDoubleBase<ChannelAccessControlsDoubleImpl>
    implements ChannelAccessControlsDouble {
        protected double upperControlLimit;
        protected double lowerControlLimit;

        public ChannelAccessControlsDoubleImpl(double[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, short precision, String engineeringUnits, double upperDisplayLimit, double lowerDisplayLimit, double upperAlarmLimit, double upperWarningLimit, double lowerWarningLimit, double lowerAlarmLimit, double upperControlLimit, double lowerControlLimit, Charset charset) {
            super(value, alarmStatus, alarmSeverity, precision, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, charset);
            this.upperControlLimit = upperControlLimit;
            this.lowerControlLimit = lowerControlLimit;
        }

        private ChannelAccessControlsDoubleImpl(ChannelAccessControlsDoubleImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessControlsDoubleImpl(Charset charset) {
            super(charset);
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_CTRL_DOUBLE;
        }

        @Override
        public Double getGenericUpperControlLimit() {
            return this.getUpperControlLimit();
        }

        @Override
        public Double getGenericLowerControlLimit() {
            return this.getLowerControlLimit();
        }

        @Override
        public double getUpperControlLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsDoubleImpl)this.delegate).getUpperControlLimit();
            }
            return this.upperControlLimit;
        }

        @Override
        public void setUpperControlLimit(double upperControlLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperControlLimit = upperControlLimit;
        }

        @Override
        public double getLowerControlLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsDoubleImpl)this.delegate).getLowerControlLimit();
            }
            return this.lowerControlLimit;
        }

        @Override
        public void setLowerControlLimit(double lowerControlLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerControlLimit = lowerControlLimit;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessControlsDoubleImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            this.serializeGraphics(byteSink);
            byteSink.putDouble(this.upperControlLimit);
            byteSink.putDouble(this.lowerControlLimit);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessControlsDouble asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessControlsDoubleImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessControlsDoubleImpl)this.delegate).equals(obj);
            }
            if (!super.equals(obj = ChannelAccessControlsDoubleImpl.extractDelegate(obj))) {
                return false;
            }
            ChannelAccessControlsDoubleImpl other = (ChannelAccessControlsDoubleImpl)obj;
            return new EqualsBuilder().append(this.upperControlLimit, other.upperControlLimit).append(this.lowerControlLimit, other.lowerControlLimit).isEquals();
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsDoubleImpl)this.delegate).hashCode();
            }
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.upperControlLimit).append(this.lowerControlLimit).toHashCode();
        }

        @Override
        public ChannelAccessControlsDouble clone() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsDoubleImpl)this.delegate).clone();
            }
            return (ChannelAccessControlsDouble)super.clone();
        }

        public static ChannelAccessControlsDoubleImpl deserialize(ByteSource byteSource, int count, Charset charset) {
            ChannelAccessControlsDoubleImpl value = new ChannelAccessControlsDoubleImpl(charset);
            value.deserializeAlarms(byteSource);
            value.deserializeGraphics(byteSource);
            value.upperControlLimit = byteSource.getDouble();
            value.lowerControlLimit = byteSource.getDouble();
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static final class ChannelAccessGraphicsDoubleImpl
    extends ChannelAccessGraphicsDoubleBase<ChannelAccessGraphicsDoubleImpl>
    implements ChannelAccessGraphicsOnlyDouble {
        public ChannelAccessGraphicsDoubleImpl(double[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, short precision, String engineeringUnits, double upperDisplayLimit, double lowerDisplayLimit, double upperAlarmLimit, double upperWarningLimit, double lowerWarningLimit, double lowerAlarmLimit, Charset charset) {
            super(value, alarmStatus, alarmSeverity, precision, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, charset);
        }

        private ChannelAccessGraphicsDoubleImpl(ChannelAccessGraphicsDoubleImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessGraphicsDoubleImpl(Charset charset) {
            super(charset);
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_GR_DOUBLE;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessGraphicsDoubleImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            this.serializeGraphics(byteSink);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessGraphicsOnlyDouble asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessGraphicsDoubleImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsDoubleImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessGraphicsDoubleImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsDoubleImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessGraphicsOnlyDouble clone() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsDoubleImpl)this.delegate).clone();
            }
            return (ChannelAccessGraphicsOnlyDouble)super.clone();
        }

        public static ChannelAccessGraphicsDoubleImpl deserialize(ByteSource byteSource, int count, Charset charset) {
            ChannelAccessGraphicsDoubleImpl value = new ChannelAccessGraphicsDoubleImpl(charset);
            value.deserializeAlarms(byteSource);
            value.deserializeGraphics(byteSource);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static abstract class ChannelAccessGraphicsDoubleBase<ImplementationType extends ChannelAccessGraphicsDoubleBase<ImplementationType>>
    extends ChannelAccessAlarmDoubleBase<ImplementationType>
    implements ChannelAccessGraphicsDouble {
        private static final int ENGINEERING_UNITS_STRING_SIZE = 8;
        protected String engineeringUnits;
        protected byte[] rawEngineeringUnits;
        protected double upperDisplayLimit;
        protected double lowerDisplayLimit;
        protected double upperAlarmLimit;
        protected double upperWarningLimit;
        protected double lowerWarningLimit;
        protected double lowerAlarmLimit;
        protected short precision;
        protected Charset charset;

        private ChannelAccessGraphicsDoubleBase(double[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, short precision, String engineeringUnits, double upperDisplayLimit, double lowerDisplayLimit, double upperAlarmLimit, double upperWarningLimit, double lowerWarningLimit, double lowerAlarmLimit, Charset charset) {
            super(value, alarmStatus, alarmSeverity);
            this.precision = precision;
            this.engineeringUnits = engineeringUnits;
            assert (charset != null);
            this.charset = charset;
            this.rawEngineeringUnits = NullTerminatedStringUtil.stringToTruncatedNullTerminatedFixedBytes(this.engineeringUnits, 8, charset);
            this.upperDisplayLimit = upperDisplayLimit;
            this.lowerDisplayLimit = lowerDisplayLimit;
            this.upperAlarmLimit = upperAlarmLimit;
            this.upperWarningLimit = upperWarningLimit;
            this.lowerWarningLimit = lowerWarningLimit;
            this.lowerAlarmLimit = lowerAlarmLimit;
        }

        private ChannelAccessGraphicsDoubleBase(ImplementationType delegate) {
            super((ChannelAccessAlarmDoubleBase)delegate, null);
        }

        private ChannelAccessGraphicsDoubleBase(Charset charset) {
            this.charset = charset;
        }

        @Override
        public String getUnits() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsDoubleBase)this.delegate).getUnits();
            }
            return this.engineeringUnits;
        }

        @Override
        public byte[] getRawUnits() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsDoubleBase)this.delegate).getRawUnits();
            }
            return (byte[])this.rawEngineeringUnits.clone();
        }

        @Override
        public void setUnits(String units) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.engineeringUnits = units;
            this.rawEngineeringUnits = NullTerminatedStringUtil.stringToTruncatedNullTerminatedFixedBytes(this.engineeringUnits, 8, this.charset);
        }

        @Override
        public void setRawUnits(byte[] rawUnits) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.rawEngineeringUnits = new byte[8];
            int copyLength = Math.min(rawUnits.length, 7);
            System.arraycopy(rawUnits, 0, this.rawEngineeringUnits, 0, copyLength);
            this.engineeringUnits = NullTerminatedStringUtil.nullTerminatedBytesToString(this.rawEngineeringUnits, this.charset);
        }

        @Override
        public Double getGenericUpperDisplayLimit() {
            return this.getUpperDisplayLimit();
        }

        @Override
        public Double getGenericLowerDisplayLimit() {
            return this.getLowerDisplayLimit();
        }

        @Override
        public Double getGenericUpperAlarmLimit() {
            return this.getUpperAlarmLimit();
        }

        @Override
        public Double getGenericUpperWarningLimit() {
            return this.getUpperWarningLimit();
        }

        @Override
        public Double getGenericLowerWarningLimit() {
            return this.getLowerWarningLimit();
        }

        @Override
        public Double getGenericLowerAlarmLimit() {
            return this.getLowerAlarmLimit();
        }

        @Override
        public Charset getCharset() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsDoubleBase)this.delegate).getCharset();
            }
            return this.charset;
        }

        @Override
        public double getUpperDisplayLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsDoubleBase)this.delegate).getUpperDisplayLimit();
            }
            return this.upperDisplayLimit;
        }

        @Override
        public void setUpperDisplayLimit(double upperDisplayLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperDisplayLimit = upperDisplayLimit;
        }

        @Override
        public double getLowerDisplayLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsDoubleBase)this.delegate).getLowerDisplayLimit();
            }
            return this.lowerDisplayLimit;
        }

        @Override
        public void setLowerDisplayLimit(double lowerDisplayLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerDisplayLimit = lowerDisplayLimit;
        }

        @Override
        public double getUpperAlarmLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsDoubleBase)this.delegate).getUpperAlarmLimit();
            }
            return this.upperAlarmLimit;
        }

        @Override
        public void setUpperAlarmLimit(double upperAlarmLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperAlarmLimit = upperAlarmLimit;
        }

        @Override
        public double getUpperWarningLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsDoubleBase)this.delegate).getUpperWarningLimit();
            }
            return this.upperWarningLimit;
        }

        @Override
        public void setUpperWarningLimit(double upperWarningLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperWarningLimit = upperWarningLimit;
        }

        @Override
        public double getLowerWarningLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsDoubleBase)this.delegate).getLowerWarningLimit();
            }
            return this.lowerWarningLimit;
        }

        @Override
        public void setLowerWarningLimit(double lowerWarningLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerWarningLimit = lowerWarningLimit;
        }

        @Override
        public double getLowerAlarmLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsDoubleBase)this.delegate).getLowerAlarmLimit();
            }
            return this.lowerAlarmLimit;
        }

        @Override
        public void setLowerAlarmLimit(double lowerAlarmLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerAlarmLimit = lowerAlarmLimit;
        }

        @Override
        public short getPrecision() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsDoubleBase)this.delegate).getPrecision();
            }
            return this.precision;
        }

        @Override
        public void setPrecision(short precision) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.precision = precision;
        }

        protected void deserializeGraphics(ByteSource byteSource) {
            this.precision = byteSource.getShort();
            byteSource.skip(2);
            this.rawEngineeringUnits = byteSource.getByteArray(8);
            this.rawEngineeringUnits[7] = 0;
            this.engineeringUnits = NullTerminatedStringUtil.nullTerminatedBytesToString(this.rawEngineeringUnits, this.charset);
            this.upperDisplayLimit = byteSource.getDouble();
            this.lowerDisplayLimit = byteSource.getDouble();
            this.upperAlarmLimit = byteSource.getDouble();
            this.upperWarningLimit = byteSource.getDouble();
            this.lowerWarningLimit = byteSource.getDouble();
            this.lowerAlarmLimit = byteSource.getDouble();
        }

        protected void serializeGraphics(ByteSink byteSink) {
            byteSink.putShort(this.precision);
            byteSink.putShort((short)0);
            byteSink.putByteArray(this.rawEngineeringUnits);
            byteSink.putDouble(this.upperDisplayLimit);
            byteSink.putDouble(this.lowerDisplayLimit);
            byteSink.putDouble(this.upperAlarmLimit);
            byteSink.putDouble(this.upperWarningLimit);
            byteSink.putDouble(this.lowerWarningLimit);
            byteSink.putDouble(this.lowerAlarmLimit);
        }

        @Override
        public boolean equals(Object obj) {
            assert (!this.isReadOnly());
            if (!super.equals(obj)) {
                return false;
            }
            ChannelAccessGraphicsDoubleBase other = (ChannelAccessGraphicsDoubleBase)obj;
            return new EqualsBuilder().append(this.precision, other.precision).append((Object)this.engineeringUnits, (Object)other.engineeringUnits).append(this.rawEngineeringUnits, other.rawEngineeringUnits).append(this.upperDisplayLimit, other.upperDisplayLimit).append(this.lowerDisplayLimit, other.lowerDisplayLimit).append(this.upperAlarmLimit, other.upperAlarmLimit).append(this.upperWarningLimit, other.upperWarningLimit).append(this.lowerWarningLimit, other.lowerWarningLimit).append(this.lowerAlarmLimit, other.lowerAlarmLimit).append((Object)this.charset, (Object)other.charset).isEquals();
        }

        @Override
        public int hashCode() {
            assert (!this.isReadOnly());
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.precision).append((Object)this.engineeringUnits).append(this.rawEngineeringUnits).append(this.upperDisplayLimit).append(this.lowerDisplayLimit).append(this.upperAlarmLimit).append(this.upperWarningLimit).append(this.lowerWarningLimit).append(this.lowerAlarmLimit).append((Object)this.charset).toHashCode();
        }

        @Override
        public ChannelAccessGraphicsDouble clone() {
            assert (!this.isReadOnly());
            return (ChannelAccessGraphicsDouble)super.clone();
        }

        /* synthetic */ ChannelAccessGraphicsDoubleBase(ChannelAccessGraphicsDoubleBase x0, 1 x1) {
            this(x0);
        }
    }

    public static final class ChannelAccessTimeDoubleImpl
    extends ChannelAccessAlarmDoubleBase<ChannelAccessTimeDoubleImpl>
    implements ChannelAccessTimeDouble {
        protected int timeStampSeconds;
        protected int timeStampNanoseconds;

        public ChannelAccessTimeDoubleImpl(double[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, int timeStampSeconds, int timeStampNanoSeconds) {
            super(value, alarmStatus, alarmSeverity);
            this.timeStampSeconds = timeStampSeconds;
            if (timeStampNanoSeconds < 0 || timeStampNanoSeconds > 999999999) {
                throw new IllegalArgumentException("Nanoseconds part of timestamp must be a number between 0 and 999999999.");
            }
            this.timeStampNanoseconds = timeStampNanoSeconds;
        }

        private ChannelAccessTimeDoubleImpl(ChannelAccessTimeDoubleImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessTimeDoubleImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_TIME_DOUBLE;
        }

        @Override
        public ChannelAccessTimeStamp getTimeStamp() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeDoubleImpl)this.delegate).getTimeStamp();
            }
            return ChannelAccessValueFactory.createTimeStamp(this.timeStampSeconds, this.timeStampNanoseconds);
        }

        @Override
        public int getTimeSeconds() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeDoubleImpl)this.delegate).getTimeSeconds();
            }
            return this.timeStampSeconds;
        }

        @Override
        public int getTimeNanoseconds() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeDoubleImpl)this.delegate).getTimeNanoseconds();
            }
            return this.timeStampNanoseconds;
        }

        @Override
        public void setTimeStamp(ChannelAccessTimeStamp timeStamp) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.timeStampSeconds = timeStamp.getSeconds();
            this.timeStampNanoseconds = timeStamp.getNanoseconds();
        }

        @Override
        public void setTimeSeconds(int timeStampSeconds) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.timeStampSeconds = timeStampSeconds;
        }

        @Override
        public void setTimeNanoseconds(int timeStampNanoseconds) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            if (timeStampNanoseconds < 0 || timeStampNanoseconds > 999999999) {
                throw new IllegalArgumentException("Nanoseconds part of time-stamp must be a number between 0 and 999999999.");
            }
            this.timeStampNanoseconds = timeStampNanoseconds;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessTimeDoubleImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            ValueCodecUtils.serializeTime(byteSink, this.timeStampSeconds, this.timeStampNanoseconds);
            byteSink.putInt(0);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessTimeDouble asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessTimeDoubleImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessTimeDoubleImpl)this.delegate).equals(obj);
            }
            if (!super.equals(obj = ChannelAccessTimeDoubleImpl.extractDelegate(obj))) {
                return false;
            }
            ChannelAccessTimeDoubleImpl other = (ChannelAccessTimeDoubleImpl)obj;
            return new EqualsBuilder().append(this.timeStampSeconds, other.timeStampSeconds).append(this.timeStampNanoseconds, other.timeStampNanoseconds).isEquals();
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeDoubleImpl)this.delegate).hashCode();
            }
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.timeStampSeconds).append(this.timeStampNanoseconds).toHashCode();
        }

        @Override
        public ChannelAccessTimeDouble clone() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeDoubleImpl)this.delegate).clone();
            }
            return (ChannelAccessTimeDouble)super.clone();
        }

        public static ChannelAccessTimeDoubleImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessTimeDoubleImpl value = new ChannelAccessTimeDoubleImpl();
            value.deserializeAlarms(byteSource);
            value.timeStampSeconds = ValueCodecUtils.deserializeTimeSeconds(byteSource);
            value.timeStampNanoseconds = ValueCodecUtils.deserializeTimeNanoseconds(byteSource);
            byteSource.skip(4);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static final class ChannelAccessAlarmDoubleImpl
    extends ChannelAccessAlarmDoubleBase<ChannelAccessAlarmDoubleImpl>
    implements ChannelAccessAlarmOnlyDouble {
        public ChannelAccessAlarmDoubleImpl(double[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity) {
            super(value, alarmStatus, alarmSeverity);
        }

        private ChannelAccessAlarmDoubleImpl(ChannelAccessAlarmDoubleImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessAlarmDoubleImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_STS_DOUBLE;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessAlarmDoubleImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            byteSink.putInt(0);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessAlarmOnlyDouble asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessAlarmDoubleImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmDoubleImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessAlarmDoubleImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmDoubleImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessAlarmOnlyDouble clone() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmDoubleImpl)this.delegate).clone();
            }
            return (ChannelAccessAlarmOnlyDouble)super.clone();
        }

        public static ChannelAccessAlarmDoubleImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessAlarmDoubleImpl value = new ChannelAccessAlarmDoubleImpl();
            value.deserializeAlarms(byteSource);
            byteSource.skip(4);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static abstract class ChannelAccessAlarmDoubleBase<ImplementationType extends ChannelAccessAlarmDoubleBase<ImplementationType>>
    extends ChannelAccessDoubleBase<ImplementationType>
    implements ChannelAccessAlarmDouble {
        protected ChannelAccessAlarmStatus alarmStatus;
        protected ChannelAccessAlarmSeverity alarmSeverity;

        private ChannelAccessAlarmDoubleBase(double[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity) {
            super(value);
            this.alarmStatus = alarmStatus;
            this.alarmSeverity = alarmSeverity;
        }

        private ChannelAccessAlarmDoubleBase(ImplementationType delegate) {
            super((ChannelAccessDoubleBase)delegate, null);
        }

        private ChannelAccessAlarmDoubleBase() {
        }

        @Override
        public ChannelAccessAlarmStatus getAlarmStatus() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmDoubleBase)this.delegate).getAlarmStatus();
            }
            return this.alarmStatus;
        }

        @Override
        public void setAlarmStatus(ChannelAccessAlarmStatus alarmStatus) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            assert (alarmStatus != null);
            this.alarmStatus = alarmStatus;
        }

        @Override
        public ChannelAccessAlarmSeverity getAlarmSeverity() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmDoubleBase)this.delegate).getAlarmSeverity();
            }
            return this.alarmSeverity;
        }

        @Override
        public void setAlarmSeverity(ChannelAccessAlarmSeverity alarmSeverity) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            assert (alarmSeverity != null);
            this.alarmSeverity = alarmSeverity;
        }

        protected void deserializeAlarms(ByteSource byteSource) {
            this.alarmStatus = ValueCodecUtils.deserializeAlarmStatus(byteSource);
            this.alarmSeverity = ValueCodecUtils.deserializeAlarmSeverity(byteSource);
        }

        protected void serializeAlarms(ByteSink byteSink) {
            ValueCodecUtils.serializeAlarms(byteSink, this.alarmStatus, this.alarmSeverity);
        }

        @Override
        public boolean equals(Object obj) {
            assert (!this.isReadOnly());
            if (!super.equals(obj)) {
                return false;
            }
            ChannelAccessAlarmDoubleBase other = (ChannelAccessAlarmDoubleBase)obj;
            return new EqualsBuilder().append((Object)this.alarmStatus, (Object)other.alarmStatus).append((Object)this.alarmSeverity, (Object)other.alarmSeverity).isEquals();
        }

        @Override
        public int hashCode() {
            assert (!this.isReadOnly());
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.alarmStatus).append((Object)this.alarmSeverity).toHashCode();
        }

        @Override
        public ChannelAccessAlarmDouble clone() {
            assert (!this.isReadOnly());
            return (ChannelAccessAlarmDouble)super.clone();
        }

        /* synthetic */ ChannelAccessAlarmDoubleBase(ChannelAccessAlarmDoubleBase x0, 1 x1) {
            this(x0);
        }
    }

    public static final class ChannelAccessDoubleImpl
    extends ChannelAccessDoubleBase<ChannelAccessDoubleImpl>
    implements ChannelAccessSimpleOnlyDouble {
        public ChannelAccessDoubleImpl(double[] value) {
            super(value);
        }

        private ChannelAccessDoubleImpl(ChannelAccessDoubleImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessDoubleImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_DOUBLE;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessDoubleImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessSimpleOnlyDouble asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessDoubleImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessDoubleImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessDoubleImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessDoubleImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessSimpleOnlyDouble clone() {
            if (this.delegate != null) {
                return ((ChannelAccessDoubleImpl)this.delegate).clone();
            }
            return (ChannelAccessSimpleOnlyDouble)super.clone();
        }

        public static ChannelAccessDoubleImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessDoubleImpl value = new ChannelAccessDoubleImpl();
            value.deserializeValue(byteSource, count);
            return value;
        }
    }
}

