/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value.internal;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.util.NullTerminatedStringUtil;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmEnum;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmOnlyEnum;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmSeverity;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmStatus;
import com.aquenos.epics.jackie.common.value.ChannelAccessEnum;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsEnum;
import com.aquenos.epics.jackie.common.value.ChannelAccessSimpleOnlyEnum;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeEnum;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeStamp;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueFactory;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessValueBase;
import com.aquenos.epics.jackie.common.value.internal.ValueCodecUtils;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class ChannelAccessEnumBase<ImplementationType extends ChannelAccessEnumBase<ImplementationType>>
extends ChannelAccessValueBase<Short, ImplementationType>
implements ChannelAccessEnum {
    protected short[] value;

    private ChannelAccessEnumBase(short[] value) {
        assert (value != null);
        this.value = value;
    }

    private ChannelAccessEnumBase(ImplementationType delegate) {
        super(delegate);
    }

    private ChannelAccessEnumBase() {
    }

    @Override
    public int getValueSize() {
        if (this.delegate != null) {
            return ((ChannelAccessEnumBase)this.delegate).getValueSize();
        }
        return this.value.length;
    }

    @Override
    public Short getGenericValueElement(int index) {
        if (this.delegate != null) {
            return ((ChannelAccessEnumBase)this.delegate).getGenericValueElement(index);
        }
        return this.value[index];
    }

    @Override
    public ShortBuffer getValue() {
        if (this.delegate != null) {
            return ((ChannelAccessEnumBase)this.delegate).getValue().asReadOnlyBuffer();
        }
        return ShortBuffer.wrap(this.value);
    }

    @Override
    public void setValue(short[] value) {
        if (this.delegate != null) {
            throw new UnsupportedOperationException("Cannot modify a read-only value.");
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    protected void deserializeValue(ByteSource byteSource, int count) {
        assert (count >= 0);
        this.value = count == 0 ? ArrayUtils.EMPTY_SHORT_ARRAY : byteSource.getShortArray(count);
    }

    protected void serializeValue(ByteSink byteSink, int count) {
        if (count != 0) {
            byteSink.putShortArray(this.value, 0, count);
        }
    }

    @Override
    public boolean equals(Object obj) {
        assert (!this.isReadOnly());
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessEnumBase other = (ChannelAccessEnumBase)obj;
        return new EqualsBuilder().append(this.value, other.value).isEquals();
    }

    @Override
    public int hashCode() {
        assert (!this.isReadOnly());
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.value).toHashCode();
    }

    @Override
    public ChannelAccessEnum clone() {
        assert (!this.isReadOnly());
        ChannelAccessEnumBase copy = (ChannelAccessEnumBase)super.clone();
        copy.value = (short[])this.value.clone();
        return copy;
    }

    /* synthetic */ ChannelAccessEnumBase(ChannelAccessEnumBase x0, 1 x1) {
        this(x0);
    }

    public static final class ChannelAccessGraphicsEnumImpl
    extends ChannelAccessAlarmEnumBase<ChannelAccessGraphicsEnumImpl>
    implements ChannelAccessGraphicsEnum {
        private static final int MAX_NUM_LABELS = 16;
        private static final int LABEL_STRING_SIZE = 26;
        private static final int TOTAL_LABEL_BYTES = 416;
        private static final byte[] EMPTY_RAW_LABEL = new byte[26];
        private static final byte[] EMPTY_RAW_LABELS = new byte[416];
        protected ChannelAccessValueType type;
        protected ArrayList<String> labels;
        protected byte[] rawLabels;
        protected Charset charset;

        public ChannelAccessGraphicsEnumImpl(ChannelAccessValueType type, short[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, Collection<String> labels, Charset charset) {
            super(value, alarmStatus, alarmSeverity);
            assert (type == ChannelAccessValueType.DBR_GR_ENUM || type == ChannelAccessValueType.DBR_CTRL_ENUM);
            this.type = type;
            assert (charset != null);
            this.charset = charset;
            int numberOfLabels = labels.size();
            if (numberOfLabels > 16) {
                throw new IllegalArgumentException("The number of labels is limited to 16.");
            }
            this.labels = new ArrayList(16);
            this.rawLabels = new byte[416];
            int labelIndex = 0;
            for (String label : labels) {
                if (label == null) {
                    throw new NullPointerException();
                }
                this.labels.add(label);
                this.updateRawLabel(labelIndex, label);
                ++labelIndex;
            }
        }

        private ChannelAccessGraphicsEnumImpl(ChannelAccessGraphicsEnumImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessGraphicsEnumImpl(ChannelAccessValueType type, Charset charset) {
            this.type = type;
            this.charset = charset;
        }

        @Override
        public ChannelAccessValueType getType() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsEnumImpl)this.delegate).getType();
            }
            return this.type;
        }

        @Override
        public List<String> getLabels() {
            if (this.delegate != null) {
                return Collections.unmodifiableList(((ChannelAccessGraphicsEnumImpl)this.delegate).getLabels());
            }
            return new WrappedStringList();
        }

        @Override
        public void setLabels(Collection<String> labels) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            if (labels.size() > 16) {
                throw new IllegalArgumentException("An enum cannot have more than 16 labels.");
            }
            for (String element : labels) {
                if (element != null) continue;
                throw new NullPointerException();
            }
            this.labels.clear();
            int labelIndex = 0;
            for (String label : labels) {
                this.labels.add(label);
                this.updateRawLabel(labelIndex, label);
                ++labelIndex;
            }
        }

        private void updateRawLabel(int labelIndex, String newLabel) {
            byte[] rawLabel = NullTerminatedStringUtil.stringToTruncatedNullTerminatedFixedBytes(newLabel, 26, this.charset);
            System.arraycopy(rawLabel, 0, this.rawLabels, labelIndex * 26, 26);
        }

        @Override
        public byte[] getRawLabels() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsEnumImpl)this.delegate).getRawLabels();
            }
            return (byte[])this.rawLabels.clone();
        }

        @Override
        public void setRawLabels(byte[] rawLabels, int numberOfLabels) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            if (numberOfLabels < 0 || numberOfLabels > 16) {
                throw new IllegalArgumentException("Number of labels must be between 0 and 16.");
            }
            if (rawLabels.length != 416) {
                throw new IllegalArgumentException("Raw representation of enum labels must have exactly 416 bytes.");
            }
            LinkedList<String> newLabels = new LinkedList<String>();
            for (int labelIndex = 0; labelIndex < numberOfLabels; ++labelIndex) {
                newLabels.add(NullTerminatedStringUtil.nullTerminatedBytesToString(rawLabels, labelIndex * 26, 26, this.charset, true));
            }
            System.arraycopy(rawLabels, 0, this.rawLabels, 0, 416);
            this.labels.clear();
            this.labels.addAll(newLabels);
        }

        @Override
        public Charset getCharset() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsEnumImpl)this.delegate).getCharset();
            }
            return this.charset;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessGraphicsEnumImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            byteSink.putShort((short)this.labels.size());
            byteSink.putByteArray(this.rawLabels);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessGraphicsEnum asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessGraphicsEnumImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsEnumImpl)this.delegate).equals(obj);
            }
            if (!super.equals(obj = ChannelAccessGraphicsEnumImpl.extractDelegate(obj))) {
                return false;
            }
            ChannelAccessGraphicsEnumImpl other = (ChannelAccessGraphicsEnumImpl)obj;
            return new EqualsBuilder().append((Object)this.type, (Object)other.type).append(this.labels, other.labels).append(this.rawLabels, other.rawLabels).append((Object)this.charset, (Object)other.charset).isEquals();
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsEnumImpl)this.delegate).hashCode();
            }
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.type).append(this.labels).append(this.rawLabels).append((Object)this.charset).toHashCode();
        }

        @Override
        public ChannelAccessGraphicsEnum clone() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsEnumImpl)this.delegate).clone();
            }
            ChannelAccessGraphicsEnumImpl copy = (ChannelAccessGraphicsEnumImpl)super.clone();
            copy.labels = (ArrayList)this.labels.clone();
            copy.rawLabels = (byte[])this.rawLabels.clone();
            return copy;
        }

        public static ChannelAccessGraphicsEnumImpl deserialize(ChannelAccessValueType type, ByteSource byteSource, int count, Charset charset) {
            ChannelAccessGraphicsEnumImpl value = new ChannelAccessGraphicsEnumImpl(type, charset);
            value.deserializeAlarms(byteSource);
            int numberOfLabels = byteSource.getShort();
            if (numberOfLabels < 0 || numberOfLabels > 16) {
                numberOfLabels = 16;
            }
            byte[] rawLabels = byteSource.getByteArray(416);
            ArrayList<String> labels = new ArrayList<String>(16);
            for (int labelIndex = 0; labelIndex < numberOfLabels; ++labelIndex) {
                rawLabels[(labelIndex + 1) * 26 - 1] = 0;
                labels.add(NullTerminatedStringUtil.nullTerminatedBytesToString(rawLabels, labelIndex * 26, 26, charset, true));
            }
            value.rawLabels = rawLabels;
            value.labels = labels;
            value.deserializeValue(byteSource, count);
            return value;
        }

        private class WrappedStringList
        extends AbstractList<String> {
            private WrappedStringList() {
            }

            @Override
            public String get(int index) {
                return ChannelAccessGraphicsEnumImpl.this.labels.get(index);
            }

            @Override
            public int size() {
                return ChannelAccessGraphicsEnumImpl.this.labels.size();
            }

            @Override
            public String set(int index, String element) {
                if (element == null) {
                    throw new NullPointerException();
                }
                String old = ChannelAccessGraphicsEnumImpl.this.labels.set(index, element);
                ChannelAccessGraphicsEnumImpl.this.updateRawLabel(index, element);
                return old;
            }

            @Override
            public void add(int index, String element) {
                if (ChannelAccessGraphicsEnumImpl.this.labels.size() == 16) {
                    throw new IllegalStateException("The list cannot contain more than 16 labels.");
                }
                if (element == null) {
                    throw new NullPointerException();
                }
                ChannelAccessGraphicsEnumImpl.this.labels.add(index, element);
                int numberOfLabels = ChannelAccessGraphicsEnumImpl.this.labels.size();
                for (int labelIndex = index; labelIndex < numberOfLabels; ++labelIndex) {
                    ChannelAccessGraphicsEnumImpl.this.updateRawLabel(labelIndex, ChannelAccessGraphicsEnumImpl.this.labels.get(labelIndex));
                }
            }

            @Override
            public String remove(int index) {
                String removed = ChannelAccessGraphicsEnumImpl.this.labels.remove(index);
                int numberOfLabels = ChannelAccessGraphicsEnumImpl.this.labels.size();
                for (int labelIndex = index; labelIndex < numberOfLabels; ++labelIndex) {
                    ChannelAccessGraphicsEnumImpl.this.updateRawLabel(labelIndex, ChannelAccessGraphicsEnumImpl.this.labels.get(labelIndex));
                }
                System.arraycopy(EMPTY_RAW_LABEL, 0, ChannelAccessGraphicsEnumImpl.this.rawLabels, numberOfLabels * 26, 26);
                return removed;
            }

            @Override
            public void clear() {
                ChannelAccessGraphicsEnumImpl.this.labels.clear();
                System.arraycopy(EMPTY_RAW_LABELS, 0, ChannelAccessGraphicsEnumImpl.this.rawLabels, 16, 416);
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                return this.addAll(ChannelAccessGraphicsEnumImpl.this.labels.size(), c);
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                if (c.size() + ChannelAccessGraphicsEnumImpl.this.labels.size() > 16) {
                    throw new IllegalStateException("The list cannot contain more than 16 labels.");
                }
                for (String string : c) {
                    if (string != null) continue;
                    throw new NullPointerException();
                }
                boolean modified = ChannelAccessGraphicsEnumImpl.this.labels.addAll(index, c);
                if (modified) {
                    int n = ChannelAccessGraphicsEnumImpl.this.labels.size();
                    for (int stringIndex = index; stringIndex < n; ++stringIndex) {
                        ChannelAccessGraphicsEnumImpl.this.updateRawLabel(stringIndex, ChannelAccessGraphicsEnumImpl.this.labels.get(stringIndex));
                    }
                }
                return modified;
            }

            @Override
            public Object[] toArray() {
                return ChannelAccessGraphicsEnumImpl.this.labels.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return ChannelAccessGraphicsEnumImpl.this.labels.toArray(a);
            }
        }
    }

    public static final class ChannelAccessTimeEnumImpl
    extends ChannelAccessAlarmEnumBase<ChannelAccessTimeEnumImpl>
    implements ChannelAccessTimeEnum {
        protected int timeStampSeconds;
        protected int timeStampNanoseconds;

        public ChannelAccessTimeEnumImpl(short[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, int timeStampSeconds, int timeStampNanoSeconds) {
            super(value, alarmStatus, alarmSeverity);
            this.timeStampSeconds = timeStampSeconds;
            if (timeStampNanoSeconds < 0 || timeStampNanoSeconds > 999999999) {
                throw new IllegalArgumentException("Nanoseconds part of timestamp must be a number between 0 and 999999999.");
            }
            this.timeStampNanoseconds = timeStampNanoSeconds;
        }

        private ChannelAccessTimeEnumImpl(ChannelAccessTimeEnumImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessTimeEnumImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_TIME_ENUM;
        }

        @Override
        public ChannelAccessTimeStamp getTimeStamp() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeEnumImpl)this.delegate).getTimeStamp();
            }
            return ChannelAccessValueFactory.createTimeStamp(this.timeStampSeconds, this.timeStampNanoseconds);
        }

        @Override
        public int getTimeSeconds() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeEnumImpl)this.delegate).getTimeSeconds();
            }
            return this.timeStampSeconds;
        }

        @Override
        public int getTimeNanoseconds() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeEnumImpl)this.delegate).getTimeNanoseconds();
            }
            return this.timeStampNanoseconds;
        }

        @Override
        public void setTimeStamp(ChannelAccessTimeStamp timeStamp) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.timeStampSeconds = timeStamp.getSeconds();
            this.timeStampNanoseconds = timeStamp.getNanoseconds();
        }

        @Override
        public void setTimeSeconds(int timeStampSeconds) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.timeStampSeconds = timeStampSeconds;
        }

        @Override
        public void setTimeNanoseconds(int timeStampNanoseconds) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            if (timeStampNanoseconds < 0 || timeStampNanoseconds > 999999999) {
                throw new IllegalArgumentException("Nanoseconds part of time-stamp must be a number between 0 and 999999999.");
            }
            this.timeStampNanoseconds = timeStampNanoseconds;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessTimeEnumImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            ValueCodecUtils.serializeTime(byteSink, this.timeStampSeconds, this.timeStampNanoseconds);
            byteSink.putShort((short)0);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessTimeEnum asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessTimeEnumImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessTimeEnumImpl)this.delegate).equals(obj);
            }
            if (!super.equals(obj = ChannelAccessTimeEnumImpl.extractDelegate(obj))) {
                return false;
            }
            ChannelAccessTimeEnumImpl other = (ChannelAccessTimeEnumImpl)obj;
            return new EqualsBuilder().append(this.timeStampSeconds, other.timeStampSeconds).append(this.timeStampNanoseconds, other.timeStampNanoseconds).isEquals();
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeEnumImpl)this.delegate).hashCode();
            }
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.timeStampSeconds).append(this.timeStampNanoseconds).toHashCode();
        }

        @Override
        public ChannelAccessTimeEnum clone() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeEnumImpl)this.delegate).clone();
            }
            return (ChannelAccessTimeEnum)super.clone();
        }

        public static ChannelAccessTimeEnumImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessTimeEnumImpl value = new ChannelAccessTimeEnumImpl();
            value.deserializeAlarms(byteSource);
            value.timeStampSeconds = ValueCodecUtils.deserializeTimeSeconds(byteSource);
            value.timeStampNanoseconds = ValueCodecUtils.deserializeTimeNanoseconds(byteSource);
            byteSource.skip(2);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static final class ChannelAccessAlarmEnumImpl
    extends ChannelAccessAlarmEnumBase<ChannelAccessAlarmEnumImpl>
    implements ChannelAccessAlarmOnlyEnum {
        public ChannelAccessAlarmEnumImpl(short[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity) {
            super(value, alarmStatus, alarmSeverity);
        }

        private ChannelAccessAlarmEnumImpl(ChannelAccessAlarmEnumImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessAlarmEnumImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_STS_ENUM;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessAlarmEnumImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessAlarmOnlyEnum asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessAlarmEnumImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmEnumImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessAlarmEnumImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmEnumImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessAlarmOnlyEnum clone() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmEnumImpl)this.delegate).clone();
            }
            return (ChannelAccessAlarmOnlyEnum)super.clone();
        }

        public static ChannelAccessAlarmEnumImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessAlarmEnumImpl value = new ChannelAccessAlarmEnumImpl();
            value.deserializeAlarms(byteSource);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static abstract class ChannelAccessAlarmEnumBase<ImplementationType extends ChannelAccessAlarmEnumBase<ImplementationType>>
    extends ChannelAccessEnumBase<ImplementationType>
    implements ChannelAccessAlarmEnum {
        protected ChannelAccessAlarmStatus alarmStatus;
        protected ChannelAccessAlarmSeverity alarmSeverity;

        private ChannelAccessAlarmEnumBase(short[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity) {
            super(value);
            this.alarmStatus = alarmStatus;
            this.alarmSeverity = alarmSeverity;
        }

        private ChannelAccessAlarmEnumBase(ImplementationType delegate) {
            super((ChannelAccessEnumBase)delegate, null);
        }

        private ChannelAccessAlarmEnumBase() {
        }

        @Override
        public ChannelAccessAlarmStatus getAlarmStatus() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmEnumBase)this.delegate).getAlarmStatus();
            }
            return this.alarmStatus;
        }

        @Override
        public void setAlarmStatus(ChannelAccessAlarmStatus alarmStatus) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            assert (alarmStatus != null);
            this.alarmStatus = alarmStatus;
        }

        @Override
        public ChannelAccessAlarmSeverity getAlarmSeverity() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmEnumBase)this.delegate).getAlarmSeverity();
            }
            return this.alarmSeverity;
        }

        @Override
        public void setAlarmSeverity(ChannelAccessAlarmSeverity alarmSeverity) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            assert (alarmSeverity != null);
            this.alarmSeverity = alarmSeverity;
        }

        protected void deserializeAlarms(ByteSource byteSource) {
            this.alarmStatus = ValueCodecUtils.deserializeAlarmStatus(byteSource);
            this.alarmSeverity = ValueCodecUtils.deserializeAlarmSeverity(byteSource);
        }

        protected void serializeAlarms(ByteSink byteSink) {
            ValueCodecUtils.serializeAlarms(byteSink, this.alarmStatus, this.alarmSeverity);
        }

        @Override
        public boolean equals(Object obj) {
            assert (!this.isReadOnly());
            if (!super.equals(obj)) {
                return false;
            }
            ChannelAccessAlarmEnumBase other = (ChannelAccessAlarmEnumBase)obj;
            return new EqualsBuilder().append((Object)this.alarmStatus, (Object)other.alarmStatus).append((Object)this.alarmSeverity, (Object)other.alarmSeverity).isEquals();
        }

        @Override
        public int hashCode() {
            assert (!this.isReadOnly());
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.alarmStatus).append((Object)this.alarmSeverity).toHashCode();
        }

        @Override
        public ChannelAccessAlarmEnum clone() {
            assert (!this.isReadOnly());
            return (ChannelAccessAlarmEnum)super.clone();
        }

        /* synthetic */ ChannelAccessAlarmEnumBase(ChannelAccessAlarmEnumBase x0, 1 x1) {
            this(x0);
        }
    }

    public static final class ChannelAccessEnumImpl
    extends ChannelAccessEnumBase<ChannelAccessEnumImpl>
    implements ChannelAccessSimpleOnlyEnum {
        public ChannelAccessEnumImpl(short[] value) {
            super(value);
        }

        private ChannelAccessEnumImpl(ChannelAccessEnumImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessEnumImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_ENUM;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessEnumImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessSimpleOnlyEnum asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessEnumImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessEnumImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessEnumImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessEnumImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessSimpleOnlyEnum clone() {
            if (this.delegate != null) {
                return ((ChannelAccessEnumImpl)this.delegate).clone();
            }
            return (ChannelAccessSimpleOnlyEnum)super.clone();
        }

        public static ChannelAccessEnumImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessEnumImpl value = new ChannelAccessEnumImpl();
            value.deserializeValue(byteSource, count);
            return value;
        }
    }
}

