/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value.internal;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.util.NullTerminatedStringUtil;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmFloat;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmOnlyFloat;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmSeverity;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmStatus;
import com.aquenos.epics.jackie.common.value.ChannelAccessControlsFloat;
import com.aquenos.epics.jackie.common.value.ChannelAccessFloat;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsFloat;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsOnlyFloat;
import com.aquenos.epics.jackie.common.value.ChannelAccessSimpleOnlyFloat;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeFloat;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeStamp;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueFactory;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessValueBase;
import com.aquenos.epics.jackie.common.value.internal.ValueCodecUtils;
import java.nio.FloatBuffer;
import java.nio.charset.Charset;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class ChannelAccessFloatBase<ImplementationType extends ChannelAccessFloatBase<ImplementationType>>
extends ChannelAccessValueBase<Float, ImplementationType>
implements ChannelAccessFloat {
    protected float[] value;

    private ChannelAccessFloatBase(float[] value) {
        assert (value != null);
        this.value = value;
    }

    private ChannelAccessFloatBase(ImplementationType delegate) {
        super(delegate);
    }

    private ChannelAccessFloatBase() {
    }

    @Override
    public int getValueSize() {
        if (this.delegate != null) {
            return ((ChannelAccessFloatBase)this.delegate).getValueSize();
        }
        return this.value.length;
    }

    @Override
    public Float getGenericValueElement(int index) {
        if (this.delegate != null) {
            return ((ChannelAccessFloatBase)this.delegate).getGenericValueElement(index);
        }
        return Float.valueOf(this.value[index]);
    }

    @Override
    public FloatBuffer getValue() {
        if (this.delegate != null) {
            return ((ChannelAccessFloatBase)this.delegate).getValue().asReadOnlyBuffer();
        }
        return FloatBuffer.wrap(this.value);
    }

    @Override
    public void setValue(float[] value) {
        if (this.delegate != null) {
            throw new UnsupportedOperationException("Cannot modify a read-only value.");
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    protected void deserializeValue(ByteSource byteSource, int count) {
        assert (count >= 0);
        this.value = count == 0 ? ArrayUtils.EMPTY_FLOAT_ARRAY : byteSource.getFloatArray(count);
    }

    protected void serializeValue(ByteSink byteSink, int count) {
        if (count != 0) {
            byteSink.putFloatArray(this.value, 0, count);
        }
    }

    @Override
    public boolean equals(Object obj) {
        assert (!this.isReadOnly());
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessFloatBase other = (ChannelAccessFloatBase)obj;
        return new EqualsBuilder().append(this.value, other.value).isEquals();
    }

    @Override
    public int hashCode() {
        assert (!this.isReadOnly());
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.value).toHashCode();
    }

    @Override
    public ChannelAccessFloat clone() {
        assert (!this.isReadOnly());
        ChannelAccessFloatBase copy = (ChannelAccessFloatBase)super.clone();
        copy.value = (float[])this.value.clone();
        return copy;
    }

    /* synthetic */ ChannelAccessFloatBase(ChannelAccessFloatBase x0, 1 x1) {
        this(x0);
    }

    public static final class ChannelAccessControlsFloatImpl
    extends ChannelAccessGraphicsFloatBase<ChannelAccessControlsFloatImpl>
    implements ChannelAccessControlsFloat {
        protected float upperControlLimit;
        protected float lowerControlLimit;

        public ChannelAccessControlsFloatImpl(float[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, short precision, String engineeringUnits, float upperDisplayLimit, float lowerDisplayLimit, float upperAlarmLimit, float upperWarningLimit, float lowerWarningLimit, float lowerAlarmLimit, float upperControlLimit, float lowerControlLimit, Charset charset) {
            super(value, alarmStatus, alarmSeverity, precision, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, charset);
            this.upperControlLimit = upperControlLimit;
            this.lowerControlLimit = lowerControlLimit;
        }

        private ChannelAccessControlsFloatImpl(ChannelAccessControlsFloatImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessControlsFloatImpl(Charset charset) {
            super(charset);
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_CTRL_FLOAT;
        }

        @Override
        public Float getGenericUpperControlLimit() {
            return Float.valueOf(this.getUpperControlLimit());
        }

        @Override
        public Float getGenericLowerControlLimit() {
            return Float.valueOf(this.getLowerControlLimit());
        }

        @Override
        public float getUpperControlLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsFloatImpl)this.delegate).getUpperControlLimit();
            }
            return this.upperControlLimit;
        }

        @Override
        public void setUpperControlLimit(float upperControlLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperControlLimit = upperControlLimit;
        }

        @Override
        public float getLowerControlLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsFloatImpl)this.delegate).getLowerControlLimit();
            }
            return this.lowerControlLimit;
        }

        @Override
        public void setLowerControlLimit(float lowerControlLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerControlLimit = lowerControlLimit;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessControlsFloatImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            this.serializeGraphics(byteSink);
            byteSink.putFloat(this.upperControlLimit);
            byteSink.putFloat(this.lowerControlLimit);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessControlsFloat asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessControlsFloatImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessControlsFloatImpl)this.delegate).equals(obj);
            }
            if (!super.equals(obj = ChannelAccessControlsFloatImpl.extractDelegate(obj))) {
                return false;
            }
            ChannelAccessControlsFloatImpl other = (ChannelAccessControlsFloatImpl)obj;
            return new EqualsBuilder().append(this.upperControlLimit, other.upperControlLimit).append(this.lowerControlLimit, other.lowerControlLimit).isEquals();
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsFloatImpl)this.delegate).hashCode();
            }
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.upperControlLimit).append(this.lowerControlLimit).toHashCode();
        }

        @Override
        public ChannelAccessControlsFloat clone() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsFloatImpl)this.delegate).clone();
            }
            return (ChannelAccessControlsFloat)super.clone();
        }

        public static ChannelAccessControlsFloatImpl deserialize(ByteSource byteSource, int count, Charset charset) {
            ChannelAccessControlsFloatImpl value = new ChannelAccessControlsFloatImpl(charset);
            value.deserializeAlarms(byteSource);
            value.deserializeGraphics(byteSource);
            value.upperControlLimit = byteSource.getFloat();
            value.lowerControlLimit = byteSource.getFloat();
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static final class ChannelAccessGraphicsFloatImpl
    extends ChannelAccessGraphicsFloatBase<ChannelAccessGraphicsFloatImpl>
    implements ChannelAccessGraphicsOnlyFloat {
        public ChannelAccessGraphicsFloatImpl(float[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, short precision, String engineeringUnits, float upperDisplayLimit, float lowerDisplayLimit, float upperAlarmLimit, float upperWarningLimit, float lowerWarningLimit, float lowerAlarmLimit, Charset charset) {
            super(value, alarmStatus, alarmSeverity, precision, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, charset);
        }

        private ChannelAccessGraphicsFloatImpl(ChannelAccessGraphicsFloatImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessGraphicsFloatImpl(Charset charset) {
            super(charset);
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_GR_FLOAT;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessGraphicsFloatImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            this.serializeGraphics(byteSink);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessGraphicsOnlyFloat asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessGraphicsFloatImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsFloatImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessGraphicsFloatImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsFloatImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessGraphicsOnlyFloat clone() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsFloatImpl)this.delegate).clone();
            }
            return (ChannelAccessGraphicsOnlyFloat)super.clone();
        }

        public static ChannelAccessGraphicsFloatImpl deserialize(ByteSource byteSource, int count, Charset charset) {
            ChannelAccessGraphicsFloatImpl value = new ChannelAccessGraphicsFloatImpl(charset);
            value.deserializeAlarms(byteSource);
            value.deserializeGraphics(byteSource);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static abstract class ChannelAccessGraphicsFloatBase<ImplementationType extends ChannelAccessGraphicsFloatBase<ImplementationType>>
    extends ChannelAccessAlarmFloatBase<ImplementationType>
    implements ChannelAccessGraphicsFloat {
        private static final int ENGINEERING_UNITS_STRING_SIZE = 8;
        protected String engineeringUnits;
        protected byte[] rawEngineeringUnits;
        protected float upperDisplayLimit;
        protected float lowerDisplayLimit;
        protected float upperAlarmLimit;
        protected float upperWarningLimit;
        protected float lowerWarningLimit;
        protected float lowerAlarmLimit;
        protected short precision;
        protected Charset charset;

        private ChannelAccessGraphicsFloatBase(float[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, short precision, String engineeringUnits, float upperDisplayLimit, float lowerDisplayLimit, float upperAlarmLimit, float upperWarningLimit, float lowerWarningLimit, float lowerAlarmLimit, Charset charset) {
            super(value, alarmStatus, alarmSeverity);
            this.precision = precision;
            this.engineeringUnits = engineeringUnits;
            assert (charset != null);
            this.charset = charset;
            this.rawEngineeringUnits = NullTerminatedStringUtil.stringToTruncatedNullTerminatedFixedBytes(this.engineeringUnits, 8, charset);
            this.upperDisplayLimit = upperDisplayLimit;
            this.lowerDisplayLimit = lowerDisplayLimit;
            this.upperAlarmLimit = upperAlarmLimit;
            this.upperWarningLimit = upperWarningLimit;
            this.lowerWarningLimit = lowerWarningLimit;
            this.lowerAlarmLimit = lowerAlarmLimit;
        }

        private ChannelAccessGraphicsFloatBase(ImplementationType delegate) {
            super((ChannelAccessAlarmFloatBase)delegate, null);
        }

        private ChannelAccessGraphicsFloatBase(Charset charset) {
            this.charset = charset;
        }

        @Override
        public String getUnits() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsFloatBase)this.delegate).getUnits();
            }
            return this.engineeringUnits;
        }

        @Override
        public byte[] getRawUnits() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsFloatBase)this.delegate).getRawUnits();
            }
            return (byte[])this.rawEngineeringUnits.clone();
        }

        @Override
        public void setUnits(String units) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.engineeringUnits = units;
            this.rawEngineeringUnits = NullTerminatedStringUtil.stringToTruncatedNullTerminatedFixedBytes(this.engineeringUnits, 8, this.charset);
        }

        @Override
        public void setRawUnits(byte[] rawUnits) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.rawEngineeringUnits = new byte[8];
            int copyLength = Math.min(rawUnits.length, 7);
            System.arraycopy(rawUnits, 0, this.rawEngineeringUnits, 0, copyLength);
            this.engineeringUnits = NullTerminatedStringUtil.nullTerminatedBytesToString(this.rawEngineeringUnits, this.charset);
        }

        @Override
        public Float getGenericUpperDisplayLimit() {
            return Float.valueOf(this.getUpperDisplayLimit());
        }

        @Override
        public Float getGenericLowerDisplayLimit() {
            return Float.valueOf(this.getLowerDisplayLimit());
        }

        @Override
        public Float getGenericUpperAlarmLimit() {
            return Float.valueOf(this.getUpperAlarmLimit());
        }

        @Override
        public Float getGenericUpperWarningLimit() {
            return Float.valueOf(this.getUpperWarningLimit());
        }

        @Override
        public Float getGenericLowerWarningLimit() {
            return Float.valueOf(this.getLowerWarningLimit());
        }

        @Override
        public Float getGenericLowerAlarmLimit() {
            return Float.valueOf(this.getLowerAlarmLimit());
        }

        @Override
        public Charset getCharset() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsFloatBase)this.delegate).getCharset();
            }
            return this.charset;
        }

        @Override
        public float getUpperDisplayLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsFloatBase)this.delegate).getUpperDisplayLimit();
            }
            return this.upperDisplayLimit;
        }

        @Override
        public void setUpperDisplayLimit(float upperDisplayLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperDisplayLimit = upperDisplayLimit;
        }

        @Override
        public float getLowerDisplayLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsFloatBase)this.delegate).getLowerDisplayLimit();
            }
            return this.lowerDisplayLimit;
        }

        @Override
        public void setLowerDisplayLimit(float lowerDisplayLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerDisplayLimit = lowerDisplayLimit;
        }

        @Override
        public float getUpperAlarmLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsFloatBase)this.delegate).getUpperAlarmLimit();
            }
            return this.upperAlarmLimit;
        }

        @Override
        public void setUpperAlarmLimit(float upperAlarmLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperAlarmLimit = upperAlarmLimit;
        }

        @Override
        public float getUpperWarningLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsFloatBase)this.delegate).getUpperWarningLimit();
            }
            return this.upperWarningLimit;
        }

        @Override
        public void setUpperWarningLimit(float upperWarningLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperWarningLimit = upperWarningLimit;
        }

        @Override
        public float getLowerWarningLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsFloatBase)this.delegate).getLowerWarningLimit();
            }
            return this.lowerWarningLimit;
        }

        @Override
        public void setLowerWarningLimit(float lowerWarningLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerWarningLimit = lowerWarningLimit;
        }

        @Override
        public float getLowerAlarmLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsFloatBase)this.delegate).getLowerAlarmLimit();
            }
            return this.lowerAlarmLimit;
        }

        @Override
        public void setLowerAlarmLimit(float lowerAlarmLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerAlarmLimit = lowerAlarmLimit;
        }

        @Override
        public short getPrecision() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsFloatBase)this.delegate).getPrecision();
            }
            return this.precision;
        }

        @Override
        public void setPrecision(short precision) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.precision = precision;
        }

        protected void deserializeGraphics(ByteSource byteSource) {
            this.precision = byteSource.getShort();
            byteSource.skip(2);
            this.rawEngineeringUnits = byteSource.getByteArray(8);
            this.rawEngineeringUnits[7] = 0;
            this.engineeringUnits = NullTerminatedStringUtil.nullTerminatedBytesToString(this.rawEngineeringUnits, this.charset);
            this.upperDisplayLimit = byteSource.getFloat();
            this.lowerDisplayLimit = byteSource.getFloat();
            this.upperAlarmLimit = byteSource.getFloat();
            this.upperWarningLimit = byteSource.getFloat();
            this.lowerWarningLimit = byteSource.getFloat();
            this.lowerAlarmLimit = byteSource.getFloat();
        }

        protected void serializeGraphics(ByteSink byteSink) {
            byteSink.putShort(this.precision);
            byteSink.putShort((short)0);
            byteSink.putByteArray(this.rawEngineeringUnits);
            byteSink.putFloat(this.upperDisplayLimit);
            byteSink.putFloat(this.lowerDisplayLimit);
            byteSink.putFloat(this.upperAlarmLimit);
            byteSink.putFloat(this.upperWarningLimit);
            byteSink.putFloat(this.lowerWarningLimit);
            byteSink.putFloat(this.lowerAlarmLimit);
        }

        @Override
        public boolean equals(Object obj) {
            assert (!this.isReadOnly());
            if (!super.equals(obj)) {
                return false;
            }
            ChannelAccessGraphicsFloatBase other = (ChannelAccessGraphicsFloatBase)obj;
            return new EqualsBuilder().append(this.precision, other.precision).append((Object)this.engineeringUnits, (Object)other.engineeringUnits).append(this.rawEngineeringUnits, other.rawEngineeringUnits).append(this.upperDisplayLimit, other.upperDisplayLimit).append(this.lowerDisplayLimit, other.lowerDisplayLimit).append(this.upperAlarmLimit, other.upperAlarmLimit).append(this.upperWarningLimit, other.upperWarningLimit).append(this.lowerWarningLimit, other.lowerWarningLimit).append(this.lowerAlarmLimit, other.lowerAlarmLimit).append((Object)this.charset, (Object)other.charset).isEquals();
        }

        @Override
        public int hashCode() {
            assert (!this.isReadOnly());
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.precision).append((Object)this.engineeringUnits).append(this.rawEngineeringUnits).append(this.upperDisplayLimit).append(this.lowerDisplayLimit).append(this.upperAlarmLimit).append(this.upperWarningLimit).append(this.lowerWarningLimit).append(this.lowerAlarmLimit).append((Object)this.charset).toHashCode();
        }

        @Override
        public ChannelAccessGraphicsFloat clone() {
            assert (!this.isReadOnly());
            return (ChannelAccessGraphicsFloat)super.clone();
        }

        /* synthetic */ ChannelAccessGraphicsFloatBase(ChannelAccessGraphicsFloatBase x0, 1 x1) {
            this(x0);
        }
    }

    public static final class ChannelAccessTimeFloatImpl
    extends ChannelAccessAlarmFloatBase<ChannelAccessTimeFloatImpl>
    implements ChannelAccessTimeFloat {
        protected int timeStampSeconds;
        protected int timeStampNanoseconds;

        public ChannelAccessTimeFloatImpl(float[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, int timeStampSeconds, int timeStampNanoSeconds) {
            super(value, alarmStatus, alarmSeverity);
            this.timeStampSeconds = timeStampSeconds;
            if (timeStampNanoSeconds < 0 || timeStampNanoSeconds > 999999999) {
                throw new IllegalArgumentException("Nanoseconds part of timestamp must be a number between 0 and 999999999.");
            }
            this.timeStampNanoseconds = timeStampNanoSeconds;
        }

        private ChannelAccessTimeFloatImpl(ChannelAccessTimeFloatImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessTimeFloatImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_TIME_FLOAT;
        }

        @Override
        public ChannelAccessTimeStamp getTimeStamp() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeFloatImpl)this.delegate).getTimeStamp();
            }
            return ChannelAccessValueFactory.createTimeStamp(this.timeStampSeconds, this.timeStampNanoseconds);
        }

        @Override
        public int getTimeSeconds() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeFloatImpl)this.delegate).getTimeSeconds();
            }
            return this.timeStampSeconds;
        }

        @Override
        public int getTimeNanoseconds() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeFloatImpl)this.delegate).getTimeNanoseconds();
            }
            return this.timeStampNanoseconds;
        }

        @Override
        public void setTimeStamp(ChannelAccessTimeStamp timeStamp) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.timeStampSeconds = timeStamp.getSeconds();
            this.timeStampNanoseconds = timeStamp.getNanoseconds();
        }

        @Override
        public void setTimeSeconds(int timeStampSeconds) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.timeStampSeconds = timeStampSeconds;
        }

        @Override
        public void setTimeNanoseconds(int timeStampNanoseconds) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            if (timeStampNanoseconds < 0 || timeStampNanoseconds > 999999999) {
                throw new IllegalArgumentException("Nanoseconds part of time-stamp must be a number between 0 and 999999999.");
            }
            this.timeStampNanoseconds = timeStampNanoseconds;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessTimeFloatImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            ValueCodecUtils.serializeTime(byteSink, this.timeStampSeconds, this.timeStampNanoseconds);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessTimeFloat asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessTimeFloatImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessTimeFloatImpl)this.delegate).equals(obj);
            }
            if (!super.equals(obj = ChannelAccessTimeFloatImpl.extractDelegate(obj))) {
                return false;
            }
            ChannelAccessTimeFloatImpl other = (ChannelAccessTimeFloatImpl)obj;
            return new EqualsBuilder().append(this.timeStampSeconds, other.timeStampSeconds).append(this.timeStampNanoseconds, other.timeStampNanoseconds).isEquals();
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeFloatImpl)this.delegate).hashCode();
            }
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.timeStampSeconds).append(this.timeStampNanoseconds).toHashCode();
        }

        @Override
        public ChannelAccessTimeFloat clone() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeFloatImpl)this.delegate).clone();
            }
            return (ChannelAccessTimeFloat)super.clone();
        }

        public static ChannelAccessTimeFloatImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessTimeFloatImpl value = new ChannelAccessTimeFloatImpl();
            value.deserializeAlarms(byteSource);
            value.timeStampSeconds = ValueCodecUtils.deserializeTimeSeconds(byteSource);
            value.timeStampNanoseconds = ValueCodecUtils.deserializeTimeNanoseconds(byteSource);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static final class ChannelAccessAlarmFloatImpl
    extends ChannelAccessAlarmFloatBase<ChannelAccessAlarmFloatImpl>
    implements ChannelAccessAlarmOnlyFloat {
        public ChannelAccessAlarmFloatImpl(float[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity) {
            super(value, alarmStatus, alarmSeverity);
        }

        private ChannelAccessAlarmFloatImpl(ChannelAccessAlarmFloatImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessAlarmFloatImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_STS_FLOAT;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessAlarmFloatImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessAlarmOnlyFloat asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessAlarmFloatImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmFloatImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessAlarmFloatImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmFloatImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessAlarmOnlyFloat clone() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmFloatImpl)this.delegate).clone();
            }
            return (ChannelAccessAlarmOnlyFloat)super.clone();
        }

        public static ChannelAccessAlarmFloatImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessAlarmFloatImpl value = new ChannelAccessAlarmFloatImpl();
            value.deserializeAlarms(byteSource);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static abstract class ChannelAccessAlarmFloatBase<ImplementationType extends ChannelAccessAlarmFloatBase<ImplementationType>>
    extends ChannelAccessFloatBase<ImplementationType>
    implements ChannelAccessAlarmFloat {
        protected ChannelAccessAlarmStatus alarmStatus;
        protected ChannelAccessAlarmSeverity alarmSeverity;

        private ChannelAccessAlarmFloatBase(float[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity) {
            super(value);
            this.alarmStatus = alarmStatus;
            this.alarmSeverity = alarmSeverity;
        }

        private ChannelAccessAlarmFloatBase(ImplementationType delegate) {
            super((ChannelAccessFloatBase)delegate, null);
        }

        private ChannelAccessAlarmFloatBase() {
        }

        @Override
        public ChannelAccessAlarmStatus getAlarmStatus() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmFloatBase)this.delegate).getAlarmStatus();
            }
            return this.alarmStatus;
        }

        @Override
        public void setAlarmStatus(ChannelAccessAlarmStatus alarmStatus) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            assert (alarmStatus != null);
            this.alarmStatus = alarmStatus;
        }

        @Override
        public ChannelAccessAlarmSeverity getAlarmSeverity() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmFloatBase)this.delegate).getAlarmSeverity();
            }
            return this.alarmSeverity;
        }

        @Override
        public void setAlarmSeverity(ChannelAccessAlarmSeverity alarmSeverity) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            assert (alarmSeverity != null);
            this.alarmSeverity = alarmSeverity;
        }

        protected void deserializeAlarms(ByteSource byteSource) {
            this.alarmStatus = ValueCodecUtils.deserializeAlarmStatus(byteSource);
            this.alarmSeverity = ValueCodecUtils.deserializeAlarmSeverity(byteSource);
        }

        protected void serializeAlarms(ByteSink byteSink) {
            ValueCodecUtils.serializeAlarms(byteSink, this.alarmStatus, this.alarmSeverity);
        }

        @Override
        public boolean equals(Object obj) {
            assert (!this.isReadOnly());
            if (!super.equals(obj)) {
                return false;
            }
            ChannelAccessAlarmFloatBase other = (ChannelAccessAlarmFloatBase)obj;
            return new EqualsBuilder().append((Object)this.alarmStatus, (Object)other.alarmStatus).append((Object)this.alarmSeverity, (Object)other.alarmSeverity).isEquals();
        }

        @Override
        public int hashCode() {
            assert (!this.isReadOnly());
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.alarmStatus).append((Object)this.alarmSeverity).toHashCode();
        }

        @Override
        public ChannelAccessAlarmFloat clone() {
            assert (!this.isReadOnly());
            return (ChannelAccessAlarmFloat)super.clone();
        }

        /* synthetic */ ChannelAccessAlarmFloatBase(ChannelAccessAlarmFloatBase x0, 1 x1) {
            this(x0);
        }
    }

    public static final class ChannelAccessFloatImpl
    extends ChannelAccessFloatBase<ChannelAccessFloatImpl>
    implements ChannelAccessSimpleOnlyFloat {
        public ChannelAccessFloatImpl(float[] value) {
            super(value);
        }

        private ChannelAccessFloatImpl(ChannelAccessFloatImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessFloatImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_FLOAT;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessFloatImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessSimpleOnlyFloat asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessFloatImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessFloatImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessFloatImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessFloatImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessSimpleOnlyFloat clone() {
            if (this.delegate != null) {
                return ((ChannelAccessFloatImpl)this.delegate).clone();
            }
            return (ChannelAccessSimpleOnlyFloat)super.clone();
        }

        public static ChannelAccessFloatImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessFloatImpl value = new ChannelAccessFloatImpl();
            value.deserializeValue(byteSource, count);
            return value;
        }
    }
}

