/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value.internal;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.util.NullTerminatedStringUtil;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmLong;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmOnlyLong;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmSeverity;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmStatus;
import com.aquenos.epics.jackie.common.value.ChannelAccessControlsLong;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsLong;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsOnlyLong;
import com.aquenos.epics.jackie.common.value.ChannelAccessLong;
import com.aquenos.epics.jackie.common.value.ChannelAccessSimpleOnlyLong;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeLong;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeStamp;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueFactory;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessValueBase;
import com.aquenos.epics.jackie.common.value.internal.ValueCodecUtils;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class ChannelAccessLongBase<ImplementationType extends ChannelAccessLongBase<ImplementationType>>
extends ChannelAccessValueBase<Integer, ImplementationType>
implements ChannelAccessLong {
    protected int[] value;

    private ChannelAccessLongBase(int[] value) {
        assert (value != null);
        this.value = value;
    }

    private ChannelAccessLongBase(ImplementationType delegate) {
        super(delegate);
    }

    private ChannelAccessLongBase() {
    }

    @Override
    public int getValueSize() {
        if (this.delegate != null) {
            return ((ChannelAccessLongBase)this.delegate).getValueSize();
        }
        return this.value.length;
    }

    @Override
    public Integer getGenericValueElement(int index) {
        if (this.delegate != null) {
            return ((ChannelAccessLongBase)this.delegate).getGenericValueElement(index);
        }
        return this.value[index];
    }

    @Override
    public IntBuffer getValue() {
        if (this.delegate != null) {
            return ((ChannelAccessLongBase)this.delegate).getValue().asReadOnlyBuffer();
        }
        return IntBuffer.wrap(this.value);
    }

    @Override
    public void setValue(int[] value) {
        if (this.delegate != null) {
            throw new UnsupportedOperationException("Cannot modify a read-only value.");
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    protected void deserializeValue(ByteSource byteSource, int count) {
        assert (count >= 0);
        this.value = count == 0 ? ArrayUtils.EMPTY_INT_ARRAY : byteSource.getIntArray(count);
    }

    protected void serializeValue(ByteSink byteSink, int count) {
        if (count != 0) {
            byteSink.putIntArray(this.value, 0, count);
        }
    }

    @Override
    public boolean equals(Object obj) {
        assert (!this.isReadOnly());
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessLongBase other = (ChannelAccessLongBase)obj;
        return new EqualsBuilder().append(this.value, other.value).isEquals();
    }

    @Override
    public int hashCode() {
        assert (!this.isReadOnly());
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.value).toHashCode();
    }

    @Override
    public ChannelAccessLong clone() {
        assert (!this.isReadOnly());
        ChannelAccessLongBase copy = (ChannelAccessLongBase)super.clone();
        copy.value = (int[])this.value.clone();
        return copy;
    }

    /* synthetic */ ChannelAccessLongBase(ChannelAccessLongBase x0, 1 x1) {
        this(x0);
    }

    public static final class ChannelAccessControlsLongImpl
    extends ChannelAccessGraphicsLongBase<ChannelAccessControlsLongImpl>
    implements ChannelAccessControlsLong {
        protected int upperControlLimit;
        protected int lowerControlLimit;

        public ChannelAccessControlsLongImpl(int[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, String engineeringUnits, int upperDisplayLimit, int lowerDisplayLimit, int upperAlarmLimit, int upperWarningLimit, int lowerWarningLimit, int lowerAlarmLimit, int upperControlLimit, int lowerControlLimit, Charset charset) {
            super(value, alarmStatus, alarmSeverity, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, charset);
            this.upperControlLimit = upperControlLimit;
            this.lowerControlLimit = lowerControlLimit;
        }

        private ChannelAccessControlsLongImpl(ChannelAccessControlsLongImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessControlsLongImpl(Charset charset) {
            super(charset);
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_CTRL_LONG;
        }

        @Override
        public Integer getGenericUpperControlLimit() {
            return this.getUpperControlLimit();
        }

        @Override
        public Integer getGenericLowerControlLimit() {
            return this.getLowerControlLimit();
        }

        @Override
        public int getUpperControlLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsLongImpl)this.delegate).getUpperControlLimit();
            }
            return this.upperControlLimit;
        }

        @Override
        public void setUpperControlLimit(int upperControlLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperControlLimit = upperControlLimit;
        }

        @Override
        public int getLowerControlLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsLongImpl)this.delegate).getLowerControlLimit();
            }
            return this.lowerControlLimit;
        }

        @Override
        public void setLowerControlLimit(int lowerControlLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerControlLimit = lowerControlLimit;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessControlsLongImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            this.serializeGraphics(byteSink);
            byteSink.putInt(this.upperControlLimit);
            byteSink.putInt(this.lowerControlLimit);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessControlsLong asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessControlsLongImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessControlsLongImpl)this.delegate).equals(obj);
            }
            if (!super.equals(obj = ChannelAccessControlsLongImpl.extractDelegate(obj))) {
                return false;
            }
            ChannelAccessControlsLongImpl other = (ChannelAccessControlsLongImpl)obj;
            return new EqualsBuilder().append(this.upperControlLimit, other.upperControlLimit).append(this.lowerControlLimit, other.lowerControlLimit).isEquals();
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsLongImpl)this.delegate).hashCode();
            }
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.upperControlLimit).append(this.lowerControlLimit).toHashCode();
        }

        @Override
        public ChannelAccessControlsLong clone() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsLongImpl)this.delegate).clone();
            }
            return (ChannelAccessControlsLong)super.clone();
        }

        public static ChannelAccessControlsLongImpl deserialize(ByteSource byteSource, int count, Charset charset) {
            ChannelAccessControlsLongImpl value = new ChannelAccessControlsLongImpl(charset);
            value.deserializeAlarms(byteSource);
            value.deserializeGraphics(byteSource);
            value.upperControlLimit = byteSource.getInt();
            value.lowerControlLimit = byteSource.getInt();
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static final class ChannelAccessGraphicsLongImpl
    extends ChannelAccessGraphicsLongBase<ChannelAccessGraphicsLongImpl>
    implements ChannelAccessGraphicsOnlyLong {
        public ChannelAccessGraphicsLongImpl(int[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, String engineeringUnits, int upperDisplayLimit, int lowerDisplayLimit, int upperAlarmLimit, int upperWarningLimit, int lowerWarningLimit, int lowerAlarmLimit, Charset charset) {
            super(value, alarmStatus, alarmSeverity, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, charset);
        }

        private ChannelAccessGraphicsLongImpl(ChannelAccessGraphicsLongImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessGraphicsLongImpl(Charset charset) {
            super(charset);
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_GR_LONG;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessGraphicsLongImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            this.serializeGraphics(byteSink);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessGraphicsOnlyLong asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessGraphicsLongImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsLongImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessGraphicsLongImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsLongImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessGraphicsOnlyLong clone() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsLongImpl)this.delegate).clone();
            }
            return (ChannelAccessGraphicsOnlyLong)super.clone();
        }

        public static ChannelAccessGraphicsLongImpl deserialize(ByteSource byteSource, int count, Charset charset) {
            ChannelAccessGraphicsLongImpl value = new ChannelAccessGraphicsLongImpl(charset);
            value.deserializeAlarms(byteSource);
            value.deserializeGraphics(byteSource);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static abstract class ChannelAccessGraphicsLongBase<ImplementationType extends ChannelAccessGraphicsLongBase<ImplementationType>>
    extends ChannelAccessAlarmLongBase<ImplementationType>
    implements ChannelAccessGraphicsLong {
        private static final int ENGINEERING_UNITS_STRING_SIZE = 8;
        protected String engineeringUnits;
        protected byte[] rawEngineeringUnits;
        protected int upperDisplayLimit;
        protected int lowerDisplayLimit;
        protected int upperAlarmLimit;
        protected int upperWarningLimit;
        protected int lowerWarningLimit;
        protected int lowerAlarmLimit;
        protected Charset charset;

        private ChannelAccessGraphicsLongBase(int[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, String engineeringUnits, int upperDisplayLimit, int lowerDisplayLimit, int upperAlarmLimit, int upperWarningLimit, int lowerWarningLimit, int lowerAlarmLimit, Charset charset) {
            super(value, alarmStatus, alarmSeverity);
            this.engineeringUnits = engineeringUnits;
            assert (charset != null);
            this.charset = charset;
            this.rawEngineeringUnits = NullTerminatedStringUtil.stringToTruncatedNullTerminatedFixedBytes(this.engineeringUnits, 8, charset);
            this.upperDisplayLimit = upperDisplayLimit;
            this.lowerDisplayLimit = lowerDisplayLimit;
            this.upperAlarmLimit = upperAlarmLimit;
            this.upperWarningLimit = upperWarningLimit;
            this.lowerWarningLimit = lowerWarningLimit;
            this.lowerAlarmLimit = lowerAlarmLimit;
        }

        private ChannelAccessGraphicsLongBase(ImplementationType delegate) {
            super((ChannelAccessAlarmLongBase)delegate, null);
        }

        private ChannelAccessGraphicsLongBase(Charset charset) {
            this.charset = charset;
        }

        @Override
        public String getUnits() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsLongBase)this.delegate).getUnits();
            }
            return this.engineeringUnits;
        }

        @Override
        public byte[] getRawUnits() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsLongBase)this.delegate).getRawUnits();
            }
            return (byte[])this.rawEngineeringUnits.clone();
        }

        @Override
        public void setUnits(String units) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.engineeringUnits = units;
            this.rawEngineeringUnits = NullTerminatedStringUtil.stringToTruncatedNullTerminatedFixedBytes(this.engineeringUnits, 8, this.charset);
        }

        @Override
        public void setRawUnits(byte[] rawUnits) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.rawEngineeringUnits = new byte[8];
            int copyLength = Math.min(rawUnits.length, 7);
            System.arraycopy(rawUnits, 0, this.rawEngineeringUnits, 0, copyLength);
            this.engineeringUnits = NullTerminatedStringUtil.nullTerminatedBytesToString(this.rawEngineeringUnits, this.charset);
        }

        @Override
        public Integer getGenericUpperDisplayLimit() {
            return this.getUpperDisplayLimit();
        }

        @Override
        public Integer getGenericLowerDisplayLimit() {
            return this.getLowerDisplayLimit();
        }

        @Override
        public Integer getGenericUpperAlarmLimit() {
            return this.getUpperAlarmLimit();
        }

        @Override
        public Integer getGenericUpperWarningLimit() {
            return this.getUpperWarningLimit();
        }

        @Override
        public Integer getGenericLowerWarningLimit() {
            return this.getLowerWarningLimit();
        }

        @Override
        public Integer getGenericLowerAlarmLimit() {
            return this.getLowerAlarmLimit();
        }

        @Override
        public Charset getCharset() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsLongBase)this.delegate).getCharset();
            }
            return this.charset;
        }

        @Override
        public int getUpperDisplayLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsLongBase)this.delegate).getUpperDisplayLimit();
            }
            return this.upperDisplayLimit;
        }

        @Override
        public void setUpperDisplayLimit(int upperDisplayLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperDisplayLimit = upperDisplayLimit;
        }

        @Override
        public int getLowerDisplayLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsLongBase)this.delegate).getLowerDisplayLimit();
            }
            return this.lowerDisplayLimit;
        }

        @Override
        public void setLowerDisplayLimit(int lowerDisplayLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerDisplayLimit = lowerDisplayLimit;
        }

        @Override
        public int getUpperAlarmLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsLongBase)this.delegate).getUpperAlarmLimit();
            }
            return this.upperAlarmLimit;
        }

        @Override
        public void setUpperAlarmLimit(int upperAlarmLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperAlarmLimit = upperAlarmLimit;
        }

        @Override
        public int getUpperWarningLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsLongBase)this.delegate).getUpperWarningLimit();
            }
            return this.upperWarningLimit;
        }

        @Override
        public void setUpperWarningLimit(int upperWarningLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperWarningLimit = upperWarningLimit;
        }

        @Override
        public int getLowerWarningLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsLongBase)this.delegate).getLowerWarningLimit();
            }
            return this.lowerWarningLimit;
        }

        @Override
        public void setLowerWarningLimit(int lowerWarningLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerWarningLimit = lowerWarningLimit;
        }

        @Override
        public int getLowerAlarmLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsLongBase)this.delegate).getLowerAlarmLimit();
            }
            return this.lowerAlarmLimit;
        }

        @Override
        public void setLowerAlarmLimit(int lowerAlarmLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerAlarmLimit = lowerAlarmLimit;
        }

        protected void deserializeGraphics(ByteSource byteSource) {
            this.rawEngineeringUnits = byteSource.getByteArray(8);
            this.rawEngineeringUnits[7] = 0;
            this.engineeringUnits = NullTerminatedStringUtil.nullTerminatedBytesToString(this.rawEngineeringUnits, this.charset);
            this.upperDisplayLimit = byteSource.getInt();
            this.lowerDisplayLimit = byteSource.getInt();
            this.upperAlarmLimit = byteSource.getInt();
            this.upperWarningLimit = byteSource.getInt();
            this.lowerWarningLimit = byteSource.getInt();
            this.lowerAlarmLimit = byteSource.getInt();
        }

        protected void serializeGraphics(ByteSink byteSink) {
            byteSink.putByteArray(this.rawEngineeringUnits);
            byteSink.putInt(this.upperDisplayLimit);
            byteSink.putInt(this.lowerDisplayLimit);
            byteSink.putInt(this.upperAlarmLimit);
            byteSink.putInt(this.upperWarningLimit);
            byteSink.putInt(this.lowerWarningLimit);
            byteSink.putInt(this.lowerAlarmLimit);
        }

        @Override
        public boolean equals(Object obj) {
            assert (!this.isReadOnly());
            if (!super.equals(obj)) {
                return false;
            }
            ChannelAccessGraphicsLongBase other = (ChannelAccessGraphicsLongBase)obj;
            return new EqualsBuilder().append((Object)this.engineeringUnits, (Object)other.engineeringUnits).append(this.rawEngineeringUnits, other.rawEngineeringUnits).append(this.upperDisplayLimit, other.upperDisplayLimit).append(this.lowerDisplayLimit, other.lowerDisplayLimit).append(this.upperAlarmLimit, other.upperAlarmLimit).append(this.upperWarningLimit, other.upperWarningLimit).append(this.lowerWarningLimit, other.lowerWarningLimit).append(this.lowerAlarmLimit, other.lowerAlarmLimit).append((Object)this.charset, (Object)other.charset).isEquals();
        }

        @Override
        public int hashCode() {
            assert (!this.isReadOnly());
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.engineeringUnits).append(this.rawEngineeringUnits).append(this.upperDisplayLimit).append(this.lowerDisplayLimit).append(this.upperAlarmLimit).append(this.upperWarningLimit).append(this.lowerWarningLimit).append(this.lowerAlarmLimit).append((Object)this.charset).toHashCode();
        }

        @Override
        public ChannelAccessGraphicsLong clone() {
            assert (!this.isReadOnly());
            return (ChannelAccessGraphicsLong)super.clone();
        }

        /* synthetic */ ChannelAccessGraphicsLongBase(ChannelAccessGraphicsLongBase x0, 1 x1) {
            this(x0);
        }
    }

    public static final class ChannelAccessTimeLongImpl
    extends ChannelAccessAlarmLongBase<ChannelAccessTimeLongImpl>
    implements ChannelAccessTimeLong {
        protected int timeStampSeconds;
        protected int timeStampNanoseconds;

        public ChannelAccessTimeLongImpl(int[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, int timeStampSeconds, int timeStampNanoSeconds) {
            super(value, alarmStatus, alarmSeverity);
            this.timeStampSeconds = timeStampSeconds;
            if (timeStampNanoSeconds < 0 || timeStampNanoSeconds > 999999999) {
                throw new IllegalArgumentException("Nanoseconds part of timestamp must be a number between 0 and 999999999.");
            }
            this.timeStampNanoseconds = timeStampNanoSeconds;
        }

        private ChannelAccessTimeLongImpl(ChannelAccessTimeLongImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessTimeLongImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_TIME_LONG;
        }

        @Override
        public ChannelAccessTimeStamp getTimeStamp() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeLongImpl)this.delegate).getTimeStamp();
            }
            return ChannelAccessValueFactory.createTimeStamp(this.timeStampSeconds, this.timeStampNanoseconds);
        }

        @Override
        public int getTimeSeconds() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeLongImpl)this.delegate).getTimeSeconds();
            }
            return this.timeStampSeconds;
        }

        @Override
        public int getTimeNanoseconds() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeLongImpl)this.delegate).getTimeNanoseconds();
            }
            return this.timeStampNanoseconds;
        }

        @Override
        public void setTimeStamp(ChannelAccessTimeStamp timeStamp) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.timeStampSeconds = timeStamp.getSeconds();
            this.timeStampNanoseconds = timeStamp.getNanoseconds();
        }

        @Override
        public void setTimeSeconds(int timeStampSeconds) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.timeStampSeconds = timeStampSeconds;
        }

        @Override
        public void setTimeNanoseconds(int timeStampNanoseconds) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            if (timeStampNanoseconds < 0 || timeStampNanoseconds > 999999999) {
                throw new IllegalArgumentException("Nanoseconds part of time-stamp must be a number between 0 and 999999999.");
            }
            this.timeStampNanoseconds = timeStampNanoseconds;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessTimeLongImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            ValueCodecUtils.serializeTime(byteSink, this.timeStampSeconds, this.timeStampNanoseconds);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessTimeLong asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessTimeLongImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessTimeLongImpl)this.delegate).equals(obj);
            }
            if (!super.equals(obj = ChannelAccessTimeLongImpl.extractDelegate(obj))) {
                return false;
            }
            ChannelAccessTimeLongImpl other = (ChannelAccessTimeLongImpl)obj;
            return new EqualsBuilder().append(this.timeStampSeconds, other.timeStampSeconds).append(this.timeStampNanoseconds, other.timeStampNanoseconds).isEquals();
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeLongImpl)this.delegate).hashCode();
            }
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.timeStampSeconds).append(this.timeStampNanoseconds).toHashCode();
        }

        @Override
        public ChannelAccessTimeLong clone() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeLongImpl)this.delegate).clone();
            }
            return (ChannelAccessTimeLong)super.clone();
        }

        public static ChannelAccessTimeLongImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessTimeLongImpl value = new ChannelAccessTimeLongImpl();
            value.deserializeAlarms(byteSource);
            value.timeStampSeconds = ValueCodecUtils.deserializeTimeSeconds(byteSource);
            value.timeStampNanoseconds = ValueCodecUtils.deserializeTimeNanoseconds(byteSource);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static final class ChannelAccessAlarmLongImpl
    extends ChannelAccessAlarmLongBase<ChannelAccessAlarmLongImpl>
    implements ChannelAccessAlarmOnlyLong {
        public ChannelAccessAlarmLongImpl(int[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity) {
            super(value, alarmStatus, alarmSeverity);
        }

        private ChannelAccessAlarmLongImpl(ChannelAccessAlarmLongImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessAlarmLongImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_STS_LONG;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessAlarmLongImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessAlarmOnlyLong asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessAlarmLongImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmLongImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessAlarmLongImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmLongImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessAlarmOnlyLong clone() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmLongImpl)this.delegate).clone();
            }
            return (ChannelAccessAlarmOnlyLong)super.clone();
        }

        public static ChannelAccessAlarmLongImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessAlarmLongImpl value = new ChannelAccessAlarmLongImpl();
            value.deserializeAlarms(byteSource);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static abstract class ChannelAccessAlarmLongBase<ImplementationType extends ChannelAccessAlarmLongBase<ImplementationType>>
    extends ChannelAccessLongBase<ImplementationType>
    implements ChannelAccessAlarmLong {
        protected ChannelAccessAlarmStatus alarmStatus;
        protected ChannelAccessAlarmSeverity alarmSeverity;

        private ChannelAccessAlarmLongBase(int[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity) {
            super(value);
            this.alarmStatus = alarmStatus;
            this.alarmSeverity = alarmSeverity;
        }

        private ChannelAccessAlarmLongBase(ImplementationType delegate) {
            super((ChannelAccessLongBase)delegate, null);
        }

        private ChannelAccessAlarmLongBase() {
        }

        @Override
        public ChannelAccessAlarmStatus getAlarmStatus() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmLongBase)this.delegate).getAlarmStatus();
            }
            return this.alarmStatus;
        }

        @Override
        public void setAlarmStatus(ChannelAccessAlarmStatus alarmStatus) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            assert (alarmStatus != null);
            this.alarmStatus = alarmStatus;
        }

        @Override
        public ChannelAccessAlarmSeverity getAlarmSeverity() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmLongBase)this.delegate).getAlarmSeverity();
            }
            return this.alarmSeverity;
        }

        @Override
        public void setAlarmSeverity(ChannelAccessAlarmSeverity alarmSeverity) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            assert (alarmSeverity != null);
            this.alarmSeverity = alarmSeverity;
        }

        protected void deserializeAlarms(ByteSource byteSource) {
            this.alarmStatus = ValueCodecUtils.deserializeAlarmStatus(byteSource);
            this.alarmSeverity = ValueCodecUtils.deserializeAlarmSeverity(byteSource);
        }

        protected void serializeAlarms(ByteSink byteSink) {
            ValueCodecUtils.serializeAlarms(byteSink, this.alarmStatus, this.alarmSeverity);
        }

        @Override
        public boolean equals(Object obj) {
            assert (!this.isReadOnly());
            if (!super.equals(obj)) {
                return false;
            }
            ChannelAccessAlarmLongBase other = (ChannelAccessAlarmLongBase)obj;
            return new EqualsBuilder().append((Object)this.alarmStatus, (Object)other.alarmStatus).append((Object)this.alarmSeverity, (Object)other.alarmSeverity).isEquals();
        }

        @Override
        public int hashCode() {
            assert (!this.isReadOnly());
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.alarmStatus).append((Object)this.alarmSeverity).toHashCode();
        }

        @Override
        public ChannelAccessAlarmLong clone() {
            assert (!this.isReadOnly());
            return (ChannelAccessAlarmLong)super.clone();
        }

        /* synthetic */ ChannelAccessAlarmLongBase(ChannelAccessAlarmLongBase x0, 1 x1) {
            this(x0);
        }
    }

    public static final class ChannelAccessLongImpl
    extends ChannelAccessLongBase<ChannelAccessLongImpl>
    implements ChannelAccessSimpleOnlyLong {
        public ChannelAccessLongImpl(int[] value) {
            super(value);
        }

        private ChannelAccessLongImpl(ChannelAccessLongImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessLongImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_LONG;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessLongImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessSimpleOnlyLong asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessLongImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessLongImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessLongImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessLongImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessSimpleOnlyLong clone() {
            if (this.delegate != null) {
                return ((ChannelAccessLongImpl)this.delegate).clone();
            }
            return (ChannelAccessSimpleOnlyLong)super.clone();
        }

        public static ChannelAccessLongImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessLongImpl value = new ChannelAccessLongImpl();
            value.deserializeValue(byteSource, count);
            return value;
        }
    }
}

