/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value.internal;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.util.NullTerminatedStringUtil;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmOnlyShort;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmSeverity;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmShort;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmStatus;
import com.aquenos.epics.jackie.common.value.ChannelAccessControlsShort;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsOnlyShort;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsShort;
import com.aquenos.epics.jackie.common.value.ChannelAccessShort;
import com.aquenos.epics.jackie.common.value.ChannelAccessSimpleOnlyShort;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeShort;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeStamp;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueFactory;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import com.aquenos.epics.jackie.common.value.internal.ChannelAccessValueBase;
import com.aquenos.epics.jackie.common.value.internal.ValueCodecUtils;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class ChannelAccessShortBase<ImplementationType extends ChannelAccessShortBase<ImplementationType>>
extends ChannelAccessValueBase<Short, ImplementationType>
implements ChannelAccessShort {
    protected short[] value;

    private ChannelAccessShortBase(short[] value) {
        assert (value != null);
        this.value = value;
    }

    private ChannelAccessShortBase(ImplementationType delegate) {
        super(delegate);
    }

    private ChannelAccessShortBase() {
    }

    @Override
    public int getValueSize() {
        if (this.delegate != null) {
            return ((ChannelAccessShortBase)this.delegate).getValueSize();
        }
        return this.value.length;
    }

    @Override
    public Short getGenericValueElement(int index) {
        if (this.delegate != null) {
            return ((ChannelAccessShortBase)this.delegate).getGenericValueElement(index);
        }
        return this.value[index];
    }

    @Override
    public ShortBuffer getValue() {
        if (this.delegate != null) {
            return ((ChannelAccessShortBase)this.delegate).getValue().asReadOnlyBuffer();
        }
        return ShortBuffer.wrap(this.value);
    }

    @Override
    public void setValue(short[] value) {
        if (this.delegate != null) {
            throw new UnsupportedOperationException("Cannot modify a read-only value.");
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    protected void deserializeValue(ByteSource byteSource, int count) {
        assert (count >= 0);
        this.value = count == 0 ? ArrayUtils.EMPTY_SHORT_ARRAY : byteSource.getShortArray(count);
    }

    protected void serializeValue(ByteSink byteSink, int count) {
        if (count != 0) {
            byteSink.putShortArray(this.value, 0, count);
        }
    }

    @Override
    public boolean equals(Object obj) {
        assert (!this.isReadOnly());
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessShortBase other = (ChannelAccessShortBase)obj;
        return new EqualsBuilder().append(this.value, other.value).isEquals();
    }

    @Override
    public int hashCode() {
        assert (!this.isReadOnly());
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.value).toHashCode();
    }

    @Override
    public ChannelAccessShort clone() {
        assert (!this.isReadOnly());
        ChannelAccessShortBase copy = (ChannelAccessShortBase)super.clone();
        copy.value = (short[])this.value.clone();
        return copy;
    }

    /* synthetic */ ChannelAccessShortBase(ChannelAccessShortBase x0, 1 x1) {
        this(x0);
    }

    public static final class ChannelAccessControlsShortImpl
    extends ChannelAccessGraphicsShortBase<ChannelAccessControlsShortImpl>
    implements ChannelAccessControlsShort {
        protected short upperControlLimit;
        protected short lowerControlLimit;

        public ChannelAccessControlsShortImpl(short[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, String engineeringUnits, short upperDisplayLimit, short lowerDisplayLimit, short upperAlarmLimit, short upperWarningLimit, short lowerWarningLimit, short lowerAlarmLimit, short upperControlLimit, short lowerControlLimit, Charset charset) {
            super(value, alarmStatus, alarmSeverity, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, charset);
            this.upperControlLimit = upperControlLimit;
            this.lowerControlLimit = lowerControlLimit;
        }

        private ChannelAccessControlsShortImpl(ChannelAccessControlsShortImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessControlsShortImpl(Charset charset) {
            super(charset);
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_CTRL_SHORT;
        }

        @Override
        public Short getGenericUpperControlLimit() {
            return this.getUpperControlLimit();
        }

        @Override
        public Short getGenericLowerControlLimit() {
            return this.getLowerControlLimit();
        }

        @Override
        public short getUpperControlLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsShortImpl)this.delegate).getUpperControlLimit();
            }
            return this.upperControlLimit;
        }

        @Override
        public void setUpperControlLimit(short upperControlLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperControlLimit = upperControlLimit;
        }

        @Override
        public short getLowerControlLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsShortImpl)this.delegate).getLowerControlLimit();
            }
            return this.lowerControlLimit;
        }

        @Override
        public void setLowerControlLimit(short lowerControlLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerControlLimit = lowerControlLimit;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessControlsShortImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            this.serializeGraphics(byteSink);
            byteSink.putShort(this.upperControlLimit);
            byteSink.putShort(this.lowerControlLimit);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessControlsShort asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessControlsShortImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessControlsShortImpl)this.delegate).equals(obj);
            }
            if (!super.equals(obj = ChannelAccessControlsShortImpl.extractDelegate(obj))) {
                return false;
            }
            ChannelAccessControlsShortImpl other = (ChannelAccessControlsShortImpl)obj;
            return new EqualsBuilder().append(this.upperControlLimit, other.upperControlLimit).append(this.lowerControlLimit, other.lowerControlLimit).isEquals();
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsShortImpl)this.delegate).hashCode();
            }
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.upperControlLimit).append(this.lowerControlLimit).toHashCode();
        }

        @Override
        public ChannelAccessControlsShort clone() {
            if (this.delegate != null) {
                return ((ChannelAccessControlsShortImpl)this.delegate).clone();
            }
            return (ChannelAccessControlsShort)super.clone();
        }

        public static ChannelAccessControlsShortImpl deserialize(ByteSource byteSource, int count, Charset charset) {
            ChannelAccessControlsShortImpl value = new ChannelAccessControlsShortImpl(charset);
            value.deserializeAlarms(byteSource);
            value.deserializeGraphics(byteSource);
            value.upperControlLimit = byteSource.getShort();
            value.lowerControlLimit = byteSource.getShort();
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static final class ChannelAccessGraphicsShortImpl
    extends ChannelAccessGraphicsShortBase<ChannelAccessGraphicsShortImpl>
    implements ChannelAccessGraphicsOnlyShort {
        public ChannelAccessGraphicsShortImpl(short[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, String engineeringUnits, short upperDisplayLimit, short lowerDisplayLimit, short upperAlarmLimit, short upperWarningLimit, short lowerWarningLimit, short lowerAlarmLimit, Charset charset) {
            super(value, alarmStatus, alarmSeverity, engineeringUnits, upperDisplayLimit, lowerDisplayLimit, upperAlarmLimit, upperWarningLimit, lowerWarningLimit, lowerAlarmLimit, charset);
        }

        private ChannelAccessGraphicsShortImpl(ChannelAccessGraphicsShortImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessGraphicsShortImpl(Charset charset) {
            super(charset);
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_GR_SHORT;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessGraphicsShortImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            this.serializeGraphics(byteSink);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessGraphicsOnlyShort asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessGraphicsShortImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsShortImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessGraphicsShortImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsShortImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessGraphicsOnlyShort clone() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsShortImpl)this.delegate).clone();
            }
            return (ChannelAccessGraphicsOnlyShort)super.clone();
        }

        public static ChannelAccessGraphicsShortImpl deserialize(ByteSource byteSource, int count, Charset charset) {
            ChannelAccessGraphicsShortImpl value = new ChannelAccessGraphicsShortImpl(charset);
            value.deserializeAlarms(byteSource);
            value.deserializeGraphics(byteSource);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static abstract class ChannelAccessGraphicsShortBase<ImplementationType extends ChannelAccessGraphicsShortBase<ImplementationType>>
    extends ChannelAccessAlarmShortBase<ImplementationType>
    implements ChannelAccessGraphicsShort {
        private static final int ENGINEERING_UNITS_STRING_SIZE = 8;
        protected String engineeringUnits;
        protected byte[] rawEngineeringUnits;
        protected short upperDisplayLimit;
        protected short lowerDisplayLimit;
        protected short upperAlarmLimit;
        protected short upperWarningLimit;
        protected short lowerWarningLimit;
        protected short lowerAlarmLimit;
        protected Charset charset;

        private ChannelAccessGraphicsShortBase(short[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, String engineeringUnits, short upperDisplayLimit, short lowerDisplayLimit, short upperAlarmLimit, short upperWarningLimit, short lowerWarningLimit, short lowerAlarmLimit, Charset charset) {
            super(value, alarmStatus, alarmSeverity);
            this.engineeringUnits = engineeringUnits;
            assert (charset != null);
            this.charset = charset;
            this.rawEngineeringUnits = NullTerminatedStringUtil.stringToTruncatedNullTerminatedFixedBytes(this.engineeringUnits, 8, charset);
            this.upperDisplayLimit = upperDisplayLimit;
            this.lowerDisplayLimit = lowerDisplayLimit;
            this.upperAlarmLimit = upperAlarmLimit;
            this.upperWarningLimit = upperWarningLimit;
            this.lowerWarningLimit = lowerWarningLimit;
            this.lowerAlarmLimit = lowerAlarmLimit;
        }

        private ChannelAccessGraphicsShortBase(ImplementationType delegate) {
            super((ChannelAccessAlarmShortBase)delegate, null);
        }

        private ChannelAccessGraphicsShortBase(Charset charset) {
            this.charset = charset;
        }

        @Override
        public String getUnits() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsShortBase)this.delegate).getUnits();
            }
            return this.engineeringUnits;
        }

        @Override
        public byte[] getRawUnits() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsShortBase)this.delegate).getRawUnits();
            }
            return (byte[])this.rawEngineeringUnits.clone();
        }

        @Override
        public void setUnits(String units) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.engineeringUnits = units;
            this.rawEngineeringUnits = NullTerminatedStringUtil.stringToTruncatedNullTerminatedFixedBytes(this.engineeringUnits, 8, this.charset);
        }

        @Override
        public void setRawUnits(byte[] rawUnits) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.rawEngineeringUnits = new byte[8];
            int copyLength = Math.min(rawUnits.length, 7);
            System.arraycopy(rawUnits, 0, this.rawEngineeringUnits, 0, copyLength);
            this.engineeringUnits = NullTerminatedStringUtil.nullTerminatedBytesToString(this.rawEngineeringUnits, this.charset);
        }

        @Override
        public Short getGenericUpperDisplayLimit() {
            return this.getUpperDisplayLimit();
        }

        @Override
        public Short getGenericLowerDisplayLimit() {
            return this.getLowerDisplayLimit();
        }

        @Override
        public Short getGenericUpperAlarmLimit() {
            return this.getUpperAlarmLimit();
        }

        @Override
        public Short getGenericUpperWarningLimit() {
            return this.getUpperWarningLimit();
        }

        @Override
        public Short getGenericLowerWarningLimit() {
            return this.getLowerWarningLimit();
        }

        @Override
        public Short getGenericLowerAlarmLimit() {
            return this.getLowerAlarmLimit();
        }

        @Override
        public Charset getCharset() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsShortBase)this.delegate).getCharset();
            }
            return this.charset;
        }

        @Override
        public short getUpperDisplayLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsShortBase)this.delegate).getUpperDisplayLimit();
            }
            return this.upperDisplayLimit;
        }

        @Override
        public void setUpperDisplayLimit(short upperDisplayLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperDisplayLimit = upperDisplayLimit;
        }

        @Override
        public short getLowerDisplayLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsShortBase)this.delegate).getLowerDisplayLimit();
            }
            return this.lowerDisplayLimit;
        }

        @Override
        public void setLowerDisplayLimit(short lowerDisplayLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerDisplayLimit = lowerDisplayLimit;
        }

        @Override
        public short getUpperAlarmLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsShortBase)this.delegate).getUpperAlarmLimit();
            }
            return this.upperAlarmLimit;
        }

        @Override
        public void setUpperAlarmLimit(short upperAlarmLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperAlarmLimit = upperAlarmLimit;
        }

        @Override
        public short getUpperWarningLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsShortBase)this.delegate).getUpperWarningLimit();
            }
            return this.upperWarningLimit;
        }

        @Override
        public void setUpperWarningLimit(short upperWarningLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.upperWarningLimit = upperWarningLimit;
        }

        @Override
        public short getLowerWarningLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsShortBase)this.delegate).getLowerWarningLimit();
            }
            return this.lowerWarningLimit;
        }

        @Override
        public void setLowerWarningLimit(short lowerWarningLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerWarningLimit = lowerWarningLimit;
        }

        @Override
        public short getLowerAlarmLimit() {
            if (this.delegate != null) {
                return ((ChannelAccessGraphicsShortBase)this.delegate).getLowerAlarmLimit();
            }
            return this.lowerAlarmLimit;
        }

        @Override
        public void setLowerAlarmLimit(short lowerAlarmLimit) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.lowerAlarmLimit = lowerAlarmLimit;
        }

        protected void deserializeGraphics(ByteSource byteSource) {
            this.rawEngineeringUnits = byteSource.getByteArray(8);
            this.rawEngineeringUnits[7] = 0;
            this.engineeringUnits = NullTerminatedStringUtil.nullTerminatedBytesToString(this.rawEngineeringUnits, this.charset);
            this.upperDisplayLimit = byteSource.getShort();
            this.lowerDisplayLimit = byteSource.getShort();
            this.upperAlarmLimit = byteSource.getShort();
            this.upperWarningLimit = byteSource.getShort();
            this.lowerWarningLimit = byteSource.getShort();
            this.lowerAlarmLimit = byteSource.getShort();
        }

        protected void serializeGraphics(ByteSink byteSink) {
            byteSink.putByteArray(this.rawEngineeringUnits);
            byteSink.putShort(this.upperDisplayLimit);
            byteSink.putShort(this.lowerDisplayLimit);
            byteSink.putShort(this.upperAlarmLimit);
            byteSink.putShort(this.upperWarningLimit);
            byteSink.putShort(this.lowerWarningLimit);
            byteSink.putShort(this.lowerAlarmLimit);
        }

        @Override
        public boolean equals(Object obj) {
            assert (!this.isReadOnly());
            if (!super.equals(obj)) {
                return false;
            }
            ChannelAccessGraphicsShortBase other = (ChannelAccessGraphicsShortBase)obj;
            return new EqualsBuilder().append((Object)this.engineeringUnits, (Object)other.engineeringUnits).append(this.rawEngineeringUnits, other.rawEngineeringUnits).append(this.upperDisplayLimit, other.upperDisplayLimit).append(this.lowerDisplayLimit, other.lowerDisplayLimit).append(this.upperAlarmLimit, other.upperAlarmLimit).append(this.upperWarningLimit, other.upperWarningLimit).append(this.lowerWarningLimit, other.lowerWarningLimit).append(this.lowerAlarmLimit, other.lowerAlarmLimit).append((Object)this.charset, (Object)other.charset).isEquals();
        }

        @Override
        public int hashCode() {
            assert (!this.isReadOnly());
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.engineeringUnits).append(this.rawEngineeringUnits).append(this.upperDisplayLimit).append(this.lowerDisplayLimit).append(this.upperAlarmLimit).append(this.upperWarningLimit).append(this.lowerWarningLimit).append(this.lowerAlarmLimit).append((Object)this.charset).toHashCode();
        }

        @Override
        public ChannelAccessGraphicsShort clone() {
            assert (!this.isReadOnly());
            return (ChannelAccessGraphicsShort)super.clone();
        }

        /* synthetic */ ChannelAccessGraphicsShortBase(ChannelAccessGraphicsShortBase x0, 1 x1) {
            this(x0);
        }
    }

    public static final class ChannelAccessTimeShortImpl
    extends ChannelAccessAlarmShortBase<ChannelAccessTimeShortImpl>
    implements ChannelAccessTimeShort {
        protected int timeStampSeconds;
        protected int timeStampNanoseconds;

        public ChannelAccessTimeShortImpl(short[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, int timeStampSeconds, int timeStampNanoSeconds) {
            super(value, alarmStatus, alarmSeverity);
            this.timeStampSeconds = timeStampSeconds;
            if (timeStampNanoSeconds < 0 || timeStampNanoSeconds > 999999999) {
                throw new IllegalArgumentException("Nanoseconds part of timestamp must be a number between 0 and 999999999.");
            }
            this.timeStampNanoseconds = timeStampNanoSeconds;
        }

        private ChannelAccessTimeShortImpl(ChannelAccessTimeShortImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessTimeShortImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_TIME_SHORT;
        }

        @Override
        public ChannelAccessTimeStamp getTimeStamp() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeShortImpl)this.delegate).getTimeStamp();
            }
            return ChannelAccessValueFactory.createTimeStamp(this.timeStampSeconds, this.timeStampNanoseconds);
        }

        @Override
        public int getTimeSeconds() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeShortImpl)this.delegate).getTimeSeconds();
            }
            return this.timeStampSeconds;
        }

        @Override
        public int getTimeNanoseconds() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeShortImpl)this.delegate).getTimeNanoseconds();
            }
            return this.timeStampNanoseconds;
        }

        @Override
        public void setTimeStamp(ChannelAccessTimeStamp timeStamp) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.timeStampSeconds = timeStamp.getSeconds();
            this.timeStampNanoseconds = timeStamp.getNanoseconds();
        }

        @Override
        public void setTimeSeconds(int timeStampSeconds) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.timeStampSeconds = timeStampSeconds;
        }

        @Override
        public void setTimeNanoseconds(int timeStampNanoseconds) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            if (timeStampNanoseconds < 0 || timeStampNanoseconds > 999999999) {
                throw new IllegalArgumentException("Nanoseconds part of time-stamp must be a number between 0 and 999999999.");
            }
            this.timeStampNanoseconds = timeStampNanoseconds;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessTimeShortImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            ValueCodecUtils.serializeTime(byteSink, this.timeStampSeconds, this.timeStampNanoseconds);
            byteSink.putShort((short)0);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessTimeShort asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessTimeShortImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessTimeShortImpl)this.delegate).equals(obj);
            }
            if (!super.equals(obj = ChannelAccessTimeShortImpl.extractDelegate(obj))) {
                return false;
            }
            ChannelAccessTimeShortImpl other = (ChannelAccessTimeShortImpl)obj;
            return new EqualsBuilder().append(this.timeStampSeconds, other.timeStampSeconds).append(this.timeStampNanoseconds, other.timeStampNanoseconds).isEquals();
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeShortImpl)this.delegate).hashCode();
            }
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.timeStampSeconds).append(this.timeStampNanoseconds).toHashCode();
        }

        @Override
        public ChannelAccessTimeShort clone() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeShortImpl)this.delegate).clone();
            }
            return (ChannelAccessTimeShort)super.clone();
        }

        public static ChannelAccessTimeShortImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessTimeShortImpl value = new ChannelAccessTimeShortImpl();
            value.deserializeAlarms(byteSource);
            value.timeStampSeconds = ValueCodecUtils.deserializeTimeSeconds(byteSource);
            value.timeStampNanoseconds = ValueCodecUtils.deserializeTimeNanoseconds(byteSource);
            byteSource.skip(2);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static final class ChannelAccessAlarmShortImpl
    extends ChannelAccessAlarmShortBase<ChannelAccessAlarmShortImpl>
    implements ChannelAccessAlarmOnlyShort {
        public ChannelAccessAlarmShortImpl(short[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity) {
            super(value, alarmStatus, alarmSeverity);
        }

        private ChannelAccessAlarmShortImpl(ChannelAccessAlarmShortImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessAlarmShortImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_STS_SHORT;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessAlarmShortImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeAlarms(byteSink);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessAlarmOnlyShort asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessAlarmShortImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmShortImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessAlarmShortImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmShortImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessAlarmOnlyShort clone() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmShortImpl)this.delegate).clone();
            }
            return (ChannelAccessAlarmOnlyShort)super.clone();
        }

        public static ChannelAccessAlarmShortImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessAlarmShortImpl value = new ChannelAccessAlarmShortImpl();
            value.deserializeAlarms(byteSource);
            value.deserializeValue(byteSource, count);
            return value;
        }
    }

    public static abstract class ChannelAccessAlarmShortBase<ImplementationType extends ChannelAccessAlarmShortBase<ImplementationType>>
    extends ChannelAccessShortBase<ImplementationType>
    implements ChannelAccessAlarmShort {
        protected ChannelAccessAlarmStatus alarmStatus;
        protected ChannelAccessAlarmSeverity alarmSeverity;

        private ChannelAccessAlarmShortBase(short[] value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity) {
            super(value);
            this.alarmStatus = alarmStatus;
            this.alarmSeverity = alarmSeverity;
        }

        private ChannelAccessAlarmShortBase(ImplementationType delegate) {
            super((ChannelAccessShortBase)delegate, null);
        }

        private ChannelAccessAlarmShortBase() {
        }

        @Override
        public ChannelAccessAlarmStatus getAlarmStatus() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmShortBase)this.delegate).getAlarmStatus();
            }
            return this.alarmStatus;
        }

        @Override
        public void setAlarmStatus(ChannelAccessAlarmStatus alarmStatus) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            assert (alarmStatus != null);
            this.alarmStatus = alarmStatus;
        }

        @Override
        public ChannelAccessAlarmSeverity getAlarmSeverity() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmShortBase)this.delegate).getAlarmSeverity();
            }
            return this.alarmSeverity;
        }

        @Override
        public void setAlarmSeverity(ChannelAccessAlarmSeverity alarmSeverity) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            assert (alarmSeverity != null);
            this.alarmSeverity = alarmSeverity;
        }

        protected void deserializeAlarms(ByteSource byteSource) {
            this.alarmStatus = ValueCodecUtils.deserializeAlarmStatus(byteSource);
            this.alarmSeverity = ValueCodecUtils.deserializeAlarmSeverity(byteSource);
        }

        protected void serializeAlarms(ByteSink byteSink) {
            ValueCodecUtils.serializeAlarms(byteSink, this.alarmStatus, this.alarmSeverity);
        }

        @Override
        public boolean equals(Object obj) {
            assert (!this.isReadOnly());
            if (!super.equals(obj)) {
                return false;
            }
            ChannelAccessAlarmShortBase other = (ChannelAccessAlarmShortBase)obj;
            return new EqualsBuilder().append((Object)this.alarmStatus, (Object)other.alarmStatus).append((Object)this.alarmSeverity, (Object)other.alarmSeverity).isEquals();
        }

        @Override
        public int hashCode() {
            assert (!this.isReadOnly());
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.alarmStatus).append((Object)this.alarmSeverity).toHashCode();
        }

        @Override
        public ChannelAccessAlarmShort clone() {
            assert (!this.isReadOnly());
            return (ChannelAccessAlarmShort)super.clone();
        }

        /* synthetic */ ChannelAccessAlarmShortBase(ChannelAccessAlarmShortBase x0, 1 x1) {
            this(x0);
        }
    }

    public static final class ChannelAccessShortImpl
    extends ChannelAccessShortBase<ChannelAccessShortImpl>
    implements ChannelAccessSimpleOnlyShort {
        public ChannelAccessShortImpl(short[] value) {
            super(value);
        }

        private ChannelAccessShortImpl(ChannelAccessShortImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessShortImpl() {
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_SHORT;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessShortImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.length);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessSimpleOnlyShort asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessShortImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessShortImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessShortImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessShortImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessSimpleOnlyShort clone() {
            if (this.delegate != null) {
                return ((ChannelAccessShortImpl)this.delegate).clone();
            }
            return (ChannelAccessSimpleOnlyShort)super.clone();
        }

        public static ChannelAccessShortImpl deserialize(ByteSource byteSource, int count) {
            ChannelAccessShortImpl value = new ChannelAccessShortImpl();
            value.deserializeValue(byteSource, count);
            return value;
        }
    }
}

