/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value.internal;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmOnlyString;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmSeverity;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmStatus;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmString;
import com.aquenos.epics.jackie.common.value.ChannelAccessSimpleOnlyString;
import com.aquenos.epics.jackie.common.value.ChannelAccessString;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeStamp;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeString;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueCodec;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueFactory;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import com.aquenos.epics.jackie.common.value.internal.AbstractStringBase;
import com.aquenos.epics.jackie.common.value.internal.ValueCodecUtils;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class ChannelAccessStringBase<ImplementationType extends ChannelAccessStringBase<ImplementationType>>
extends AbstractStringBase<ImplementationType>
implements ChannelAccessString {
    private ChannelAccessStringBase(Collection<String> value, Charset charset) {
        super(value, charset);
    }

    private ChannelAccessStringBase(ImplementationType delegate) {
        super(delegate);
    }

    private ChannelAccessStringBase(Charset charset) {
        super(charset);
    }

    @Override
    public ChannelAccessString clone() {
        assert (!this.isReadOnly());
        ChannelAccessStringBase copy = (ChannelAccessStringBase)super.clone();
        return copy;
    }

    /* synthetic */ ChannelAccessStringBase(ChannelAccessStringBase x0, 1 x1) {
        this(x0);
    }

    public static final class ChannelAccessTimeStringImpl
    extends ChannelAccessAlarmStringBase<ChannelAccessTimeStringImpl>
    implements ChannelAccessTimeString {
        private static final int META_DATA_SIZE = ChannelAccessValueCodec.calculatePayloadSize(ChannelAccessValueType.DBR_TIME_STRING, 0);
        protected int timeStampSeconds;
        protected int timeStampNanoseconds;

        public ChannelAccessTimeStringImpl(Collection<String> value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, int timeStampSeconds, int timeStampNanoSeconds, Charset charset) {
            super(value, alarmStatus, alarmSeverity, charset);
            this.timeStampSeconds = timeStampSeconds;
            if (timeStampNanoSeconds < 0 || timeStampNanoSeconds > 999999999) {
                throw new IllegalArgumentException("Nanoseconds part of timestamp must be a number between 0 and 999999999.");
            }
            this.timeStampNanoseconds = timeStampNanoSeconds;
        }

        private ChannelAccessTimeStringImpl(ChannelAccessTimeStringImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessTimeStringImpl(Charset charset) {
            super(charset);
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_TIME_STRING;
        }

        @Override
        public ChannelAccessTimeStamp getTimeStamp() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeStringImpl)this.delegate).getTimeStamp();
            }
            return ChannelAccessValueFactory.createTimeStamp(this.timeStampSeconds, this.timeStampNanoseconds);
        }

        @Override
        public int getTimeSeconds() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeStringImpl)this.delegate).getTimeSeconds();
            }
            return this.timeStampSeconds;
        }

        @Override
        public int getTimeNanoseconds() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeStringImpl)this.delegate).getTimeNanoseconds();
            }
            return this.timeStampNanoseconds;
        }

        @Override
        public void setTimeStamp(ChannelAccessTimeStamp timeStamp) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.timeStampSeconds = timeStamp.getSeconds();
            this.timeStampNanoseconds = timeStamp.getNanoseconds();
        }

        @Override
        public void setTimeSeconds(int timeStampSeconds) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            this.timeStampSeconds = timeStampSeconds;
        }

        @Override
        public void setTimeNanoseconds(int timeStampNanoseconds) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            if (timeStampNanoseconds < 0 || timeStampNanoseconds > 999999999) {
                throw new IllegalArgumentException("Nanoseconds part of time-stamp must be a number between 0 and 999999999.");
            }
            this.timeStampNanoseconds = timeStampNanoseconds;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessTimeStringImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.size());
            this.serializeAlarms(byteSink);
            ValueCodecUtils.serializeTime(byteSink, this.timeStampSeconds, this.timeStampNanoseconds);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessTimeString asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessTimeStringImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessTimeStringImpl)this.delegate).equals(obj);
            }
            if (!super.equals(obj = ChannelAccessTimeStringImpl.extractDelegate(obj))) {
                return false;
            }
            ChannelAccessTimeStringImpl other = (ChannelAccessTimeStringImpl)obj;
            return new EqualsBuilder().append(this.timeStampSeconds, other.timeStampSeconds).append(this.timeStampNanoseconds, other.timeStampNanoseconds).isEquals();
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeStringImpl)this.delegate).hashCode();
            }
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.timeStampSeconds).append(this.timeStampNanoseconds).toHashCode();
        }

        @Override
        public ChannelAccessTimeString clone() {
            if (this.delegate != null) {
                return ((ChannelAccessTimeStringImpl)this.delegate).clone();
            }
            return (ChannelAccessTimeString)super.clone();
        }

        public static ChannelAccessTimeStringImpl deserialize(ByteSource byteSource, int numberOfBytes, int count, Charset charset) {
            ChannelAccessTimeStringImpl value = new ChannelAccessTimeStringImpl(charset);
            value.deserializeAlarms(byteSource);
            value.timeStampSeconds = ValueCodecUtils.deserializeTimeSeconds(byteSource);
            value.timeStampNanoseconds = ValueCodecUtils.deserializeTimeNanoseconds(byteSource);
            value.deserializeValue(byteSource, numberOfBytes - META_DATA_SIZE, count);
            return value;
        }
    }

    public static final class ChannelAccessAlarmStringImpl
    extends ChannelAccessAlarmStringBase<ChannelAccessAlarmStringImpl>
    implements ChannelAccessAlarmOnlyString {
        private static final int META_DATA_SIZE = ChannelAccessValueCodec.calculatePayloadSize(ChannelAccessValueType.DBR_STS_STRING, 0);
        protected ChannelAccessValueType type;

        public ChannelAccessAlarmStringImpl(ChannelAccessValueType type, Collection<String> value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, Charset charset) {
            super(value, alarmStatus, alarmSeverity, charset);
            assert (type == ChannelAccessValueType.DBR_STS_STRING || type == ChannelAccessValueType.DBR_GR_STRING || type == ChannelAccessValueType.DBR_CTRL_STRING);
            this.type = type;
        }

        private ChannelAccessAlarmStringImpl(ChannelAccessAlarmStringImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessAlarmStringImpl(ChannelAccessValueType type, Charset charset) {
            super(charset);
            assert (type == ChannelAccessValueType.DBR_STS_STRING || type == ChannelAccessValueType.DBR_GR_STRING || type == ChannelAccessValueType.DBR_CTRL_STRING);
            this.type = type;
        }

        @Override
        public ChannelAccessValueType getType() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmStringImpl)this.delegate).getType();
            }
            return this.type;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessAlarmStringImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.size());
            this.serializeAlarms(byteSink);
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessAlarmOnlyString asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessAlarmStringImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmStringImpl)this.delegate).equals(obj);
            }
            if (!super.equals(obj = ChannelAccessAlarmStringImpl.extractDelegate(obj))) {
                return false;
            }
            ChannelAccessAlarmStringImpl other = (ChannelAccessAlarmStringImpl)obj;
            return this.type.equals((Object)other.type);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmStringImpl)this.delegate).hashCode();
            }
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.type).toHashCode();
        }

        @Override
        public ChannelAccessAlarmOnlyString clone() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmStringImpl)this.delegate).clone();
            }
            return (ChannelAccessAlarmOnlyString)super.clone();
        }

        public static ChannelAccessAlarmStringImpl deserialize(ChannelAccessValueType type, ByteSource byteSource, int numberOfBytes, int count, Charset charset) {
            ChannelAccessAlarmStringImpl value = new ChannelAccessAlarmStringImpl(type, charset);
            value.deserializeAlarms(byteSource);
            value.deserializeValue(byteSource, numberOfBytes - META_DATA_SIZE, count);
            return value;
        }
    }

    public static abstract class ChannelAccessAlarmStringBase<ImplementationType extends ChannelAccessAlarmStringBase<ImplementationType>>
    extends ChannelAccessStringBase<ImplementationType>
    implements ChannelAccessAlarmString {
        protected ChannelAccessAlarmStatus alarmStatus;
        protected ChannelAccessAlarmSeverity alarmSeverity;

        private ChannelAccessAlarmStringBase(Collection<String> value, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity, Charset charset) {
            super(value, charset);
            this.alarmStatus = alarmStatus;
            this.alarmSeverity = alarmSeverity;
        }

        private ChannelAccessAlarmStringBase(ImplementationType delegate) {
            super((ChannelAccessStringBase)delegate, null);
        }

        private ChannelAccessAlarmStringBase(Charset charset) {
            super(charset);
        }

        @Override
        public ChannelAccessAlarmStatus getAlarmStatus() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmStringBase)this.delegate).getAlarmStatus();
            }
            return this.alarmStatus;
        }

        @Override
        public void setAlarmStatus(ChannelAccessAlarmStatus alarmStatus) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            assert (alarmStatus != null);
            this.alarmStatus = alarmStatus;
        }

        @Override
        public ChannelAccessAlarmSeverity getAlarmSeverity() {
            if (this.delegate != null) {
                return ((ChannelAccessAlarmStringBase)this.delegate).getAlarmSeverity();
            }
            return this.alarmSeverity;
        }

        @Override
        public void setAlarmSeverity(ChannelAccessAlarmSeverity alarmSeverity) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("Cannot modify a read-only value.");
            }
            assert (alarmSeverity != null);
            this.alarmSeverity = alarmSeverity;
        }

        protected void deserializeAlarms(ByteSource byteSource) {
            this.alarmStatus = ValueCodecUtils.deserializeAlarmStatus(byteSource);
            this.alarmSeverity = ValueCodecUtils.deserializeAlarmSeverity(byteSource);
        }

        protected void serializeAlarms(ByteSink byteSink) {
            ValueCodecUtils.serializeAlarms(byteSink, this.alarmStatus, this.alarmSeverity);
        }

        @Override
        public boolean equals(Object obj) {
            assert (!this.isReadOnly());
            if (!super.equals(obj)) {
                return false;
            }
            ChannelAccessAlarmStringBase other = (ChannelAccessAlarmStringBase)obj;
            return new EqualsBuilder().append((Object)this.alarmStatus, (Object)other.alarmStatus).append((Object)this.alarmSeverity, (Object)other.alarmSeverity).isEquals();
        }

        @Override
        public int hashCode() {
            assert (!this.isReadOnly());
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.alarmStatus).append((Object)this.alarmSeverity).toHashCode();
        }

        @Override
        public ChannelAccessAlarmString clone() {
            assert (!this.isReadOnly());
            return (ChannelAccessAlarmString)super.clone();
        }

        /* synthetic */ ChannelAccessAlarmStringBase(ChannelAccessAlarmStringBase x0, 1 x1) {
            this(x0);
        }
    }

    public static final class ChannelAccessStringImpl
    extends ChannelAccessStringBase<ChannelAccessStringImpl>
    implements ChannelAccessSimpleOnlyString {
        public ChannelAccessStringImpl(Collection<String> value, Charset charset) {
            super(value, charset);
        }

        private ChannelAccessStringImpl(ChannelAccessStringImpl delegate) {
            super(delegate, null);
        }

        private ChannelAccessStringImpl(Charset charset) {
            super(charset);
        }

        @Override
        public ChannelAccessValueType getType() {
            return ChannelAccessValueType.DBR_STRING;
        }

        @Override
        public void serialize(ByteSink byteSink, int count) {
            if (this.delegate != null) {
                ((ChannelAccessStringImpl)this.delegate).serialize(byteSink, count);
                return;
            }
            assert (count >= 0);
            assert (count <= this.value.size());
            this.serializeValue(byteSink, count);
        }

        @Override
        public ChannelAccessSimpleOnlyString asReadOnlyValue() {
            if (this.delegate != null) {
                return this;
            }
            return new ChannelAccessStringImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.delegate != null) {
                return ((ChannelAccessStringImpl)this.delegate).equals(obj);
            }
            obj = ChannelAccessStringImpl.extractDelegate(obj);
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return ((ChannelAccessStringImpl)this.delegate).hashCode();
            }
            return super.hashCode();
        }

        @Override
        public ChannelAccessSimpleOnlyString clone() {
            if (this.delegate != null) {
                return ((ChannelAccessStringImpl)this.delegate).clone();
            }
            return (ChannelAccessSimpleOnlyString)super.clone();
        }

        public static ChannelAccessStringImpl deserialize(ByteSource byteSource, int numberOfBytes, int count, Charset charset) {
            ChannelAccessStringImpl value = new ChannelAccessStringImpl(charset);
            value.deserializeValue(byteSource, numberOfBytes, count);
            return value;
        }
    }
}

