/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value.internal;

import com.aquenos.epics.jackie.common.value.ChannelAccessTimeStamp;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ChannelAccessTimeStampImpl
implements ChannelAccessTimeStamp {
    private static final BigInteger ONE_BILLION = BigInteger.valueOf(1000000000L);
    private static final long OFFSET_EPICS_TO_UNIX_EPOCH = 631152000L;
    private int seconds;
    private int nanoseconds;

    public ChannelAccessTimeStampImpl(int seconds, int nanoseconds) {
        this.seconds = seconds;
        if (nanoseconds > 999999999) {
            nanoseconds = 999999999;
        } else if (nanoseconds < 0) {
            nanoseconds = 0;
        }
        this.nanoseconds = nanoseconds;
    }

    @Override
    public int compareTo(ChannelAccessTimeStamp o) {
        if (!(o instanceof ChannelAccessTimeStampImpl)) {
            return new CompareToBuilder().append(this.seconds, o.getSeconds()).append(this.nanoseconds, o.getNanoseconds()).build();
        }
        ChannelAccessTimeStampImpl other = (ChannelAccessTimeStampImpl)o;
        return new CompareToBuilder().append(this.seconds, other.seconds).append(this.nanoseconds, other.nanoseconds).build();
    }

    @Override
    public int getSeconds() {
        return this.seconds;
    }

    @Override
    public int getNanoseconds() {
        return this.nanoseconds;
    }

    @Override
    public BigInteger toNanosecondsEPICS() {
        long longSeconds = this.seconds;
        if (longSeconds < 0L) {
            longSeconds += 0x100000000L;
        }
        return BigInteger.valueOf(longSeconds).multiply(ONE_BILLION).add(BigInteger.valueOf(this.nanoseconds));
    }

    @Override
    public BigInteger toNanosecondsUNIX() {
        long longSeconds = this.seconds;
        if (longSeconds < 0L) {
            longSeconds += 0x100000000L;
        }
        return BigInteger.valueOf(longSeconds += 631152000L).multiply(ONE_BILLION).add(BigInteger.valueOf(this.nanoseconds));
    }

    @Override
    public long toJavaTimeStamp() {
        long longSeconds = this.seconds;
        if (longSeconds < 0L) {
            longSeconds += 0x100000000L;
        }
        return (longSeconds += 631152000L) * 1000L;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.seconds).append(this.nanoseconds).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelAccessTimeStampImpl)) {
            return false;
        }
        ChannelAccessTimeStampImpl other = (ChannelAccessTimeStampImpl)obj;
        return this.seconds == other.seconds && this.nanoseconds == other.nanoseconds;
    }

    public String toString() {
        StringBuilder nanosecondsString = new StringBuilder(9);
        nanosecondsString.append(this.nanoseconds);
        while (nanosecondsString.length() < 9) {
            nanosecondsString.insert(0, '0');
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.######### zzz", Locale.US).format(new Date(this.toJavaTimeStamp())).replace("#########", nanosecondsString);
    }
}

